/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.intfce.sku.impl;

import com.ohaotian.commodity.atom.sku.UpdateSkuAtomService;
import com.ohaotian.commodity.atom.sku.bo.SkuBO;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuPicMapper;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuSpec;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.intfce.sku.InitSkuFodderRelationService;
import com.xls.commodity.intfce.sku.RelieveSkuFodderService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.RelieveSkuFodderRelationReqBO;
import com.xls.commodity.intfce.sku.bo.RelieveSkuFodderReqBO;
import com.xls.commodity.intfce.sku.bo.RelieveSkuReqBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RelieveSkuFodderServiceImpl
implements RelieveSkuFodderService {
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private InitSkuFodderRelationService initSkuFodderRelationService;
    @Autowired
    private SkuPicMapper skuPicMapper;
    @Autowired
    private SkuSpecMapper skuSpecMapper;
    @Autowired
    private UpdateSkuAtomService updateSkuAtomService;
    private static final Logger logger = LoggerFactory.getLogger(RelieveSkuFodderServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();

    public BaseRspBO relieveSkuFodder(RelieveSkuFodderReqBO relieveSkuFodderReqBO) {
        logger.info("\u89e3\u9664\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1\u5165\u53c2\uff1a" + relieveSkuFodderReqBO.toString());
        BaseRspBO baseRspBO = new BaseRspBO();
        try {
            if (relieveSkuFodderReqBO.getRelieveSkuReqBOs().size() > 0) {
                List relieveSkuReqBOs = relieveSkuFodderReqBO.getRelieveSkuReqBOs();
                for (RelieveSkuReqBO relieveSkuReqBO : relieveSkuReqBOs) {
                    SkuBO skuBO;
                    String extSkuId = relieveSkuReqBO.getExtSkuId();
                    Long supplierId = relieveSkuReqBO.getSupplierId();
                    if (extSkuId == null || supplierId == null) continue;
                    Sku sku = this.skuMapper.selectByExtSkuIdAndSupplierId(extSkuId, supplierId);
                    RelieveSkuFodderRelationReqBO relieveSkuFodderRelationReqBO = new RelieveSkuFodderRelationReqBO();
                    relieveSkuFodderRelationReqBO.setFodderId(relieveSkuFodderReqBO.getFodderId());
                    relieveSkuFodderRelationReqBO.setSkuId(sku.getSkuId());
                    relieveSkuFodderRelationReqBO.setSupplierId(supplierId);
                    this.initSkuFodderRelationService.relieveSkuFodderRelation(relieveSkuFodderRelationReqBO);
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    skuIds.add(sku.getSkuId());
                    this.skuPicMapper.deleteBySkuIdBatch(skuIds, supplierId);
                    SkuSpec record = new SkuSpec();
                    record.setSupplierId(supplierId);
                    record.setSkuId(sku.getSkuId());
                    this.skuSpecMapper.deleteByMany(record);
                    if (sku.getSkuStatus() == 0) {
                        logger.info("\u5546\u54c1\u72b6\u6001\u4e3a\u8349\u7a3f\u72b6\u6001\uff0c\u53ea\u6709\u7d20\u6750\uff0c\u6ca1\u6709erp\u540c\u6b65");
                        this.skuMapper.deleteByPrimaryKey(sku.getSkuId());
                        continue;
                    }
                    if (sku.getSkuStatus() == 2) {
                        logger.info("\u5546\u54c1\u72b6\u6001\u4e3a\u4e0a\u67b6\u72b6\u6001\uff0c\u7d20\u6750\u548cerp\u90fd\u5728");
                        skuBO = new SkuBO();
                        skuBO.setExtSkuId(relieveSkuReqBO.getExtSkuId());
                        skuBO.setMaterialId(relieveSkuReqBO.getMaterialId());
                        skuBO.setSupplierId(relieveSkuReqBO.getSupplierId());
                        skuBO.setSkuStatus(Integer.valueOf(1));
                        this.updateSkuAtomService.updateSku(skuBO);
                        continue;
                    }
                    if (sku.getSkuStatus() != 5) continue;
                    logger.info("\u5546\u54c1\u72b6\u6001\u4e3a\u4e0a\u67b6\u72b6\u6001\uff0c\u7d20\u6750\u548cerp\u90fd\u5728");
                    skuBO = new SkuBO();
                    skuBO.setExtSkuId(relieveSkuReqBO.getExtSkuId());
                    skuBO.setMaterialId(relieveSkuReqBO.getMaterialId());
                    skuBO.setSupplierId(relieveSkuReqBO.getSupplierId());
                    skuBO.setSkuStatus(Integer.valueOf(4));
                    this.updateSkuAtomService.updateSku(skuBO);
                }
                baseRspBO.setRespCode("0000");
                baseRspBO.setRespDesc("\u6210\u529f");
                logger.error("\u89e3\u9664\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1\u7ed3\u675f");
            } else {
                baseRspBO.setRespCode("8888");
                baseRspBO.setRespDesc("\u9700\u8981\u89e3\u9664\u7d20\u6750\u7684\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u9664\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e.getMessage());
            baseRspBO.setRespCode("8888");
            baseRspBO.setRespDesc("\u89e3\u9664\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38");
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u89e3\u9664\u5355\u54c1\u7d20\u6750\u548c\u5bf9\u5e94\u5546\u54c1\u670d\u52a1-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38" + e.getMessage());
        }
        return baseRspBO;
    }
}

