/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.ohaotian.commodity.custom.search.bo.SearchEsSQLXlsRspBO;
import com.xls.commodity.busi.sku.BuildEsSqlService;
import com.xls.commodity.busi.sku.bo.BuildEsSqlReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuBasicDataReqBO;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BuildEsSqlServiceImpl
implements BuildEsSqlService {
    private static final Logger logger = LoggerFactory.getLogger(BuildEsSqlServiceImpl.class);

    public SearchEsSQLXlsRspBO buildEsSql(BuildEsSqlReqBO buildEsSqlReqBO) {
        BoolQueryBuilder boolQueryBuilder1;
        SearchEsSQLXlsRspBO searchEsSQLXlsRspBO = new SearchEsSQLXlsRspBO();
        CollapseBuilder collapseBuilder = new CollapseBuilder("commodity_id");
        InnerHitBuilder innerHit = new InnerHitBuilder("group_by");
        ArrayList<FieldSortBuilder> sorts = new ArrayList<FieldSortBuilder>();
        SortOrder orderSalePrice = SortOrder.ASC;
        FieldSortBuilder fsb = (FieldSortBuilder)SortBuilders.fieldSort((String)"sale_price").order(orderSalePrice);
        sorts.add(fsb);
        innerHit.setSorts(sorts);
        innerHit.setSize(1);
        collapseBuilder.setInnerHits(innerHit);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)2));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cg_type", (int)601));
        if (buildEsSqlReqBO.getGuideCatalogId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (String)(buildEsSqlReqBO.getGuideCatalogId() + "*~~" + "0")));
        }
        BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
        ExistsQueryBuilder existsQueryBuilder = new ExistsQueryBuilder("member_ladder_price2");
        boolQueryBuilder2.must((QueryBuilder)existsQueryBuilder);
        boolQueryBuilder.must((QueryBuilder)boolQueryBuilder2);
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getQueryStr())) {
            boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)buildEsSqlReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_long_name", (Object)buildEsSqlReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"commodity_name", (Object)buildEsSqlReqBO.getQueryStr()));
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"commodity_long_name", (Object)buildEsSqlReqBO.getQueryStr()));
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilder1);
        }
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getBrandStr())) {
            boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder1.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)buildEsSqlReqBO.getBrandStr()));
        }
        SortOrder orderType = SortOrder.ASC;
        String sortField = "sale_price";
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
        searchEsSQLXlsRspBO.setCollapseBuilder(collapseBuilder);
        searchEsSQLXlsRspBO.setBoolQueryBuilder(boolQueryBuilder);
        searchEsSQLXlsRspBO.setSortQuery(sortQuery);
        searchEsSQLXlsRspBO.setPageNo(buildEsSqlReqBO.getPageNo());
        searchEsSQLXlsRspBO.setPageSize(buildEsSqlReqBO.getPageSize());
        logger.info("\u62fc\u63a5es\u67e5\u8be2\u6761\u4ef6\u670d\u52a1\u51fa\u53c2=" + searchEsSQLXlsRspBO.toString());
        return searchEsSQLXlsRspBO;
    }

    public SearchEsSQLXlsRspBO buildBindEsSql(BuildEsSqlReqBO buildEsSqlReqBO) {
        SearchEsSQLXlsRspBO searchEsSQLXlsRspBO = new SearchEsSQLXlsRspBO();
        CollapseBuilder collapseBuilder = new CollapseBuilder("material_id");
        InnerHitBuilder innerHit = new InnerHitBuilder("group_by");
        innerHit.setSize(1);
        collapseBuilder.setInnerHits(innerHit);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_delete", (int)0));
        if (StringUtils.isNotEmpty((CharSequence)buildEsSqlReqBO.getExtSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_sku_id", (String)buildEsSqlReqBO.getExtSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getMaterialId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_id", (String)buildEsSqlReqBO.getMaterialId()));
        }
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getProvinceCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"province_code", (String)buildEsSqlReqBO.getProvinceCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getBrandStr())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)buildEsSqlReqBO.getBrandStr()));
        }
        if (StringUtils.isNotBlank((CharSequence)buildEsSqlReqBO.getQueryStr())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)buildEsSqlReqBO.getQueryStr()));
        }
        SortOrder orderType = SortOrder.DESC;
        String sortField = "create_time";
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
        searchEsSQLXlsRspBO.setCollapseBuilder(collapseBuilder);
        searchEsSQLXlsRspBO.setBoolQueryBuilder(boolQueryBuilder);
        searchEsSQLXlsRspBO.setSortQuery(sortQuery);
        searchEsSQLXlsRspBO.setPageNo(buildEsSqlReqBO.getPageNo());
        searchEsSQLXlsRspBO.setPageSize(buildEsSqlReqBO.getPageSize());
        logger.info("\u62fc\u63a5es\u67e5\u8be2\u6761\u4ef6\u670d\u52a1\u51fa\u53c2=" + searchEsSQLXlsRspBO.toString());
        return searchEsSQLXlsRspBO;
    }

    public SearchEsSQLXlsRspBO querySkuEsBasic(QuerySkuBasicDataReqBO querySkuBasicDataReqBO) {
        SearchEsSQLXlsRspBO searchEsSQLXlsRspBO = new SearchEsSQLXlsRspBO();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_delete", (int)0));
        if (querySkuBasicDataReqBO.getUnsaleNum() == 1) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"unsale_num").gt((Object)0));
        }
        if (StringUtils.isNotEmpty((CharSequence)querySkuBasicDataReqBO.getMaterialId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_id", (String)querySkuBasicDataReqBO.getMaterialId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)querySkuBasicDataReqBO.getSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (Collection)querySkuBasicDataReqBO.getSkuIds()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getProvinceCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"province_code", (String)querySkuBasicDataReqBO.getProvinceCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getCityCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"city_code", (String)querySkuBasicDataReqBO.getCityCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getCountyCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"county_code", (String)querySkuBasicDataReqBO.getCountyCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)querySkuBasicDataReqBO.getMaterialIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_id", (Collection)querySkuBasicDataReqBO.getMaterialIds()));
        }
        if (null != querySkuBasicDataReqBO.getShopId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)querySkuBasicDataReqBO.getShopId()));
        }
        if (null != querySkuBasicDataReqBO.getBrandId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)querySkuBasicDataReqBO.getBrandId()));
        }
        if (null != querySkuBasicDataReqBO.getSupplierId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"verdor_id", (Object)querySkuBasicDataReqBO.getSupplierId()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getBrandName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"brand_name", (Object)querySkuBasicDataReqBO.getBrandName()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"sku_name", (Object)querySkuBasicDataReqBO.getSkuName()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getErpGoodsType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"erp_goods_type", (String)querySkuBasicDataReqBO.getErpGoodsType()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getHasSerialNumber())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"has_serial_number", (String)querySkuBasicDataReqBO.getHasSerialNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)querySkuBasicDataReqBO.getReservedField1())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"reserved_field1", (String)querySkuBasicDataReqBO.getReservedField1()));
        }
        HighlightBuilder highlightBuilder = (HighlightBuilder)((HighlightBuilder)new HighlightBuilder().field("sku_name").preTags(new String[]{"<span style=\"color:red\">"})).postTags(new String[]{"</span>"});
        searchEsSQLXlsRspBO.setBoolQueryBuilder(boolQueryBuilder);
        searchEsSQLXlsRspBO.setHighlightBuilder(highlightBuilder);
        searchEsSQLXlsRspBO.setPageNo(Integer.valueOf(querySkuBasicDataReqBO.getCurrent()));
        searchEsSQLXlsRspBO.setPageSize(Integer.valueOf(querySkuBasicDataReqBO.getPageSize()));
        logger.info("\u62fc\u63a5es\u67e5\u8be2\u6761\u4ef6\u670d\u52a1\u51fa\u53c2=" + searchEsSQLXlsRspBO.toString());
        return searchEsSQLXlsRspBO;
    }
}

