/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.busi.sku.BatchCreateSkuService;
import com.xls.commodity.busi.sku.CreateSkuByProvGoodsService;
import com.xls.commodity.busi.sku.bo.BatchCreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.CreateSkuByProvGoodsReqBO;
import com.xls.commodity.busi.sku.bo.CreateSkuReqBO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CreateSkuByProvGoodsServiceImpl
implements CreateSkuByProvGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(CreateSkuByProvGoodsServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;

    public BaseRspBO createSkuByProvGoods(CreateSkuByProvGoodsReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        if (reqBO.getSupllierId() == null) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("9999", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getProvinceCode())) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("9999", "\u5165\u53c2\u4e3a\u7a7a");
        }
        ArrayList<ProvGoodsPO> prov = new ArrayList();
        try {
            prov = this.provGoodsDAO.selectByProv(reqBO.getProvinceCode());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1");
            throw new BusinessException("9999", "\u67e5\u8be2\u7701\u4efd\u5546\u54c1" + e.getMessage());
        }
        if (!CollectionUtils.isEmpty(prov)) {
            try {
                this.add(prov, reqBO.getShopName(), reqBO.getSupllierId());
            }
            catch (Exception e) {
                logger.error("\u521b\u5efasku\u62a5\u9519");
                throw new BusinessException("9999", "\u521b\u5efasku\u62a5\u9519" + e.getMessage());
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public void add(List<ProvGoodsPO> provPOs, String shopName, Long supplierId) throws Exception {
        BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
        ArrayList<CreateSkuReqBO> reqList = new ArrayList<CreateSkuReqBO>();
        CreateSkuReqBO bo = null;
        for (ProvGoodsPO provPO : provPOs) {
            bo = new CreateSkuReqBO();
            bo.setCgType(provPO.getCgType());
            bo.setGoodsSource(provPO.getGoodsSource());
            bo.setColor(provPO.getColorName());
            bo.setExtSkuId(provPO.getGoodsNo());
            bo.setBrand(provPO.getBrandName());
            bo.setMeasureId(provPO.getMeasureId());
            bo.setMeasureName(provPO.getMeasureName());
            bo.setFullName(provPO.getGoodsLongName());
            bo.setSupplierId(supplierId);
            bo.setSupplierName(shopName);
            bo.setName(provPO.getGoodsLongName());
            bo.setIsVirtualGood(provPO.getAllowNegativeStock());
            bo.setMaterialId(provPO.getMaterialId());
            bo.setProvGoodsId(provPO.getProvGoodsId());
            bo.setProvinceCode(provPO.getProvinceCode());
            bo.setVendorId(provPO.getSupNo());
            bo.setBrandId(provPO.getBrandId());
            bo.setBrandName(provPO.getBrandName());
            reqList.add(bo);
        }
        batchCreateSkuReqBO.setCreateSkuReqBOs(reqList);
        this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
    }
}

