/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.xls.commodity.atom.sku.DeleteSkuService;
import com.xls.commodity.busi.sku.DeleteProvGoodsService;
import com.xls.commodity.busi.sku.bo.DeleteProvGoodsBO;
import com.xls.commodity.busi.sku.bo.SmcNumBO;
import com.xls.commodity.dao.MaterialDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.ProvGoodsSupRelationDAO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DeleteProvGoodsServiceImpl
implements DeleteProvGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(DeleteProvGoodsServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private MaterialDAO materialDAO;
    @Autowired
    private DeleteSkuService deleteSkuService;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;

    public BaseRspBO deleteProvGoods(DeleteProvGoodsBO provGoodsBO) {
        BaseRspBO result = new BaseRspBO();
        if (CollectionUtils.isEmpty((Collection)provGoodsBO.getProvGoodsIdS())) {
            logger.error("DeleteProvGoods\u65b9\u6cd5\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a!");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25:DeleteProvGoods\u65b9\u6cd5\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a\uff01");
            return result;
        }
        List provGoodsIdS = provGoodsBO.getProvGoodsIdS();
        try {
            if (CollectionUtils.isEmpty((Collection)provGoodsIdS)) {
                logger.error("DeleteProvGoods\u65b9\u6cd5\u4f20\u5165\u7684\u7701\u4efd\u5546\u54c1id\u4e3a\u7a7a!");
                result.setRespCode("8888");
                result.setRespDesc("\u5931\u8d25:DeleteProvGoods\u65b9\u6cd5\u4f20\u5165\u7684\u7701\u4efd\u5546\u54c1id\u4e3a\u7a7a\uff01");
                return result;
            }
            List<ProvGoodsPO> provGoodsPOS = this.provGoodsDAO.selectByProvGoodsIds(provGoodsIdS);
            if (CollectionUtils.isEmpty(provGoodsPOS)) {
                logger.error("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u7701\u4efd\u5546\u54c1\u6570\u636e  \u5220\u9664\u5931\u8d25!");
                result.setRespCode("8888");
                result.setRespDesc("\u5931\u8d25:\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u7701\u4efd\u5546\u54c1\u6570\u636e  \u5220\u9664\u5931\u8d25!");
                return result;
            }
            ArrayList<String> materialIdS = new ArrayList<String>();
            ArrayList<String> proviceCode = new ArrayList<String>();
            provGoodsPOS.stream().forEach(provGoodsPO -> {
                materialIdS.add(provGoodsPO.getMaterialId());
                proviceCode.add(provGoodsPO.getProvinceCode());
            });
            this.isRepertoryEmpty(materialIdS, proviceCode);
            logger.debug("\u7701\u4efd\u5546\u54c1\u5e93\u5b58\u4e3a\u7a7a\u5f00\u59cb\u8fdb\u884c\u5220\u9664");
            this.provGoodsDAO.deleteByProvIdS(provGoodsIdS);
            if (CollectionUtils.isNotEmpty(materialIdS) && CollectionUtils.isNotEmpty(proviceCode)) {
                this.materialDAO.deleteBymaterialIdS(materialIdS, proviceCode);
            }
            this.provGoodsSupRelationDAO.deleteByProvId(provGoodsIdS);
            this.deleteSkuService.deleteSKU(provGoodsIdS);
        }
        catch (BeansException e) {
            logger.error("\u5220\u9664\u7701\u4efd\u5546\u54c1\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        catch (BusinessException e) {
            logger.error("\u5b58\u5728\u5e93\u5b58\u8bb0\u5f55\u7981\u6b62\u5220\u9664\uff1a" + e.getMessage());
            result.setRespCode(e.getMsgCode());
            result.setRespDesc(e.getMsgInfo());
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public void isRepertoryEmpty(List<String> materialIdS, List<String> proviceCode) {
        logger.debug("\u67e5\u8be2\u5230\u7701\u4efd\u5546\u54c1\u6570\u636e\u7684\u7269\u6599\u7f16\u7801\u4e3a\uff1a{}\uff0c\u7701\u4efd\u7f16\u7801\u4e3a\uff1a{}", (Object)JSON.toJSONString(materialIdS), (Object)JSON.toJSONString(proviceCode));
        JSONObject resultData = this.reqBOresultData(materialIdS, proviceCode);
        JSONArray nums = resultData.getJSONArray("nums");
        List smcNumBOS = nums.toJavaList(SmcNumBO.class);
        ArrayList<String> inventoryRecordsExistMaterialIdS = new ArrayList<String>();
        for (SmcNumBO smcNumBO : smcNumBOS) {
            if (!materialIdS.contains(smcNumBO.getMaterialCode()) || smcNumBO.getSaledNum() <= 0L && smcNumBO.getLockNum() <= 0L && smcNumBO.getTransNum() <= 0L && smcNumBO.getUnsaleNum() <= 0L) continue;
            inventoryRecordsExistMaterialIdS.add(smcNumBO.getMaterialCode());
        }
        if (CollectionUtils.isNotEmpty(inventoryRecordsExistMaterialIdS)) {
            throw new BusinessException("9999", "\u7269\u6599\u7f16\u7801\uff1a" + JSON.toJSONString(inventoryRecordsExistMaterialIdS) + "\u5728\u5b58\u5e93\u4e2d \u5b58\u5728\u5df2\u552e\u3001\u9501\u5e93\u3001\u5728\u9014\u6216\u53ef\u552e\u6570\u91cf \u4e0d\u5141\u8bb8\u5220\u9664");
        }
    }

    private JSONObject reqBOresultData(List<String> materialIdS, List<String> proviceCode) {
        JSONObject param = new JSONObject();
        param.put("provIds", proviceCode);
        param.put("materialCodes", materialIdS);
        JSONObject resultData = new JSONObject();
        try {
            InvokeInfo invokeInfo = new InvokeInfo("com.tydic.smc.api.ability.SmcQryUnSaleCountsAbilityService", "qryUnSaleCountsList", "com.tydic.smc.api.ability.bo.SmcQryUnSaleCountsAbilityReqBO");
            invokeInfo.setVersion(this.hsfVersion);
            invokeInfo.setGroup(this.hsfGroup);
            invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
            invokeInfo.setRegisterType("2");
            resultData = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)param), null, (InvokeInfo)invokeInfo);
            logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528" + resultData);
        }
        catch (Exception e) {
            logger.error("\u53ef\u552e,\u5728\u9014,\u9501\u5e93\uff0c\u6570\u91cf\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("9999", "\u53ef\u552e,\u5728\u9014,\u9501\u5e93\uff0c\u6570\u91cf\u67e5\u8be2\u5931\u8d25");
        }
        return resultData;
    }
}

