/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.ohaotian.commodity.custom.search.SearchEsQueryXlsService;
import com.ohaotian.commodity.custom.search.bo.SearchEsQueryRspBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsSQLXlsRspBO;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.BuildEsSqlService;
import com.xls.commodity.busi.sku.GetExtSkuIdByShopIdListService;
import com.xls.commodity.busi.sku.QueryEsResultService;
import com.xls.commodity.busi.sku.bo.BuildEsSqlReqBO;
import com.xls.commodity.busi.sku.bo.DSkuBO;
import com.xls.commodity.busi.sku.bo.QueryEsResultRspBO;
import com.xls.commodity.busi.sku.bo.QuerySkuBasicDataReqBO;
import com.xls.commodity.busi.sku.bo.RspPageBaseBO;
import com.xls.commodity.busi.sku.bo.SelectExcelSkuAndSupListRspBO;
import com.xls.commodity.busi.sku.bo.SelectSkuAndSupListRspBO;
import com.xls.commodity.busi.sku.bo.SkuPageReqBO;
import com.xls.commodity.busi.sku.bo.SkuPriceBO;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.busi.sku.bo.VendorBO;
import com.xls.commodity.busi.sku.bo.XlsSearchEsRspInfoBO;
import com.xls.commodity.dao.CommodityExtSkuIdDAO;
import com.xls.commodity.dao.po.CommodityExtSkuIdPO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetExtSkuIdByShopIdListServiceImpl
implements GetExtSkuIdByShopIdListService {
    private static final Logger logger = LoggerFactory.getLogger(GetExtSkuIdByShopIdListServiceImpl.class);
    @Autowired
    private CommodityExtSkuIdDAO commodityExtSkuIdDAO;
    @Autowired
    private BuildEsSqlService buildEsSqlService;
    @Autowired
    private SearchEsQueryXlsService searchEsQueryXlsService;
    @Autowired
    private QueryEsResultService queryEsResultService;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;

    public RspPageBaseBO<DSkuBO> getExtSkuIdByShopIdListByPage(SkuPageReqBO reqBO) {
        logger.debug("\u8c03\u7528\u67e5\u8be2\u52a9\u8bb0\u7801\u670d\u52a1" + reqBO.toString());
        RspPageBaseBO result = new RspPageBaseBO();
        BuildEsSqlReqBO buildEsSqlReqBO = new BuildEsSqlReqBO();
        buildEsSqlReqBO.setExtSkuId(reqBO.getExtSkuId());
        buildEsSqlReqBO.setBrandStr(reqBO.getBrandName());
        buildEsSqlReqBO.setQueryStr(reqBO.getSkuName());
        buildEsSqlReqBO.setMaterialId(reqBO.getMaterialId());
        buildEsSqlReqBO.setProvinceCode(reqBO.getProvinceCode());
        buildEsSqlReqBO.setPageNo(Integer.valueOf(reqBO.getOffset()));
        buildEsSqlReqBO.setPageSize(Integer.valueOf(reqBO.getPageSize()));
        ArrayList<DSkuBO> boList = new ArrayList<DSkuBO>();
        SearchEsSQLXlsRspBO searchEsSQLXlsRspBO = this.buildEsSqlService.buildBindEsSql(buildEsSqlReqBO);
        SearchEsQueryRspBO searchEsQueryRspBO = this.searchEsQueryXlsService.executeSQLXls(searchEsSQLXlsRspBO);
        QueryEsResultRspBO result1 = this.queryEsResultService.queryEsResult(searchEsQueryRspBO);
        try {
            List<Sku> poList = this.getSkuEs(result1);
            ArrayList<String> material = new ArrayList<String>();
            HashMap<String, CommodityExtSkuIdPO> skuMap = new HashMap<String, CommodityExtSkuIdPO>();
            for (Sku po : poList) {
                DSkuBO bo = new DSkuBO();
                material.add(po.getMaterialId());
                BeanUtils.copyProperties((Object)po, (Object)bo);
                boList.add(bo);
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty(poList)) {
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                result.setRows(boList);
                result.setRecordsTotal(result1.getTotalCount().intValue());
                return result;
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty(material)) {
                for (DSkuBO dSkuBO : boList) {
                    dSkuBO.setIsBind("1");
                }
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                result.setRows(boList);
                result.setRecordsTotal(result1.getTotalCount().intValue());
                return result;
            }
            List<CommodityExtSkuIdPO> commList = this.commodityExtSkuIdDAO.selectByMaterials(material, reqBO.getProvinceCode());
            for (CommodityExtSkuIdPO commodityExtSkuIdPO : commList) {
                skuMap.put(commodityExtSkuIdPO.getMaterialId() + commodityExtSkuIdPO.getProvinceCode(), commodityExtSkuIdPO);
            }
            for (DSkuBO dSkuBO : boList) {
                if (skuMap.get(dSkuBO.getMaterialId() + dSkuBO.getProvinceCode()) != null) {
                    logger.debug("\u5df2\u7ecf\u7ed1\u5b9a");
                    dSkuBO.setIsBind("0");
                    continue;
                }
                logger.debug("\u6ca1\u6709\u7ed1\u5b9a");
                dSkuBO.setIsBind("1");
            }
            logger.debug(((Object)boList).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5355\u54c1\u5217\u8868\u5206\u9875\u51fa\u9519" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(boList);
        result.setRecordsTotal(result1.getTotalCount().intValue());
        return result;
    }

    public RspPageBO<SelectSkuAndSupListRspBO> selectEsSkuAndSupList(QuerySkuBasicDataReqBO querySkuBasicDataReqBO) {
        RspPageBO result = new RspPageBO();
        ArrayList<SelectSkuAndSupListRspBO> selectSkuAndSupListRspBOList = new ArrayList<SelectSkuAndSupListRspBO>();
        logger.debug("\u6839\u636e\u95e8\u5e97ID\u67e5\u8be2es\u5546\u54c1\u4fe1\u606f\u3001\u4ef7\u683c\u53ca\u4f9b\u5e94\u5546\u5217\u8868\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)querySkuBasicDataReqBO));
        Map<String, String> erpMap = this.sysParamsAtomService.selectByParentCode("ERP_GOODS_TYPE");
        Map<String, String> stangMap = this.sysParamsAtomService.selectByParentCode("STANDARD_SYSTEM_STR");
        Map<String, String> stallMap = this.sysParamsAtomService.selectByParentCode("GOODS_STALLS_STR");
        SearchEsSQLXlsRspBO searchEsSQLXlsRspBO = this.buildEsSqlService.querySkuEsBasic(querySkuBasicDataReqBO);
        SearchEsQueryRspBO searchEsQueryRspBO = this.searchEsQueryXlsService.executeSQLXls(searchEsSQLXlsRspBO);
        QueryEsResultRspBO queryEsResultRspBO = this.queryEsResultService.queryEsSkuResult(searchEsQueryRspBO);
        HashMap<Long, SkuPriceBO> mapSkuPriceBO = new HashMap<Long, SkuPriceBO>();
        try {
            List xlsSearchEsRspInfoBOS = queryEsResultRspBO.getResult();
            if (CollectionUtils.isNotEmpty((Collection)xlsSearchEsRspInfoBOS)) {
                Map<String, Map<String, String>> escaMap = this.getEscape();
                for (XlsSearchEsRspInfoBO xlsSearchEsRspInfoBO : xlsSearchEsRspInfoBOS) {
                    SelectSkuAndSupListRspBO selectSkuAndSupListRspBO = new SelectSkuAndSupListRspBO();
                    BeanUtils.copyProperties((Object)xlsSearchEsRspInfoBO, (Object)selectSkuAndSupListRspBO);
                    if (StringUtils.isNotEmpty((CharSequence)xlsSearchEsRspInfoBO.getProvincecode())) {
                        selectSkuAndSupListRspBO.setProvinceCode(xlsSearchEsRspInfoBO.getProvincecode());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)xlsSearchEsRspInfoBO.getCitycode())) {
                        selectSkuAndSupListRspBO.setCityCode(xlsSearchEsRspInfoBO.getCitycode());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)xlsSearchEsRspInfoBO.getCountycode())) {
                        selectSkuAndSupListRspBO.setCountyCode(xlsSearchEsRspInfoBO.getCountycode());
                    }
                    selectSkuAndSupListRspBO.setErpGoodsTypeStr(erpMap.get(xlsSearchEsRspInfoBO.getErpGoodsType()));
                    selectSkuAndSupListRspBO.setStandardSystemStr(stangMap.get(xlsSearchEsRspInfoBO.getStandardSystem()));
                    selectSkuAndSupListRspBO.setGoodsStallsStr(stallMap.get(xlsSearchEsRspInfoBO.getGoodsStalls()));
                    selectSkuAndSupListRspBO.setShopId(xlsSearchEsRspInfoBO.getSupplierId());
                    selectSkuAndSupListRspBO.setShopName(xlsSearchEsRspInfoBO.getSupplierName());
                    if (StringUtils.isNotEmpty((CharSequence)xlsSearchEsRspInfoBO.getHasSerialNumber()) && escaMap.get("PROV_GOODS_IS_OR_NO") != null) {
                        selectSkuAndSupListRspBO.setHasSerialNumberStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(xlsSearchEsRspInfoBO.getHasSerialNumber()));
                    }
                    if (StringUtils.isEmpty((CharSequence)xlsSearchEsRspInfoBO.getHasSerialNumber())) {
                        selectSkuAndSupListRspBO.setHasSerialNumber("0");
                        selectSkuAndSupListRspBO.setHasSerialNumberStr(escaMap.get("PROV_GOODS_IS_OR_NO").get("0"));
                    }
                    SkuPriceBO skuPriceBO = new SkuPriceBO();
                    BeanUtils.copyProperties((Object)xlsSearchEsRspInfoBO, (Object)skuPriceBO);
                    if (!"1".equals(querySkuBasicDataReqBO.getmVisiCost())) {
                        skuPriceBO.setPurchasePriceStr("****");
                        skuPriceBO.setPurchasePrice(null);
                        skuPriceBO.setPurchasePriceY(null);
                    } else if (skuPriceBO.getPurchasePriceY() != null) {
                        skuPriceBO.setPurchasePriceStr(skuPriceBO.getPurchasePriceY().toString());
                    }
                    mapSkuPriceBO.put(skuPriceBO.getSkuId(), skuPriceBO);
                    selectSkuAndSupListRspBOList.add(selectSkuAndSupListRspBO);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2Es\u5546\u54c1\u57fa\u7840\u4fe1\u606f\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(selectSkuAndSupListRspBOList)) {
            for (SelectSkuAndSupListRspBO selectSkuAndSupListRspBO : selectSkuAndSupListRspBOList) {
                SkuPriceBO skuPriceBO = (SkuPriceBO)mapSkuPriceBO.get(selectSkuAndSupListRspBO.getSkuId());
                selectSkuAndSupListRspBO.setSkuPriceBO(skuPriceBO);
                String vendorId = selectSkuAndSupListRspBO.getVendorId();
                String vendorName = selectSkuAndSupListRspBO.getVendorName();
                if (!StringUtils.isNotBlank((CharSequence)vendorId) || !StringUtils.isNotBlank((CharSequence)vendorName)) continue;
                ArrayList<VendorBO> vendorBOList = new ArrayList<VendorBO>();
                String[] vendorIdArray = vendorId.split(",");
                String[] vendorNameArray = vendorName.split(",");
                for (int i = 0; i < vendorIdArray.length; ++i) {
                    VendorBO vendorBO = new VendorBO();
                    vendorBO.setVendorId(vendorIdArray[i]);
                    vendorBO.setVendorName(vendorNameArray[i]);
                    vendorBOList.add(vendorBO);
                }
                selectSkuAndSupListRspBO.setVendorBOList(vendorBOList);
            }
        }
        result.setRecordsTotal(queryEsResultRspBO.getTotalCount().intValue());
        result.setRows(selectSkuAndSupListRspBOList);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public RspPageBO<SelectExcelSkuAndSupListRspBO> selectExcelEsSkuAndSupList(QuerySkuBasicDataReqBO querySkuBasicDataReqBO) {
        RspPageBO result = new RspPageBO();
        ArrayList<SelectExcelSkuAndSupListRspBO> listSelectExcelSkuAndSupListRspBO = new ArrayList<SelectExcelSkuAndSupListRspBO>();
        logger.debug("\u6839\u636e\u95e8\u5e97ID\u67e5\u8be2es\u5546\u54c1\u4fe1\u606f\u3001\u4ef7\u683c\u53ca\u4f9b\u5e94\u5546\u5217\u8868\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)querySkuBasicDataReqBO));
        Map<String, String> erpMap = this.sysParamsAtomService.selectByParentCode("ERP_GOODS_TYPE");
        Map<String, String> stangMap = this.sysParamsAtomService.selectByParentCode("STANDARD_SYSTEM_STR");
        Map<String, String> stallMap = this.sysParamsAtomService.selectByParentCode("GOODS_STALLS_STR");
        SearchEsSQLXlsRspBO searchEsSQLXlsRspBO = this.buildEsSqlService.querySkuEsBasic(querySkuBasicDataReqBO);
        SearchEsQueryRspBO searchEsQueryRspBO = this.searchEsQueryXlsService.executeSQLXls(searchEsSQLXlsRspBO);
        QueryEsResultRspBO queryEsResultRspBO = this.queryEsResultService.queryEsSkuResult(searchEsQueryRspBO);
        HashMap<Long, SkuPriceBO> mapSkuPriceBO = new HashMap<Long, SkuPriceBO>();
        try {
            List xlsSearchEsRspInfoBOS = queryEsResultRspBO.getResult();
            if (CollectionUtils.isNotEmpty((Collection)xlsSearchEsRspInfoBOS)) {
                Map<String, Map<String, String>> escaMap = this.getEscape();
                for (XlsSearchEsRspInfoBO xlsSearchEsRspInfoBO : xlsSearchEsRspInfoBOS) {
                    SelectExcelSkuAndSupListRspBO selectExcelSkuAndSupListRspBO = new SelectExcelSkuAndSupListRspBO();
                    BeanUtils.copyProperties((Object)xlsSearchEsRspInfoBO, (Object)selectExcelSkuAndSupListRspBO);
                    if (StringUtils.isNotEmpty((CharSequence)xlsSearchEsRspInfoBO.getProvincecode())) {
                        selectExcelSkuAndSupListRspBO.setProvinceCode(xlsSearchEsRspInfoBO.getProvincecode());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)xlsSearchEsRspInfoBO.getCitycode())) {
                        selectExcelSkuAndSupListRspBO.setCityCode(xlsSearchEsRspInfoBO.getCitycode());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)xlsSearchEsRspInfoBO.getCountycode())) {
                        selectExcelSkuAndSupListRspBO.setCountyCode(xlsSearchEsRspInfoBO.getCountycode());
                    }
                    selectExcelSkuAndSupListRspBO.setErpGoodsTypeStr(erpMap.get(xlsSearchEsRspInfoBO.getErpGoodsType()));
                    selectExcelSkuAndSupListRspBO.setStandardSystemStr(stangMap.get(xlsSearchEsRspInfoBO.getStandardSystem()));
                    selectExcelSkuAndSupListRspBO.setGoodsStallsStr(stallMap.get(xlsSearchEsRspInfoBO.getGoodsStalls()));
                    selectExcelSkuAndSupListRspBO.setShopId(xlsSearchEsRspInfoBO.getSupplierId());
                    selectExcelSkuAndSupListRspBO.setShopName(xlsSearchEsRspInfoBO.getSupplierName());
                    if (StringUtils.isNotEmpty((CharSequence)xlsSearchEsRspInfoBO.getHasSerialNumber()) && escaMap.get("PROV_GOODS_IS_OR_NO") != null) {
                        selectExcelSkuAndSupListRspBO.setHasSerialNumberStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(xlsSearchEsRspInfoBO.getHasSerialNumber()));
                    }
                    if (StringUtils.isEmpty((CharSequence)xlsSearchEsRspInfoBO.getHasSerialNumber())) {
                        selectExcelSkuAndSupListRspBO.setHasSerialNumber("0");
                        selectExcelSkuAndSupListRspBO.setHasSerialNumberStr(escaMap.get("PROV_GOODS_IS_OR_NO").get("0"));
                    }
                    SkuPriceBO skuPriceBO = new SkuPriceBO();
                    BeanUtils.copyProperties((Object)xlsSearchEsRspInfoBO, (Object)skuPriceBO);
                    if (!"1".equals(querySkuBasicDataReqBO.getmVisiCost())) {
                        skuPriceBO.setPurchasePriceStr("****");
                        skuPriceBO.setPurchasePrice(null);
                        skuPriceBO.setPurchasePriceY(null);
                    } else if (skuPriceBO.getPurchasePriceY() != null) {
                        skuPriceBO.setPurchasePriceStr(skuPriceBO.getPurchasePriceY().toString());
                    }
                    mapSkuPriceBO.put(skuPriceBO.getSkuId(), skuPriceBO);
                    listSelectExcelSkuAndSupListRspBO.add(selectExcelSkuAndSupListRspBO);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2Es\u5546\u54c1\u57fa\u7840\u4fe1\u606f\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty(listSelectExcelSkuAndSupListRspBO)) {
            for (SelectExcelSkuAndSupListRspBO selectExcelSkuAndSupListRspBO : listSelectExcelSkuAndSupListRspBO) {
                SkuPriceBO skuPriceBO = (SkuPriceBO)mapSkuPriceBO.get(selectExcelSkuAndSupListRspBO.getSkuId());
                BeanUtils.copyProperties((Object)skuPriceBO, (Object)selectExcelSkuAndSupListRspBO);
                String vendorId = selectExcelSkuAndSupListRspBO.getVendorId();
                String vendorName = selectExcelSkuAndSupListRspBO.getVendorName();
                if (!StringUtils.isNotBlank((CharSequence)vendorId) || !StringUtils.isNotBlank((CharSequence)vendorName)) continue;
                ArrayList<VendorBO> vendorBOList = new ArrayList<VendorBO>();
                String[] vendorIdArray = vendorId.split(",");
                String[] vendorNameArray = vendorName.split(",");
                for (int i = 0; i < vendorIdArray.length; ++i) {
                    VendorBO vendorBO = new VendorBO();
                    vendorBO.setVendorId(vendorIdArray[i]);
                    vendorBO.setVendorName(vendorNameArray[i]);
                    vendorBOList.add(vendorBO);
                }
                selectExcelSkuAndSupListRspBO.setVendorBOList(vendorBOList);
            }
        }
        result.setRecordsTotal(queryEsResultRspBO.getTotalCount().intValue());
        result.setTotal(queryEsResultRspBO.getTotalCount() % querySkuBasicDataReqBO.getPageSize() == 0 ? queryEsResultRspBO.getTotalCount() / querySkuBasicDataReqBO.getPageSize() : queryEsResultRspBO.getTotalCount() / querySkuBasicDataReqBO.getPageSize() + 1);
        result.setRows(listSelectExcelSkuAndSupListRspBO);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public List<Sku> getSkuEs(QueryEsResultRspBO result1) {
        ArrayList<Sku> list = new ArrayList<Sku>();
        List listXlsSearchEsRspInfoBO = result1.getResult();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)listXlsSearchEsRspInfoBO)) {
            Sku sku = null;
            for (XlsSearchEsRspInfoBO xlsSearchEsRspInfoBO : listXlsSearchEsRspInfoBO) {
                sku = new Sku();
                BeanUtils.copyProperties((Object)xlsSearchEsRspInfoBO, (Object)sku);
                sku.setMaterialId(xlsSearchEsRspInfoBO.getMaterialId());
                sku.setCommodityId(xlsSearchEsRspInfoBO.getCommodityId());
                sku.setSkuName(xlsSearchEsRspInfoBO.getSkuName());
                sku.setBrandName(xlsSearchEsRspInfoBO.getBrandName());
                sku.setProvinceCode(xlsSearchEsRspInfoBO.getProvincecode());
                sku.setExtSkuId(xlsSearchEsRspInfoBO.getExtSkuId());
                sku.setSupplierId(xlsSearchEsRspInfoBO.getSupplierId());
                sku.setSupplierName(xlsSearchEsRspInfoBO.getSupplierName());
                list.add(sku);
            }
        }
        return list;
    }

    public Map<String, Map<String, String>> getEscape() {
        List<SysParamTransBusiBO> escaList = this.sysParamsAtomService.selectAll();
        HashMap<String, Map<String, String>> escaMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty(escaList)) {
            for (SysParamTransBusiBO es : escaList) {
                if (escaMap.containsKey(es.getParentCode())) {
                    ((Map)escaMap.get(es.getParentCode())).put(es.getCode(), es.getCodeTitle());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(es.getCode(), es.getCodeTitle());
                escaMap.put(es.getParentCode(), map);
            }
        }
        return escaMap;
    }
}

