/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.ProvGoodsAndSheetService;
import com.xls.commodity.busi.sku.bo.PriceSheetItemBO;
import com.xls.commodity.busi.sku.bo.PriceSheetItemBOResBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsAndSheetBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsAndSheetNoPageReqBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsAndSheetReqBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsAndSheetResBO;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.dao.PriceSheetItemDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.po.PriceSheetItemPO;
import com.xls.commodity.dao.po.ProvGoodsAndSheetPO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProvGoodsAndSheetServiceImpl
implements ProvGoodsAndSheetService {
    private static final Logger logger = LoggerFactory.getLogger(ProvGoodsAndSheetServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private PriceSheetItemDAO priceSheetItemDAO;

    public RspPageBO<ProvGoodsAndSheetBO> getProvGoodsAndSheet(ProvGoodsAndSheetReqBO reqBO) {
        logger.debug("\u662f\u5426\u53ef\u67e5\u770b\u4ef7\u683c" + reqBO.getmVisiCost() + reqBO.getMVisiCost());
        RspPageBO result = new RspPageBO();
        ProvGoodsAndSheetPO record = new ProvGoodsAndSheetPO();
        if ("1".equals(reqBO.getmManageOrgId()) && StringUtils.isBlank((CharSequence)reqBO.getmProvince()) && StringUtils.isBlank((CharSequence)reqBO.getmCity()) && StringUtils.isBlank((CharSequence)reqBO.getmShopId())) {
            record.setSheetLevel("1");
        } else if ("2".equals(reqBO.getmUserLevel()) && StringUtils.isNotBlank((CharSequence)reqBO.getmProvince())) {
            record.setSheetLevel("2");
        } else if ("3".equals(reqBO.getmUserLevel()) && StringUtils.isNotBlank((CharSequence)reqBO.getmCity())) {
            record.setSheetLevel("3");
        } else if ("5".equals(reqBO.getmUserLevel()) && StringUtils.isNotBlank((CharSequence)reqBO.getmShopId())) {
            record.setSheetLevel("5");
        } else {
            logger.error("\u62a5\u4ef7\u5355\u67e5\u8be2\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            result.setRespCode("9999");
            result.setRespDesc("\u62a5\u4ef7\u5355\u67e5\u8be2\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            return result;
        }
        record.setMaterialId(reqBO.getMaterialId());
        record.setBrandId(reqBO.getBrandId());
        record.setBrandName(reqBO.getBrandName());
        record.setIsRootControl(reqBO.getIsRootControl());
        record.setGoodsLongName(reqBO.getGoodsLongName());
        record.setProvinceCode(reqBO.getProvinceCode());
        record.setShopCode(reqBO.getShopCode());
        record.setErpGoodsType(reqBO.getErpGoodsType());
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getCurrent());
        logger.debug("\u67e5\u8be2\u7801\u8868");
        ArrayList<ProvGoodsAndSheetBO> rows = new ArrayList<ProvGoodsAndSheetBO>();
        Map<String, Map<String, String>> escaMap = this.getEscape();
        try {
            List<ProvGoodsAndSheetPO> poList = this.provGoodsDAO.queryProvGoodsAndSheet(record, (Page<ProvGoodsAndSheetPO>)page);
            if (!CollectionUtils.isEmpty(poList)) {
                ProvGoodsAndSheetBO bo = null;
                for (ProvGoodsAndSheetPO po : poList) {
                    bo = new ProvGoodsAndSheetBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    bo.setErpGoodsTypeStr(escaMap.get("ERP_GOODS_TYPE").get(po.getErpGoodsType()));
                    bo.setCgTypeStr(escaMap.get("CGTYPE_STR").get(po.getCgType()));
                    bo.setGoodsSourceStr(escaMap.get("GOODS_SOURCE_STR").get(po.getGoodsSource()));
                    bo.setGoodsStallsStr(escaMap.get("GOODS_STALLS_STR").get(po.getGoodsStalls()));
                    bo.setGoodsStatusStr(escaMap.get("GOODS_STATUS_STR").get(po.getGoodsStatus()));
                    bo.setHasPriceStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getHasPrice()));
                    bo.setHasSerialNumberStr(escaMap.get("HAS_SERIAL_NUMBER_STR").get(po.getHasSerialNumber()));
                    bo.setIsAfterInputSte(escaMap.get("IS_AFTER_INPUT_STE").get(po.getIsAfterInput()));
                    bo.setIsScmDistributeStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getIsScmDistribute()));
                    bo.setIsSendScmSaleStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getIsSendScmSale()));
                    bo.setIsSendScmStockStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getIsSendScmStock()));
                    bo.setIsValidStr(escaMap.get("IS_VALID_STR").get(po.getIsValid()));
                    bo.setPurchaseTypeStr(escaMap.get("PURCHASE_TYPE_STR").get(po.getPurchaseType()));
                    bo.setStandardSystemStr(escaMap.get("STANDARD_SYSTEM_STR").get(po.getStandardSystem()));
                    bo.setIsRootControlStr(escaMap.get("IS_ROOT_CONTROL_STR").get(po.getIsRootControl()));
                    bo.setGoodsLevelStr(escaMap.get("GOODS_LEVEL_STR").get(po.getGoodsLevel()));
                    bo.setSheetLevelStr(escaMap.get("SHEET_LEVEL_STR").get(po.getSheetLevel()));
                    bo.setAgreementPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getAgreementPrice()));
                    bo.setAssessmentPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getAssessmentPrice()));
                    bo.setCostPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getCostPrice()));
                    bo.setTheCostDownPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getTheCostDownPrice()));
                    bo.setRetailAgreementPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getRetailAgreementPrice()));
                    bo.setCitiesLockPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getCitiesLockPrice()));
                    bo.setPurchaseFloorPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getPurchaseFloorPrice()));
                    bo.setLastPurchasePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getLastPurchasePrice()));
                    bo.setMemberLadderPrice1Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice1()));
                    bo.setMemberLadderPrice2Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice2()));
                    bo.setMemberLadderPrice3Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice3()));
                    bo.setMemberLadderPrice4Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice4()));
                    bo.setMemberLadderPrice5Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice5()));
                    bo.setMemberPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getMemberPrice()));
                    bo.setProvAgreePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getProvAgreePrice()));
                    if (!"1".equals(reqBO.getmVisiCost())) {
                        bo.setPurchasePriceStr(null);
                        bo.setPurchasePrice(null);
                        bo.setPurchasePriceY("****");
                    } else if (po.getPurchasePrice() != null) {
                        bo.setPurchasePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getPurchasePrice()));
                        bo.setPurchasePrice(po.getPurchasePrice());
                        bo.setPurchasePriceY(MoneyUtils.Long2BigDecimal((Long)po.getPurchasePrice()).toString());
                    }
                    bo.setSalePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getSalePrice()));
                    bo.setSparePrice2Str(MoneyUtils.Long2BigDecimal((Long)po.getSparePrice2()));
                    bo.setSparePrice3Str(StringUtils.isEmpty((CharSequence)po.getSparePrice3()) ? null : MoneyUtils.Long2BigDecimal((Long)Long.parseLong(po.getSparePrice3())));
                    bo.setSparePrice4Str(StringUtils.isEmpty((CharSequence)po.getSparePrice4()) ? null : MoneyUtils.Long2BigDecimal((Long)Long.parseLong(po.getSparePrice4())));
                    bo.setSparePrice5Str(StringUtils.isEmpty((CharSequence)po.getSparePrice5()) ? null : MoneyUtils.Long2BigDecimal((Long)Long.parseLong(po.getSparePrice5())));
                    bo.setTradePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getTradePrice()));
                    bo.setIsCoverStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getIsCover()));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String date = sdf.format(po.getSheetCreat());
                    bo.setCreateTime(date);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u53ca\u62a5\u4ef7\u5355\u67e5\u8be2\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u7701\u4efd\u5546\u54c1\u53ca\u62a5\u4ef7\u5355\u67e5\u8be2\u62a5\u9519" + e.getMessage());
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public Map<String, Map<String, String>> getEscape() {
        List<SysParamTransBusiBO> escaList = this.sysParamsAtomService.selectAll();
        HashMap<String, Map<String, String>> escaMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty(escaList)) {
            for (SysParamTransBusiBO es : escaList) {
                if (escaMap.containsKey(es.getParentCode())) {
                    ((Map)escaMap.get(es.getParentCode())).put(es.getCode(), es.getCodeTitle());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(es.getCode(), es.getCodeTitle());
                escaMap.put(es.getParentCode(), map);
            }
        }
        return escaMap;
    }

    public PriceSheetItemBOResBO getProvSkuAndSheet(PriceSheetItemBO reqBO) {
        List<PriceSheetItemBO> list;
        logger.debug("sku\u5404\u7ea7\u4ef7\u683c\u67e5\u8be2");
        PriceSheetItemBOResBO result = new PriceSheetItemBOResBO();
        PriceSheetItemPO record = null;
        ArrayList<PriceSheetItemBO> rows = new ArrayList<PriceSheetItemBO>();
        try {
            logger.debug("\u67e5\u8be2\u5168\u56fd");
            record = new PriceSheetItemPO();
            record.setMaterialId(reqBO.getMaterialId());
            record.setSheetId(reqBO.getSheetId());
            record.setSheetLevel("1");
            list = this.getItem(record);
            rows.addAll(list);
        }
        catch (Exception e) {
            logger.error("sku\u5168\u56fd\u4ef7\u683c\u67e5\u8be2\u62a5\u9519");
            throw new BusinessException("9999", "sku\u5168\u56fd\u4ef7\u683c\u67e5\u8be2\u62a5\u9519" + e.getMessage());
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)reqBO.getProvinceCode())) {
                logger.debug("sku\u7701\u4efd\u4ef7\u683c\u67e5\u8be2");
                record = new PriceSheetItemPO();
                record.setSheetId(reqBO.getSheetId());
                record.setMaterialId(reqBO.getMaterialId());
                record.setSheetLevel("2");
                record.setProvinceCode(reqBO.getProvinceCode());
                list = this.getItem(record);
                rows.addAll(list);
            }
        }
        catch (Exception e) {
            logger.error("sku\u7701\u4efd\u4ef7\u683c\u67e5\u8be2\u62a5\u9519");
            throw new BusinessException("9999", "sku\u7701\u4efd\u4ef7\u683c\u67e5\u8be2\u62a5\u9519" + e.getMessage());
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)reqBO.getCityCode())) {
                logger.debug("sku\u5730\u5e02\u4ef7\u683c\u67e5\u8be2");
                record = new PriceSheetItemPO();
                record.setSheetId(reqBO.getSheetId());
                record.setMaterialId(reqBO.getMaterialId());
                record.setSheetLevel("3");
                record.setCityCode(reqBO.getCityCode());
                list = this.getItem(record);
                rows.addAll(list);
            }
        }
        catch (Exception e) {
            logger.error("sku\u5730\u5e02\u4ef7\u683c\u67e5\u8be2\u62a5\u9519");
            throw new BusinessException("9999", "sku\u5730\u5e02\u4ef7\u683c\u67e5\u8be2\u62a5\u9519" + e.getMessage());
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)reqBO.getShopCode())) {
                logger.debug("sku\u95e8\u5e97\u4ef7\u683c\u67e5\u8be2");
                record = new PriceSheetItemPO();
                record.setSheetId(reqBO.getSheetId());
                record.setMaterialId(reqBO.getMaterialId());
                record.setSheetLevel("5");
                record.setShopCode(reqBO.getShopCode());
                list = this.getItem(record);
                rows.addAll(list);
            }
        }
        catch (Exception e) {
            logger.error("sku\u95e8\u5e97\u4ef7\u683c\u67e5\u8be2\u62a5\u9519");
            throw new BusinessException("9999", "sku\u95e8\u5e97\u4ef7\u683c\u67e5\u8be2\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public List<PriceSheetItemBO> getItem(PriceSheetItemPO record) throws Exception {
        ArrayList<PriceSheetItemBO> list = new ArrayList<PriceSheetItemBO>();
        Map<String, Map<String, String>> escaMap = this.getEscape();
        List<PriceSheetItemPO> poList = this.priceSheetItemDAO.selectByMaterial(record);
        if (!CollectionUtils.isEmpty(poList)) {
            PriceSheetItemBO bo = null;
            for (PriceSheetItemPO po : poList) {
                bo = new PriceSheetItemBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                bo.setIsRootControlStr(escaMap.get("IS_ROOT_CONTROL_STR").get(po.getIsRootControl()));
                bo.setGoodsLevelStr(escaMap.get("GOODS_LEVEL_STR").get(po.getGoodsLevel()));
                bo.setSheetLevelStr(escaMap.get("SHEET_LEVEL_STR").get(po.getSheetLevel()));
                bo.setPurchaseFloorPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getPurchaseFloorPrice()));
                bo.setRetailAgreementPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getRetailAgreementPrice()));
                bo.setCitiesLockPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getCitiesLockPrice()));
                bo.setTheCostDownPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getTheCostDownPrice()));
                bo.setAgreementPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getAgreementPrice()));
                bo.setAssessmentPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getAssessmentPrice()));
                bo.setCostPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getCostPrice()));
                bo.setLastPurchasePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getLastPurchasePrice()));
                bo.setMemberLadderPrice1Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice1()));
                bo.setMemberLadderPrice2Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice2()));
                bo.setMemberLadderPrice3Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice3()));
                bo.setMemberLadderPrice4Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice4()));
                bo.setMemberLadderPrice5Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice5()));
                bo.setMemberPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getMemberPrice()));
                bo.setProvAgreePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getProvAgreePrice()));
                bo.setPurchasePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getPurchasePrice()));
                bo.setSalePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getSalePrice()));
                bo.setSparePrice2Str(MoneyUtils.Long2BigDecimal((Long)po.getSparePrice2()));
                bo.setSparePrice3Str(StringUtils.isEmpty((CharSequence)po.getSparePrice3()) ? null : MoneyUtils.Long2BigDecimal((Long)Long.parseLong(po.getSparePrice3())));
                bo.setSparePrice4Str(StringUtils.isEmpty((CharSequence)po.getSparePrice4()) ? null : MoneyUtils.Long2BigDecimal((Long)Long.parseLong(po.getSparePrice4())));
                bo.setSparePrice5Str(StringUtils.isEmpty((CharSequence)po.getSparePrice5()) ? null : MoneyUtils.Long2BigDecimal((Long)Long.parseLong(po.getSparePrice5())));
                bo.setTradePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getTradePrice()));
                bo.setIsCoverStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getIsCover()));
                list.add(bo);
            }
        }
        return list;
    }

    public ProvGoodsAndSheetResBO getProvGoodsAndSheetNoPage(ProvGoodsAndSheetNoPageReqBO reqBO) {
        ProvGoodsAndSheetResBO result = new ProvGoodsAndSheetResBO();
        logger.debug("\u662f\u5426\u53ef\u4ee5\u67e5\u770b\u4ef7\u683c" + reqBO.getmVisiCost());
        ProvGoodsAndSheetPO record = new ProvGoodsAndSheetPO();
        if ("1".equals(reqBO.getmManageOrgId()) && StringUtils.isBlank((CharSequence)reqBO.getmProvince()) && StringUtils.isBlank((CharSequence)reqBO.getmCity()) && StringUtils.isBlank((CharSequence)reqBO.getmShopId())) {
            record.setSheetLevel("1");
        } else if ("2".equals(reqBO.getmUserLevel()) && StringUtils.isNotBlank((CharSequence)reqBO.getmProvince())) {
            record.setSheetLevel("2");
        } else if ("3".equals(reqBO.getmUserLevel()) && StringUtils.isNotBlank((CharSequence)reqBO.getmCity())) {
            record.setSheetLevel("3");
        } else if ("5".equals(reqBO.getmUserLevel()) && StringUtils.isNotBlank((CharSequence)reqBO.getmShopId())) {
            record.setSheetLevel("5");
        } else {
            logger.error("\u62a5\u4ef7\u5355\u67e5\u8be2\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            result.setRespCode("9999");
            result.setRespDesc("\u62a5\u4ef7\u5355\u67e5\u8be2\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            return result;
        }
        record.setMaterialId(reqBO.getMaterialId());
        record.setBrandId(reqBO.getBrandId());
        record.setBrandName(reqBO.getBrandName());
        record.setIsRootControl(reqBO.getIsRootControl());
        record.setGoodsLongName(reqBO.getGoodsLongName());
        record.setProvinceCode(reqBO.getProvinceCode());
        record.setShopCode(reqBO.getShopCode());
        logger.debug("\u67e5\u8be2\u7801\u8868");
        ArrayList<ProvGoodsAndSheetBO> rows = new ArrayList<ProvGoodsAndSheetBO>();
        Map<String, Map<String, String>> escaMap = this.getEscape();
        try {
            List<ProvGoodsAndSheetPO> poList = this.provGoodsDAO.queryProvGoodsAndSheet(record);
            if (!CollectionUtils.isEmpty(poList)) {
                ProvGoodsAndSheetBO bo = null;
                for (ProvGoodsAndSheetPO po : poList) {
                    bo = new ProvGoodsAndSheetBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    bo.setCgTypeStr(escaMap.get("CGTYPE_STR").get(po.getCgType()));
                    bo.setGoodsSourceStr(escaMap.get("GOODS_SOURCE_STR").get(po.getGoodsSource()));
                    bo.setGoodsStallsStr(escaMap.get("GOODS_STALLS_STR").get(po.getGoodsStalls()));
                    bo.setGoodsStatusStr(escaMap.get("GOODS_STATUS_STR").get(po.getGoodsStatus()));
                    bo.setHasPriceStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getHasPrice()));
                    bo.setHasSerialNumberStr(escaMap.get("HAS_SERIAL_NUMBER_STR").get(po.getHasSerialNumber()));
                    bo.setIsAfterInputSte(escaMap.get("IS_AFTER_INPUT_STE").get(po.getIsAfterInput()));
                    bo.setIsScmDistributeStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getIsScmDistribute()));
                    bo.setIsSendScmSaleStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getIsSendScmSale()));
                    bo.setIsSendScmStockStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getIsSendScmStock()));
                    bo.setIsValidStr(escaMap.get("IS_VALID_STR").get(po.getIsValid()));
                    bo.setPurchaseTypeStr(escaMap.get("PURCHASE_TYPE_STR").get(po.getPurchaseType()));
                    bo.setStandardSystemStr(escaMap.get("STANDARD_SYSTEM_STR").get(po.getStandardSystem()));
                    bo.setIsRootControlStr(escaMap.get("IS_ROOT_CONTROL_STR").get(po.getIsRootControl()));
                    bo.setGoodsLevelStr(escaMap.get("GOODS_LEVEL_STR").get(po.getGoodsLevel()));
                    bo.setSheetLevelStr(escaMap.get("SHEET_LEVEL_STR").get(po.getSheetLevel()));
                    bo.setAgreementPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getAgreementPrice()));
                    bo.setAssessmentPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getAssessmentPrice()));
                    bo.setCostPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getCostPrice()));
                    bo.setLastPurchasePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getLastPurchasePrice()));
                    bo.setMemberLadderPrice1Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice1()));
                    bo.setMemberLadderPrice2Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice2()));
                    bo.setMemberLadderPrice3Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice3()));
                    bo.setMemberLadderPrice4Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice4()));
                    bo.setMemberLadderPrice5Str(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice5()));
                    bo.setMemberPriceStr(MoneyUtils.Long2BigDecimal((Long)po.getMemberPrice()));
                    bo.setProvAgreePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getProvAgreePrice()));
                    bo.setPurchasePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getPurchasePrice()));
                    if (!"1".equals(reqBO.getmVisiCost())) {
                        bo.setPurchasePriceStr(null);
                        bo.setPurchasePrice(null);
                        bo.setPurchasePriceY("****");
                    } else if (po.getPurchasePrice() != null) {
                        bo.setPurchasePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getPurchasePrice()));
                        bo.setPurchasePrice(po.getPurchasePrice());
                        bo.setPurchasePriceY(MoneyUtils.Long2BigDecimal((Long)po.getPurchasePrice()).toString());
                    }
                    bo.setSalePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getSalePrice()));
                    bo.setSparePrice2Str(MoneyUtils.Long2BigDecimal((Long)po.getSparePrice2()));
                    bo.setSparePrice3Str(StringUtils.isEmpty((CharSequence)po.getSparePrice3()) ? null : MoneyUtils.Long2BigDecimal((Long)Long.parseLong(po.getSparePrice3())));
                    bo.setSparePrice4Str(StringUtils.isEmpty((CharSequence)po.getSparePrice4()) ? null : MoneyUtils.Long2BigDecimal((Long)Long.parseLong(po.getSparePrice4())));
                    bo.setSparePrice5Str(StringUtils.isEmpty((CharSequence)po.getSparePrice5()) ? null : MoneyUtils.Long2BigDecimal((Long)Long.parseLong(po.getSparePrice5())));
                    bo.setTradePriceStr(MoneyUtils.Long2BigDecimal((Long)po.getTradePrice()));
                    bo.setIsCoverStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(po.getIsCover()));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String date = sdf.format(po.getSheetCreat());
                    bo.setCreateTime(date);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u53ca\u62a5\u4ef7\u5355\u67e5\u8be2\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u7701\u4efd\u5546\u54c1\u53ca\u62a5\u4ef7\u5355\u67e5\u8be2\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }
}

