/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.commodity.dao.po.SkuSpec;
import com.xls.commodity.busi.sku.QuerySkuListByCommodityIdService;
import com.xls.commodity.busi.sku.bo.QuerySkuListByCommodityIdReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuListByCommodityIdRspBO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuListByCommodityIdServiceImpl
implements QuerySkuListByCommodityIdService {
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SkuSpecMapper skuSpecMapper;
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuListByCommodityIdServiceImpl.class);

    public RspInfoListBO<QuerySkuListByCommodityIdRspBO> querySkuListByCommodityId(QuerySkuListByCommodityIdReqBO querySkuListByCommodityIdReqBO) {
        logger.info("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u53ca\u5355\u54c1\u7684\u7ef4\u5ea6\u4fe1\u606f\u5165\u53c2=" + querySkuListByCommodityIdReqBO.toString());
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<QuerySkuListByCommodityIdRspBO> querySkuListByCommodityIdRspBOs = new ArrayList<QuerySkuListByCommodityIdRspBO>();
        Sku sku = new Sku();
        sku.setCommodityId(querySkuListByCommodityIdReqBO.getCommodityId());
        sku.setMaterialId(querySkuListByCommodityIdReqBO.getMaterialId());
        List<Sku> skus = null;
        try {
            skus = this.xlsSkuMapper.selectByCommodityId(sku);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(skus)) {
            result.setRespCode("0000");
            result.setRespDesc("\u6210\u529f");
            return result;
        }
        ArrayList<SkuSpec> skuSpecs = new ArrayList<SkuSpec>();
        for (Sku sku1 : skus) {
            SkuSpec skuSpec = new SkuSpec();
            skuSpec.setSupplierId(sku1.getSupplierId());
            skuSpec.setSkuId(sku1.getSkuId());
            skuSpecs.add(skuSpec);
        }
        List skuSpecList = null;
        try {
            skuSpecList = this.skuSpecMapper.selectBySkuIdAndSupplierIds(skuSpecs);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
        }
        HashMap<Long, ArrayList<SkuSpec>> mapListSkuSpec = new HashMap<Long, ArrayList<SkuSpec>>();
        if (CollectionUtils.isNotEmpty((Collection)skuSpecList)) {
            for (SkuSpec skuSpec : skuSpecList) {
                ArrayList<SkuSpec> skuSpecs1 = (ArrayList<SkuSpec>)mapListSkuSpec.get(skuSpec.getSkuId());
                if (CollectionUtils.isEmpty((Collection)skuSpecs1)) {
                    skuSpecs1 = new ArrayList<SkuSpec>();
                    skuSpecs1.add(skuSpec);
                    mapListSkuSpec.put(skuSpec.getSkuId(), skuSpecs1);
                    continue;
                }
                skuSpecs1.add(skuSpec);
            }
        }
        logger.debug("mapListSkuSpec=" + ((Object)mapListSkuSpec).toString());
        for (Sku sku1 : skus) {
            QuerySkuListByCommodityIdRspBO querySkuListByCommodityIdRspBO = new QuerySkuListByCommodityIdRspBO();
            BeanUtils.copyProperties((Object)sku1, (Object)querySkuListByCommodityIdRspBO);
            if (null != sku1.getSkuPrice()) {
                String skuPrice = sku1.getSkuPrice() + "";
                BigDecimal price = new BigDecimal(skuPrice);
                querySkuListByCommodityIdRspBO.setPrice(price.divide(new BigDecimal("10000")).toString());
            }
            List skuSpecs1 = (List)mapListSkuSpec.get(sku1.getSkuId());
            String dimension = "";
            if (CollectionUtils.isNotEmpty((Collection)skuSpecs1)) {
                for (SkuSpec skuSpec1 : skuSpecs1) {
                    if (skuSpec1.getCommodityPropGrpId() == 900991231L) {
                        querySkuListByCommodityIdRspBO.setPp(skuSpec1.getPropValue());
                        continue;
                    }
                    if (skuSpec1.getCommodityPropGrpId() == 900991232L) {
                        querySkuListByCommodityIdRspBO.setXh(skuSpec1.getPropValue());
                        continue;
                    }
                    if (skuSpec1.getCommodityPropGrpId() == 900991233L) {
                        querySkuListByCommodityIdRspBO.setYs(skuSpec1.getPropValue());
                        continue;
                    }
                    if (skuSpec1.getCommodityPropGrpId() == 900991234L) {
                        querySkuListByCommodityIdRspBO.setNc(skuSpec1.getPropValue());
                        continue;
                    }
                    dimension = dimension + skuSpec1.getPropValue() + "+";
                }
                if (StringUtils.isNotEmpty((String)dimension)) {
                    dimension = dimension.substring(0, dimension.length() - 1);
                }
                querySkuListByCommodityIdRspBO.setDimension(dimension);
            }
            querySkuListByCommodityIdRspBOs.add(querySkuListByCommodityIdRspBO);
        }
        result.setRows(querySkuListByCommodityIdRspBOs);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }
}

