/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.custom.impl;

import com.ohaotian.commodity.custom.search.SearchEsQueryService;
import com.ohaotian.commodity.custom.search.bo.SearchEsQueryRspBO;
import com.ohaotian.commodity.custom.search.bo.SearchEsSQLRspBO;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class SearchEsQueryCustomServiceImpl
implements SearchEsQueryService {
    private static final Logger logger = LoggerFactory.getLogger(SearchEsQueryCustomServiceImpl.class);
    @Resource
    private TransportClient client;
    @Value(value="${es.sku.index.name}")
    private String skuIndexName;
    @Value(value="${es.sku.type.name}")
    private String skuTypeName;

    public SearchEsQueryRspBO executeSQL(SearchEsSQLRspBO searchEsSQLRspBO) {
        logger.info("SearchEsQueryService\u5165\u53c2\uff1a" + searchEsSQLRspBO.toString());
        SearchEsQueryRspBO searchBarEsQueryRspVO = null;
        try {
            searchBarEsQueryRspVO = new SearchEsQueryRspBO();
            Integer pageNo = 0;
            Integer pageSize = 10;
            if (searchEsSQLRspBO.getPageNo() != null && searchEsSQLRspBO.getPageNo() > 0) {
                pageNo = searchEsSQLRspBO.getPageNo() - 1;
            }
            if (searchEsSQLRspBO.getPageSize() != null && searchEsSQLRspBO.getPageSize() > 0) {
                pageSize = searchEsSQLRspBO.getPageSize();
            }
            SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.skuIndexName}).setTypes(new String[]{this.skuTypeName}).setQuery((QueryBuilder)searchEsSQLRspBO.getBoolQueryBuilder()).addSort((SortBuilder)searchEsSQLRspBO.getSortQuery()).setFrom(pageNo * pageSize).setSize(pageSize.intValue()).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_supplier_id_name").field("supplier_id_name")).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_brand_id_name").field("brand_id_name")).size(2000)).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_l3_category_id_name").field("l3_category_id_name")).size(2000)).addAggregation((AggregationBuilder)AggregationBuilders.terms((String)"group_by_properties").field("properties")).get();
            searchBarEsQueryRspVO.setSearchResponse(searchResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("SearchEsQueryService\u51fa\u53c2\uff1a" + searchBarEsQueryRspVO.toString());
        return searchBarEsQueryRspVO;
    }
}

