/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.syncInfo.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.commodity.atom.sku.UpdateSkuAtomService;
import com.ohaotian.commodity.atom.sku.bo.SkuBO;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.atom.sku.XlsCommodityManageService;
import com.xls.commodity.busi.sku.SortCommodityPriceService;
import com.xls.commodity.busi.sku.XlsElectronicPricePushBusiService;
import com.xls.commodity.busi.sku.bo.XlsCommodityBO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.mq.bo.ElectronicPriceTagPriceBO;
import com.xls.commodity.syncInfo.UpdateSkuPriceService;
import com.xls.commodity.syncInfo.bo.JgInfoReqBO;
import com.xls.commodity.syncInfo.bo.PriceInfoRspBO;
import com.xls.commodity.syncInfo.bo.UpdateSkuPriceReqBO;
import com.xls.commodity.syncInfo.bo.UpdateSkuPriceRspBO;
import com.xls.commodity.thread.PushElectronicPriceTagThread;
import com.xls.commodity.thread.PushPriceTagAndSortCommodityPriceThread;
import com.xls.commodity.util.CreateThreadUtils;
import com.xls.commodity.util.IntellPropertiesUtils;
import com.xls.commodity.util.SortLongListUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="updateSkuPriceService")
public class UpdateSkuPriceServiceImpl
implements UpdateSkuPriceService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSkuPriceServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private com.cgd.commodity.dao.SkuPriceMapper skuPriceMapper;
    @Autowired
    private XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService;
    @Autowired
    private UpdateSkuAtomService updateSkuAtomService;
    @Autowired
    private XlsCommodityManageService xlsCommodityManageService;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private SortCommodityPriceService sortCommodityPriceService;
    @Autowired
    private SkuPriceMapper skuPriceMapper1;
    @Resource(name="skuMaterialProducer")
    ProxyMessageProducer skuMaterialProducer;

    public UpdateSkuPriceRspBO updateSkuPrice(UpdateSkuPriceReqBO updateSkuPriceReqBO) {
        UpdateSkuPriceRspBO rspBO = new UpdateSkuPriceRspBO();
        logger.info("*********\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65start");
        List objList = updateSkuPriceReqBO.getJgInfo();
        ArrayList<PriceInfoRspBO> priceInfos = new ArrayList<PriceInfoRspBO>();
        ArrayList<ElectronicPriceTagPriceBO> messageList = new ArrayList<ElectronicPriceTagPriceBO>();
        Map<String, String> mapSysCommodityStatus = this.sysParamsAtomService.selectByParentCode("MEMBER_LADDER_PRICE_RULE");
        for (JgInfoReqBO jg : objList) {
            PriceInfoRspBO priceInfoRspBO;
            block53: {
                logger.info("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u5217\u8868\u5165\u53c2\uff1a{}", (Object)jg.toString());
                String mdID = jg.getMdID();
                String zjm = jg.getZjm();
                String scmID = jg.getScmID();
                String jgl = jg.getJgl();
                String vipPrice = jg.getVipPrice();
                String limitPrice = jg.getLimitPrice();
                String assessmentPrice = jg.getAssessmentPrice();
                String purchasePrice = jg.getPurchasePrice();
                String sparePrice1 = jg.getSparePrice1();
                String sparePrice2 = jg.getSparePrice2();
                priceInfoRspBO = new PriceInfoRspBO();
                try {
                    Sku sku = new Sku();
                    Long supplierId = null;
                    String materialId = null;
                    String extSkuId = null;
                    if (StringUtils.isNotBlank((String)mdID)) {
                        sku.setSupplierId(Long.valueOf(mdID));
                        supplierId = Long.valueOf(mdID);
                    }
                    if (StringUtils.isNotBlank((String)zjm)) {
                        sku.setExtSkuId(zjm);
                        extSkuId = zjm;
                    }
                    if (StringUtils.isNotBlank((String)scmID)) {
                        sku.setMaterialId(scmID);
                        materialId = scmID;
                    }
                    logger.info("\u5165\u53c2\u5355\u54c1\u4fe1\u606f: {}", (Object)sku.toString());
                    Sku skuPO = this.xlsSkuMapper.selectBySupplierIdAndOther(supplierId, materialId, extSkuId);
                    priceInfoRspBO.setMdID(supplierId.toString());
                    priceInfoRspBO.setScmID(materialId);
                    priceInfoRspBO.setZjm(extSkuId);
                    priceInfoRspBO.setAssessmentPrice(assessmentPrice);
                    priceInfoRspBO.setJgl(jgl);
                    priceInfoRspBO.setLimitPrice(limitPrice);
                    priceInfoRspBO.setPurchasePrice(purchasePrice);
                    priceInfoRspBO.setVipPrice(vipPrice);
                    if (skuPO != null && skuPO.getSkuId() != null && 0 != skuPO.getSkuStatus()) {
                        com.cgd.commodity.po.SkuPrice skuPrice;
                        Sku sku1 = new Sku();
                        List skuPrices = this.skuPriceMapper.selectBySkuId(skuPO.getSkuId(), skuPO.getSupplierId());
                        if (CollectionUtils.isNotEmpty((Collection)skuPrices)) {
                            skuPrice = new com.cgd.commodity.po.SkuPrice();
                            skuPrice = (com.cgd.commodity.po.SkuPrice)skuPrices.get(0);
                            if (null != skuPrice.getAssessmentPrice()) {
                                BigDecimal sourceAssessmentPrice = new BigDecimal(skuPrice.getAssessmentPrice().toString());
                                BigDecimal sourceAssessmentPriced = sourceAssessmentPrice.divide(new BigDecimal("10000"));
                                priceInfoRspBO.setSourceAssessmentPrice(sourceAssessmentPriced.toString());
                            }
                            if (null != skuPrice.getSalePrice()) {
                                BigDecimal sourceSalePrice = new BigDecimal(skuPrice.getSalePrice().toString());
                                BigDecimal sourceSalePriced = sourceSalePrice.divide(new BigDecimal("10000"));
                                priceInfoRspBO.setSourceJgl(sourceSalePriced.toString());
                            }
                            if (null != skuPrice.getAgreementPrice()) {
                                BigDecimal sourceAgreementPrice = new BigDecimal(skuPrice.getAgreementPrice().toString());
                                BigDecimal sourceAgreementPriced = sourceAgreementPrice.divide(new BigDecimal("10000"));
                                priceInfoRspBO.setSourceLimitPrice(sourceAgreementPriced.toString());
                            }
                            if (null != skuPrice.getPurchasePrice()) {
                                BigDecimal sourcePurchasePrice = new BigDecimal(skuPrice.getPurchasePrice().toString());
                                BigDecimal sourcePurchasePriced = sourcePurchasePrice.divide(new BigDecimal("10000"));
                                priceInfoRspBO.setSourcePurchasePrice(sourcePurchasePriced.toString());
                            }
                            if (null != skuPrice.getMemberPrice()) {
                                BigDecimal sourceMemberPrice = new BigDecimal(skuPrice.getMemberPrice().toString());
                                BigDecimal sourceMemberPriced = sourceMemberPrice.divide(new BigDecimal("10000"));
                                priceInfoRspBO.setSourceVipPrice(sourceMemberPriced.toString());
                            }
                        }
                        logger.info("\u5355\u54c1\u4fe1\u606f: {}", (Object)skuPO.toString());
                        skuPrice = new com.cgd.commodity.po.SkuPrice();
                        skuPrice.setSkuId(skuPO.getSkuId());
                        skuPrice.setSupplierId(skuPO.getSupplierId());
                        skuPrice.setUpdateTime(new Date());
                        if (StringUtils.isNotBlank((String)vipPrice) && vipPrice != "0") {
                            BigDecimal memberPrice = new BigDecimal(vipPrice);
                            skuPrice.setMemberPrice(MoneyUtils.BigDecimal2Long((BigDecimal)memberPrice));
                        }
                        if (StringUtils.isNotBlank((String)jgl) && jgl != "0") {
                            BigDecimal price = new BigDecimal(jgl);
                            skuPrice.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)price));
                            sku1.setSkuPrice(MoneyUtils.BigDecimal2Long((BigDecimal)price));
                        }
                        if (StringUtils.isNotBlank((String)limitPrice) && limitPrice != "0") {
                            BigDecimal limitedPrice = new BigDecimal(limitPrice);
                            skuPrice.setAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)limitedPrice));
                        }
                        if (StringUtils.isNotBlank((String)assessmentPrice) && assessmentPrice != "0") {
                            BigDecimal assessmentdPrice = new BigDecimal(assessmentPrice);
                            skuPrice.setAssessmentPrice(MoneyUtils.BigDecimal2Long((BigDecimal)assessmentdPrice));
                        }
                        if (StringUtils.isNotBlank((String)purchasePrice) && purchasePrice != "0") {
                            BigDecimal purchasedPrice = new BigDecimal(purchasePrice);
                            skuPrice.setPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)purchasedPrice));
                        }
                        if (StringUtils.isNotBlank((String)sparePrice1) && sparePrice1 != "0") {
                            BigDecimal sparedPrice1 = new BigDecimal(sparePrice1);
                            skuPrice.setSparePrice1(MoneyUtils.BigDecimal2Long((BigDecimal)sparedPrice1));
                        }
                        if (StringUtils.isNotBlank((String)sparePrice2) && sparePrice2 != "0") {
                            BigDecimal sparedPrice2 = new BigDecimal(sparePrice2);
                            skuPrice.setSparePrice2(MoneyUtils.BigDecimal2Long((BigDecimal)sparedPrice2));
                        }
                        logger.info("\u66f4\u65b0\u5355\u54c1\u4ef7\u683c: {}", (Object)skuPrice.toString());
                        try {
                            if (StringUtils.isNotBlank((String)skuPO.getCgType()) && "601".equals(skuPO.getCgType())) {
                                if (skuPrice.getPurchasePrice() != null) {
                                    String discountRateMemberLadderPrice1 = mapSysCommodityStatus.get("1");
                                    String discountRateMemberLadderPrice2 = mapSysCommodityStatus.get("3");
                                    String discountRateMemberLadderPrice3 = mapSysCommodityStatus.get("4");
                                    Double memberLadderPrice1 = (double)skuPrice.getPurchasePrice().longValue() + (double)(skuPrice.getSalePrice() - skuPrice.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice1);
                                    Double memberLadderPrice2 = (double)skuPrice.getPurchasePrice().longValue() + (double)(skuPrice.getSalePrice() - skuPrice.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice2);
                                    Double memberLadderPrice3 = (double)skuPrice.getPurchasePrice().longValue() + (double)(skuPrice.getSalePrice() - skuPrice.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice3);
                                    skuPrice.setMemberLadderPrice1(UpdateSkuPriceServiceImpl.roundingMemPrice(memberLadderPrice1));
                                    skuPrice.setMemberLadderPrice2(UpdateSkuPriceServiceImpl.roundingMemPrice(memberLadderPrice2));
                                    skuPrice.setMemberLadderPrice3(UpdateSkuPriceServiceImpl.roundingMemPrice(memberLadderPrice3));
                                } else {
                                    skuPrice.setMemberLadderPrice1(skuPrice.getSalePrice());
                                    skuPrice.setMemberLadderPrice2(skuPrice.getSalePrice());
                                    skuPrice.setMemberLadderPrice3(skuPrice.getSalePrice());
                                }
                            }
                            this.skuPriceMapper.updateBySkuIdKey(skuPrice);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("\u4fee\u6539\u4ef7\u683c\u8868\u4ef7\u683c\u6570\u636e\u5e93\u62a5\u9519=========" + e.getMessage());
                        }
                        if (StringUtils.isNotBlank((String)jgl)) {
                            sku1.setSkuId(skuPO.getSkuId());
                            sku1.setSupplierId(skuPO.getSupplierId());
                            sku1.setUpdateTime(new Date());
                            if (4 == skuPO.getSkuStatus() && !"0".equals(jgl) && !"0.0".equals(jgl)) {
                                logger.info("erp\u5165\u5e93\uff0c\u6ca1\u6709\u7d20\u6750\uff0c\u6ca1\u6709\u4ef7\u683c");
                                sku1.setSkuStatus(1);
                            } else if (5 == skuPO.getSkuStatus() && !"0".equals(jgl) && !"0.0".equals(jgl)) {
                                logger.info("\u5165\u5e93\uff0c\u6709\u7d20\u6750\uff0c\u6ca1\u6709\u4ef7\u683c");
                                sku1.setSkuStatus(2);
                            } else if (1 == skuPO.getSkuStatus()) {
                                if ("0".equals(jgl) || "0.0".equals(jgl)) {
                                    sku1.setSkuStatus(4);
                                }
                            } else if (2 == skuPO.getSkuStatus() && ("0".equals(jgl) || "0.0".equals(jgl))) {
                                sku1.setSkuStatus(5);
                            }
                            if (sku1.getSkuStatus() != null && 2 == sku1.getSkuStatus()) {
                                sku1.setOnShelveTime(new Date());
                            }
                            int flag = 0;
                            try {
                                flag = this.xlsSkuMapper.updatePriceBySkuIdKey(sku1);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                logger.error("\u4fee\u6539\u5355\u54c1\u8868\u4ef7\u683c\u6570\u636e\u5e93\u62a5\u9519=========" + e.getMessage());
                            }
                            if (flag > 0) {
                                List skus = null;
                                if (skuPO.getCommodityId() != null) {
                                    try {
                                        skus = this.updateSkuAtomService.selectByCommodityId(skuPO.getCommodityId());
                                    }
                                    catch (Exception e) {
                                        logger.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u5355\u54c1\u670d\u52a1\u62a5\u9519");
                                        throw new BusinessException("9999", "\u5355\u6761\u4fee\u6539\u5355\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
                                    }
                                }
                                if (CollectionUtils.isNotEmpty(skus)) {
                                    ArrayList<Long> priceList = new ArrayList<Long>();
                                    for (SkuBO skuBO : skus) {
                                        if (skuBO.getSkuStatus() != 2 || skuBO.getSkuPrice() == null) continue;
                                        priceList.add(skuBO.getSkuPrice());
                                    }
                                    if (CollectionUtils.isNotEmpty(priceList)) {
                                        logger.info("\u4ef7\u683c\u5217\u8868=" + ((Object)priceList).toString());
                                        Long[] numbers = SortLongListUtils.sortLongList(priceList);
                                        XlsCommodityBO xlsCommodityBO = new XlsCommodityBO();
                                        xlsCommodityBO.setCommodityId(skuPO.getCommodityId());
                                        xlsCommodityBO.setIsBindSku("1");
                                        xlsCommodityBO.setCommodityLowestPrice(numbers[0]);
                                        xlsCommodityBO.setCommodityHighestPrice(numbers[numbers.length - 1]);
                                        try {
                                            this.xlsCommodityManageService.updateXlsCommodity(xlsCommodityBO);
                                        }
                                        catch (Exception e) {
                                            logger.error("\u4fee\u6539\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u670d\u52a1\u62a5\u9519");
                                            throw new BusinessException("9999", "\u4fee\u6539\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u670d\u52a1\u62a5\u9519" + e.getMessage());
                                        }
                                    }
                                }
                                priceInfoRspBO.setCode("0000");
                                priceInfoRspBO.setMessage("\u6210\u529f");
                            } else {
                                priceInfoRspBO.setCode("8888");
                                priceInfoRspBO.setMessage("\u5931\u8d25");
                            }
                        }
                        PushElectronicPriceTagThread pushElectronicPriceTagThread = new PushElectronicPriceTagThread(this.xlsElectronicPricePushBusiService, skuPO.getSkuId(), skuPO.getSupplierId(), new ArrayList<Long>());
                        ExecutorService singleThreadPool = CreateThreadUtils.createSimpleThreadPool(pushElectronicPriceTagThread, "pushElectronicPriceTagThread", 1, 1);
                        singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
                        singleThreadPool.shutdown();
                        if (StringUtils.isNotBlank((String)jgl)) {
                            ElectronicPriceTagPriceBO electronicPriceTagPriceBO = new ElectronicPriceTagPriceBO();
                            if (null != skuPO.getSkuPriceTagName()) {
                                electronicPriceTagPriceBO.setSkuName(skuPO.getSkuPriceTagName());
                            } else {
                                electronicPriceTagPriceBO.setSkuName(skuPO.getSkuName());
                            }
                            electronicPriceTagPriceBO.setPrice(new BigDecimal(jgl));
                            electronicPriceTagPriceBO.setSkuId(skuPO.getSkuId());
                            electronicPriceTagPriceBO.setSupplierId(skuPO.getSupplierId());
                            messageList.add(electronicPriceTagPriceBO);
                        }
                        break block53;
                    }
                    logger.error(new Date() + "\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u5931\u8d25--------\u6ca1\u6709\u8fd9\u4e2a\u5546\u54c1");
                    priceInfoRspBO.setCode("8888");
                    priceInfoRspBO.setMessage(new Date() + "\u540c\u6b65\u5931\u8d25-\u6ca1\u6709\u8fd9\u4e2a\u5546\u54c1");
                }
                catch (Exception e) {
                    logger.error("****\u65b0\u96f6\u552e\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5931\u8d25\u3002" + e.getMessage());
                    logger.error("****\u65b0\u96f6\u552e\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5931\u8d25\u3002", (Throwable)e);
                    rspBO.setCode("8888");
                    rspBO.setMessage("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u5931\u8d25");
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u96f6\u552e\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5931\u8d25" + e.getMessage());
                }
            }
            priceInfos.add(priceInfoRspBO);
        }
        try {
            if (CollectionUtils.isNotEmpty(messageList)) {
                JSONArray messageJson = JSONArray.fromObject(messageList);
                logger.info("\u7535\u5b50\u4ef7\u7b7e\u540c\u6b65\u53d8\u4ef7\u6d88\u606f========" + messageJson.toString());
                ProxyMessage message = new ProxyMessage(IntellPropertiesUtils.getProperty("COMMODITY_PUSHPIC_PIC", ""), "COMMODITY_ELECTRONIC_TAG", messageJson.toString());
                message.setMessageId(IntellPropertiesUtils.getProperty("PID_COMMODITY_PUSHPIC_PIC", ""));
                ProxySendResult result = this.skuMaterialProducer.send(message);
                logger.info("\u53d1\u6d88\u606f\u7684\u56de\u590d\u72b6\u6001" + result.getStatus());
            }
        }
        catch (Exception e) {
            logger.error("*********\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65end", (Throwable)e);
            rspBO.setCode("0000");
            rspBO.setMessage("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u6210\u529f,\u7535\u5b50\u4ef7\u7b7e\u53d8\u4ef7\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01");
            rspBO.setPriceInfos(priceInfos);
            return rspBO;
        }
        logger.info("*********\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65end");
        rspBO.setCode("0000");
        rspBO.setMessage("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        rspBO.setPriceInfos(priceInfos);
        return rspBO;
    }

    public void setXlsSkuMapper(XlsSkuMapper xlsSkuMapper) {
        this.xlsSkuMapper = xlsSkuMapper;
    }

    public static Long roundingMemPrice(Double price) {
        if (price == null) {
            return null;
        }
        BigDecimal memberLadderPriceBigDecimal = null;
        try {
            memberLadderPriceBigDecimal = MoneyUtils.Long2BigDecimal((Long)price.longValue());
            memberLadderPriceBigDecimal = memberLadderPriceBigDecimal.setScale(0, 4);
            memberLadderPriceBigDecimal = memberLadderPriceBigDecimal.multiply(new BigDecimal("10000"));
        }
        catch (Exception e) {
            logger.error("\u56db\u820d\u4e94\u5165\u62a5\u9519");
            e.printStackTrace();
        }
        if (memberLadderPriceBigDecimal != null) {
            return memberLadderPriceBigDecimal.longValue();
        }
        return null;
    }

    public UpdateSkuPriceRspBO batchUpdateSkuPrice(UpdateSkuPriceReqBO updateSkuPriceReqBO) {
        logger.debug("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u4ef7\u683c\u7684\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)updateSkuPriceReqBO));
        UpdateSkuPriceRspBO updateSkuPriceRspBO = new UpdateSkuPriceRspBO();
        ArrayList<PriceInfoRspBO> priceInfoRspBOs = new ArrayList<PriceInfoRspBO>();
        List jgInfoReqBOs = updateSkuPriceReqBO.getJgInfo();
        if (CollectionUtils.isEmpty((Collection)jgInfoReqBOs)) {
            updateSkuPriceRspBO.setCode("0000");
            updateSkuPriceRspBO.setMessage("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u6210\u529f--\u540c\u6b65\u5217\u8868\u4e3a\u7a7a");
            updateSkuPriceRspBO.setPriceInfos(priceInfoRspBOs);
        }
        Map<String, String> mapSysCommodityStatus = this.sysParamsAtomService.selectByParentCode("MEMBER_LADDER_PRICE_RULE");
        HashMap<String, JgInfoReqBO> mapStringJgInfoReqBO = new HashMap<String, JgInfoReqBO>();
        HashMap<String, Sku> mapStringSku = new HashMap<String, Sku>();
        ArrayList<String> extSkuIds = new ArrayList<String>();
        for (JgInfoReqBO jgInfoReqBO : jgInfoReqBOs) {
            if (!StringUtils.isNotBlank((String)jgInfoReqBO.getMdID()) || !StringUtils.isNotBlank((String)jgInfoReqBO.getZjm())) continue;
            if (!extSkuIds.contains(jgInfoReqBO.getZjm())) {
                extSkuIds.add(jgInfoReqBO.getZjm());
            }
            Sku sku = new Sku();
            sku.setSupplierId(Long.valueOf(jgInfoReqBO.getMdID()));
            sku.setExtSkuId(jgInfoReqBO.getZjm());
            mapStringJgInfoReqBO.put(jgInfoReqBO.getMdID() + jgInfoReqBO.getZjm(), jgInfoReqBO);
            mapStringSku.put(jgInfoReqBO.getMdID() + jgInfoReqBO.getZjm(), sku);
        }
        HashMap<Long, JgInfoReqBO> mapLongJgInfoReqBO = new HashMap<Long, JgInfoReqBO>();
        HashMap<Long, Sku> mapLongSku = new HashMap<Long, Sku>();
        HashMap<String, Sku> mapStringSkued = new HashMap<String, Sku>();
        if (CollectionUtils.isNotEmpty(extSkuIds)) {
            List skuPrices;
            List<Sku> skus = this.xlsSkuMapper.selectByExtSkuIds(extSkuIds);
            if (CollectionUtils.isNotEmpty(skus)) {
                for (Sku sku : skus) {
                    mapStringSkued.put(sku.getSupplierId() + sku.getExtSkuId(), sku);
                }
            }
            ArrayList skusNew = new ArrayList();
            if (!mapStringSkued.isEmpty()) {
                for (Map.Entry entry : mapStringSku.entrySet()) {
                    if (!mapStringSkued.containsKey(entry.getKey())) continue;
                    skusNew.add(mapStringSkued.get(entry.getKey()));
                }
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(skusNew)) {
                for (Sku sku : skusNew) {
                    mapLongSku.put(sku.getSkuId(), sku);
                    JgInfoReqBO jgInfoReqBO = (JgInfoReqBO)mapStringJgInfoReqBO.get(sku.getSupplierId() + sku.getExtSkuId());
                    mapStringJgInfoReqBO.remove(sku.getSupplierId() + sku.getExtSkuId());
                    if (sku.getSkuId() != null) {
                        arrayList.add(sku.getSkuId());
                    }
                    if (sku.getCommodityId() != null) {
                        arrayList2.add(sku.getCommodityId());
                    }
                    mapLongJgInfoReqBO.put(sku.getSkuId(), jgInfoReqBO);
                }
            }
            if (CollectionUtils.isNotEmpty(arrayList) && CollectionUtils.isNotEmpty((Collection)(skuPrices = this.skuPriceMapper1.selectBySkuIds(arrayList)))) {
                ArrayList<SkuPrice> skuPrice1s = new ArrayList<SkuPrice>();
                ArrayList<Sku> sku1s = new ArrayList<Sku>();
                for (SkuPrice skuPrice : skuPrices) {
                    BigDecimal sourcePurchasePriced;
                    BigDecimal sourcePurchasePrice;
                    Sku sku = (Sku)mapLongSku.get(skuPrice.getSkuId());
                    JgInfoReqBO jgInfoReqBO = (JgInfoReqBO)mapLongJgInfoReqBO.get(skuPrice.getSkuId());
                    String jgl = jgInfoReqBO.getJgl();
                    String vipPrice = jgInfoReqBO.getVipPrice();
                    String limitPrice = jgInfoReqBO.getLimitPrice();
                    String assessmentPrice = jgInfoReqBO.getAssessmentPrice();
                    String purchasePrice = jgInfoReqBO.getPurchasePrice();
                    String sparePrice1 = jgInfoReqBO.getSparePrice1();
                    String sparePrice2 = jgInfoReqBO.getSparePrice2();
                    Sku sku1 = new Sku();
                    sku1.setSkuId(sku.getSkuId());
                    sku1.setSupplierId(sku.getSupplierId());
                    sku1.setUpdateTime(new Date());
                    SkuPrice skuPrice1 = new SkuPrice();
                    skuPrice1.setSkuId(sku.getSkuId());
                    skuPrice1.setSupplierId(sku.getSupplierId());
                    skuPrice1.setUpdateTime(new Date());
                    if (4 == sku.getSkuStatus() && !"0".equals(jgl) && !"0.0".equals(jgl)) {
                        logger.info("erp\u5165\u5e93\uff0c\u6ca1\u6709\u7d20\u6750\uff0c\u6ca1\u6709\u4ef7\u683c");
                        sku1.setSkuStatus(1);
                    } else if (5 == sku.getSkuStatus() && !"0".equals(jgl) && !"0.0".equals(jgl)) {
                        logger.info("\u5165\u5e93\uff0c\u6709\u7d20\u6750\uff0c\u6ca1\u6709\u4ef7\u683c");
                        sku1.setSkuStatus(2);
                    } else if (1 == sku.getSkuStatus()) {
                        if ("0".equals(jgl) || "0.0".equals(jgl)) {
                            sku1.setSkuStatus(4);
                        }
                    } else if (2 == sku.getSkuStatus() && ("0".equals(jgl) || "0.0".equals(jgl))) {
                        sku1.setSkuStatus(5);
                    }
                    if (sku1.getSkuStatus() != null && 2 == sku1.getSkuStatus()) {
                        sku1.setOnShelveTime(new Date());
                    }
                    try {
                        if (StringUtils.isNotBlank((String)vipPrice) && vipPrice != "0") {
                            BigDecimal memberPrice = new BigDecimal(vipPrice);
                            skuPrice1.setMemberPrice(MoneyUtils.BigDecimal2Long((BigDecimal)memberPrice));
                        }
                        if (StringUtils.isNotBlank((String)jgl) && jgl != "0") {
                            BigDecimal price = new BigDecimal(jgl);
                            skuPrice1.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)price));
                            sku1.setSkuPrice(MoneyUtils.BigDecimal2Long((BigDecimal)price));
                        }
                        if (StringUtils.isNotBlank((String)limitPrice) && limitPrice != "0") {
                            BigDecimal limitedPrice = new BigDecimal(limitPrice);
                            skuPrice1.setAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)limitedPrice));
                        }
                        if (StringUtils.isNotBlank((String)assessmentPrice) && assessmentPrice != "0") {
                            BigDecimal assessmentdPrice = new BigDecimal(assessmentPrice);
                            skuPrice1.setAssessmentPrice(MoneyUtils.BigDecimal2Long((BigDecimal)assessmentdPrice));
                        }
                        if (StringUtils.isNotBlank((String)purchasePrice) && purchasePrice != "0") {
                            BigDecimal purchasedPrice = new BigDecimal(purchasePrice);
                            skuPrice1.setPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)purchasedPrice));
                        }
                        if (StringUtils.isNotBlank((String)sparePrice1) && sparePrice1 != "0") {
                            BigDecimal sparedPrice1 = new BigDecimal(sparePrice1);
                            skuPrice1.setSparePrice1(MoneyUtils.BigDecimal2Long((BigDecimal)sparedPrice1));
                        }
                        if (StringUtils.isNotBlank((String)sparePrice2) && sparePrice2 != "0") {
                            BigDecimal sparedPrice2 = new BigDecimal(sparePrice2);
                            skuPrice1.setSparePrice2(MoneyUtils.BigDecimal2Long((BigDecimal)sparedPrice2));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u4ef7\u683c\u8f6c\u6362\u9519\u8bef");
                    }
                    if (StringUtils.isNotBlank((String)sku.getCgType()) && "601".equals(sku.getCgType())) {
                        if (skuPrice1.getPurchasePrice() != null) {
                            String discountRateMemberLadderPrice1 = mapSysCommodityStatus.get("1");
                            String discountRateMemberLadderPrice2 = mapSysCommodityStatus.get("3");
                            String discountRateMemberLadderPrice3 = mapSysCommodityStatus.get("4");
                            Double memberLadderPrice1 = (double)skuPrice1.getPurchasePrice().longValue() + (double)(skuPrice1.getSalePrice() - skuPrice1.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice1);
                            Double memberLadderPrice2 = (double)skuPrice1.getPurchasePrice().longValue() + (double)(skuPrice1.getSalePrice() - skuPrice1.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice2);
                            Double memberLadderPrice3 = (double)skuPrice1.getPurchasePrice().longValue() + (double)(skuPrice1.getSalePrice() - skuPrice1.getPurchasePrice()) * Double.parseDouble(discountRateMemberLadderPrice3);
                            skuPrice1.setMemberLadderPrice1(UpdateSkuPriceServiceImpl.roundingMemPrice(memberLadderPrice1));
                            skuPrice1.setMemberLadderPrice2(UpdateSkuPriceServiceImpl.roundingMemPrice(memberLadderPrice2));
                            skuPrice1.setMemberLadderPrice3(UpdateSkuPriceServiceImpl.roundingMemPrice(memberLadderPrice3));
                        } else {
                            skuPrice1.setMemberLadderPrice1(skuPrice1.getSalePrice());
                            skuPrice1.setMemberLadderPrice2(skuPrice1.getSalePrice());
                            skuPrice1.setMemberLadderPrice3(skuPrice1.getSalePrice());
                        }
                    }
                    skuPrice1s.add(skuPrice1);
                    sku1s.add(sku1);
                    PriceInfoRspBO priceInfoRspBO = new PriceInfoRspBO();
                    if (null != skuPrice.getAssessmentPrice()) {
                        BigDecimal sourceAssessmentPrice = new BigDecimal(skuPrice.getAssessmentPrice().toString());
                        BigDecimal sourceAssessmentPriced = sourceAssessmentPrice.divide(new BigDecimal("10000"));
                        priceInfoRspBO.setSourceAssessmentPrice(sourceAssessmentPriced.toString());
                    }
                    if (null != skuPrice.getSalePrice()) {
                        BigDecimal sourceSalePrice = new BigDecimal(skuPrice.getSalePrice().toString());
                        BigDecimal sourceSalePriced = sourceSalePrice.divide(new BigDecimal("10000"));
                        priceInfoRspBO.setSourceJgl(sourceSalePriced.toString());
                    }
                    if (null != skuPrice.getAgreementPrice()) {
                        BigDecimal sourceAgreementPrice = new BigDecimal(skuPrice.getAgreementPrice().toString());
                        BigDecimal sourceAgreementPriced = sourceAgreementPrice.divide(new BigDecimal("10000"));
                        priceInfoRspBO.setSourceLimitPrice(sourceAgreementPriced.toString());
                    }
                    if (null != skuPrice.getPurchasePrice()) {
                        sourcePurchasePrice = new BigDecimal(skuPrice.getPurchasePrice().toString());
                        sourcePurchasePriced = sourcePurchasePrice.divide(new BigDecimal("10000"));
                        priceInfoRspBO.setSourcePurchasePrice(sourcePurchasePriced.toString());
                    }
                    if (null != skuPrice.getSparePrice1()) {
                        sourcePurchasePrice = new BigDecimal(skuPrice.getSparePrice1().toString());
                        sourcePurchasePriced = sourcePurchasePrice.divide(new BigDecimal("10000"));
                        priceInfoRspBO.setSourcePurchasePrice(sourcePurchasePriced.toString());
                    }
                    if (null != skuPrice.getMemberPrice()) {
                        BigDecimal sourceMemberPrice = new BigDecimal(skuPrice.getMemberPrice().toString());
                        BigDecimal sourceMemberPriced = sourceMemberPrice.divide(new BigDecimal("10000"));
                        priceInfoRspBO.setSourceVipPrice(sourceMemberPriced.toString());
                    }
                    priceInfoRspBO.setMdID(jgInfoReqBO.getMdID());
                    priceInfoRspBO.setScmID(jgInfoReqBO.getScmID());
                    priceInfoRspBO.setZjm(jgInfoReqBO.getZjm());
                    priceInfoRspBO.setAssessmentPrice(jgInfoReqBO.getAssessmentPrice());
                    priceInfoRspBO.setJgl(jgInfoReqBO.getJgl());
                    priceInfoRspBO.setLimitPrice(jgInfoReqBO.getLimitPrice());
                    if (StringUtils.isNotBlank((String)jgInfoReqBO.getPurchasePrice())) {
                        priceInfoRspBO.setPurchasePrice(jgInfoReqBO.getPurchasePrice());
                    }
                    if (StringUtils.isNotBlank((String)jgInfoReqBO.getSparePrice1())) {
                        priceInfoRspBO.setPurchasePrice(jgInfoReqBO.getSparePrice1());
                    }
                    priceInfoRspBO.setVipPrice(jgInfoReqBO.getVipPrice());
                    priceInfoRspBOs.add(priceInfoRspBO);
                }
                boolean flag1 = false;
                if (CollectionUtils.isNotEmpty(skuPrice1s)) {
                    try {
                        if (this.skuPriceMapper1.batchUpdateBySkuId(skuPrice1s) > 0) {
                            flag1 = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u4ef7\u683c\u8868\u62a5\u9519");
                    }
                }
                boolean flag2 = false;
                if (CollectionUtils.isNotEmpty(sku1s)) {
                    try {
                        if (this.xlsSkuMapper.batchUpdateBySkuId(sku1s) > 0) {
                            flag2 = true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u8868\u7684\u4ef7\u683c\u62a5\u9519");
                    }
                }
                if (flag1 && flag2) {
                    if (CollectionUtils.isNotEmpty(priceInfoRspBOs)) {
                        priceInfoRspBOs.forEach(new Consumer<PriceInfoRspBO>(){

                            @Override
                            public void accept(PriceInfoRspBO priceInfoRspBO) {
                                priceInfoRspBO.setCode("0000");
                                priceInfoRspBO.setMessage("\u6210\u529f");
                            }
                        });
                    }
                } else if (CollectionUtils.isNotEmpty(priceInfoRspBOs)) {
                    priceInfoRspBOs.forEach(new Consumer<PriceInfoRspBO>(){

                        @Override
                        public void accept(PriceInfoRspBO priceInfoRspBO) {
                            priceInfoRspBO.setCode("8888");
                            priceInfoRspBO.setMessage("\u5931\u8d25");
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty(arrayList) || CollectionUtils.isNotEmpty(arrayList2)) {
                    PushPriceTagAndSortCommodityPriceThread pushPriceTagAndSortCommodityPriceThread = new PushPriceTagAndSortCommodityPriceThread(this.sortCommodityPriceService, this.xlsElectronicPricePushBusiService, arrayList, arrayList2);
                    ExecutorService singleThreadPool = CreateThreadUtils.createSimpleThreadPool(pushPriceTagAndSortCommodityPriceThread, "pushPriceTagAndSortCommodityPriceThread", 1, 1);
                    singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
                    singleThreadPool.shutdown();
                }
            }
        }
        logger.debug("\u5728\u6570\u636e\u5e93\u6ca1\u6709\u67e5\u5230\u7684\u5355\u54c1\u5217\u8868\u7684\u6570\u91cf=" + mapStringJgInfoReqBO.size());
        logger.debug("\u5c06\u8981\u4fee\u6539\u7684\u5355\u54c1\u5217\u8868\u7684\u6570\u91cf=" + mapLongJgInfoReqBO.size());
        if (!mapStringJgInfoReqBO.isEmpty()) {
            for (Map.Entry entry : mapStringJgInfoReqBO.entrySet()) {
                JgInfoReqBO jgInfoReqBO = (JgInfoReqBO)entry.getValue();
                if (jgInfoReqBO == null) continue;
                PriceInfoRspBO priceInfoRspBO = new PriceInfoRspBO();
                priceInfoRspBO.setMdID(jgInfoReqBO.getMdID());
                priceInfoRspBO.setScmID(jgInfoReqBO.getScmID());
                priceInfoRspBO.setZjm(jgInfoReqBO.getZjm());
                priceInfoRspBO.setAssessmentPrice(jgInfoReqBO.getAssessmentPrice());
                priceInfoRspBO.setJgl(jgInfoReqBO.getJgl());
                priceInfoRspBO.setLimitPrice(jgInfoReqBO.getLimitPrice());
                if (StringUtils.isNotBlank((String)jgInfoReqBO.getPurchasePrice())) {
                    priceInfoRspBO.setPurchasePrice(jgInfoReqBO.getPurchasePrice());
                }
                if (StringUtils.isNotBlank((String)jgInfoReqBO.getSparePrice1())) {
                    priceInfoRspBO.setPurchasePrice(jgInfoReqBO.getSparePrice1());
                }
                priceInfoRspBO.setVipPrice(jgInfoReqBO.getVipPrice());
                priceInfoRspBO.setCode("8888");
                priceInfoRspBO.setMessage(new Date() + "\u540c\u6b65\u5931\u8d25-\u6ca1\u6709\u8fd9\u4e2a\u5546\u54c1");
                priceInfoRspBOs.add(priceInfoRspBO);
            }
        }
        updateSkuPriceRspBO.setPriceInfos(priceInfoRspBOs);
        updateSkuPriceRspBO.setCode("0000");
        updateSkuPriceRspBO.setMessage("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        return updateSkuPriceRspBO;
    }
}

