/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.util;

import io.netty.channel.ConnectTimeoutException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUntil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUntil.class);

    public String httpPost(String url, String json) {
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
        CloseableHttpResponse response = null;
        StringBuilder result = new StringBuilder("");
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).build();
        String status = null;
        String rsp = null;
        long time = 0L;
        try {
            HttpEntity resp;
            HttpPost post = new HttpPost(url);
            StringEntity s = new StringEntity(json, "utf-8");
            s.setContentEncoding("UTF-8");
            post.setHeader("Content-type", "application/json");
            post.setEntity((HttpEntity)s);
            RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).build();
            post.setConfig(config);
            logger.debug("\u53d1\u9001http\u8bf7\u6c42\u3002\u3002\u3002");
            long startTime = System.currentTimeMillis();
            response = httpClient.execute((HttpUriRequest)post);
            time = System.currentTimeMillis() - startTime;
            int statusCode = response.getStatusLine().getStatusCode();
            status = String.valueOf(statusCode);
            if (statusCode == 200 && (resp = response.getEntity()) != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resp.getContent(), "UTF-8"));
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    result.append(line);
                }
                bufferedReader.close();
            }
            rsp = result.toString();
            logger.debug("\u5f97\u5230\u8fd4\u56de\u503c\u3002\u3002\u3002" + result.toString());
        }
        catch (SocketTimeoutException e) {
            logger.error("\u8bf7\u6c42\u7535\u5b50\u4ef7\u7b7e\u63a5\u53e3\u54cd\u5e94\u8d85\u65f6");
            rsp = "\u8bf7\u6c42\u7535\u5b50\u4ef7\u7b7e\u63a5\u53e3\u54cd\u5e94\u8d85\u65f6";
            throw new RuntimeException("\u8bf7\u6c42\u7535\u5b50\u4ef7\u7b7e\u63a5\u53e3\u54cd\u5e94\u8d85\u65f6");
        }
        catch (ConnectTimeoutException e) {
            logger.error("\u8bf7\u6c42\u7535\u5b50\u4ef7\u7b7e\u63a5\u53e3\u8fde\u63a5\u8d85\u65f6");
            rsp = "\u8bf7\u6c42\u7535\u5b50\u4ef7\u7b7e\u63a5\u53e3\u8fde\u63a5\u8d85\u65f6";
            throw new RuntimeException("\u8bf7\u6c42\u7535\u5b50\u4ef7\u7b7e\u63a5\u53e3\u8fde\u63a5\u8d85\u65f6");
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            rsp = "\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage();
            throw new RuntimeException(e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }
}

