/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.util;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class RedisUtil {
    private static final Logger logger = LoggerFactory.getLogger(RedisUtil.class);
    @Resource(name="jedisPool")
    private JedisPool jedisPoolService;
    public static JedisPool jedisPool;

    @PostConstruct
    public void init() {
        jedisPool = this.jedisPoolService;
    }

    public static Jedis getJedis() {
        return jedisPool.getResource();
    }

    public static void release(Jedis jedis) {
        if (null != jedis) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(String key, String member) {
        Boolean flag = false;
        Jedis jedis = RedisUtil.getJedis();
        try {
            flag = jedis.sismember(key, member);
        }
        finally {
            RedisUtil.release(jedis);
        }
        return flag;
    }

    public static void sAdd(String key, String value) {
        Jedis jedis = RedisUtil.getJedis();
        try {
            if (null != value) {
                jedis.sadd(key, new String[]{value});
            }
        }
        finally {
            RedisUtil.release(jedis);
        }
    }

    public static void sAdds(String key, String[] values) {
        Jedis jedis = RedisUtil.getJedis();
        try {
            if (null != values) {
                jedis.sadd(key, values);
            }
        }
        finally {
            RedisUtil.release(jedis);
        }
    }

    public static void sDels(String key, String[] values) {
        Jedis jedis = RedisUtil.getJedis();
        try {
            if (null != values) {
                jedis.srem(key, values);
            }
        }
        finally {
            RedisUtil.release(jedis);
        }
    }

    public static void del(String key) {
        Jedis jedis = RedisUtil.getJedis();
        try {
            jedis.del(key);
        }
        finally {
            RedisUtil.release(jedis);
        }
    }

    public static Set<String> sMembers(String key) {
        HashSet<String> set = new HashSet();
        Jedis jedis = RedisUtil.getJedis();
        try {
            set = jedis.smembers(key);
        }
        finally {
            RedisUtil.release(jedis);
        }
        return set;
    }
}

