/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.util;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.tydic.newretail.toolkit.util.TkOssObjectRsp;
import com.xls.commodity.util.SCSOssConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SCSOssFileUtils {
    private static final Logger log = LoggerFactory.getLogger(SCSOssFileUtils.class);
    @Value(value="${OSS_ENDPOINT}")
    private String endpoint;
    @Value(value="${OSS_ACCESSKEY}")
    private String accessKeyId;
    @Value(value="${OSS_ACCESSKEY_SECRET}")
    private String accessKeySecret;
    @Value(value="${OSS_BUCKETNAME}")
    private String bucketName;
    @Value(value="${OSS_ACCESS_URL}")
    private String accessUrl;
    private static SCSOssConfig ossConfig;

    @Bean
    public SCSOssConfig tkOssConfig() {
        this.init();
        return ossConfig;
    }

    public void init() {
        if (StringUtils.isNotBlank((CharSequence)this.endpoint) && StringUtils.isNotBlank((CharSequence)this.accessKeyId) && StringUtils.isNotBlank((CharSequence)this.accessKeySecret) && StringUtils.isNotBlank((CharSequence)this.accessUrl)) {
            ossConfig = new SCSOssConfig(this.endpoint, this.accessKeyId, this.accessKeySecret, this.bucketName, this.accessUrl);
        }
    }

    public static SCSOssConfig getOssConfig() {
        return ossConfig;
    }

    public static void uploadByUrl(String url, String filePath, SCSOssConfig ossConfig) {
        if (null == ossConfig) {
            ossConfig = SCSOssFileUtils.ossConfig;
        }
        OSSClient ossClient = SCSOssFileUtils.getOssclient(ossConfig);
        InputStream inputStream = null;
        try {
            inputStream = new URL(url).openStream();
            ossClient.putObject(ossConfig.getBucketName(), filePath, inputStream);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (FileNotFoundException e) {
            log.error("\u6587\u4ef6\u4e0d\u5b58\u5728");
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u7f51\u7edc\u6d41\u5931\u8d25\uff1a" + e);
            throw new RuntimeException("\u4e0a\u4f20\u7f51\u7edc\u6d41\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyFile(String sourceBucketName, String targetBucketName, String sourceFileName, String targetFileName, SCSOssConfig ossConfig) {
        if (StringUtils.isBlank((CharSequence)sourceFileName) || StringUtils.isBlank((CharSequence)targetFileName)) {
            log.error("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
            throw new RuntimeException("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)sourceBucketName)) {
            sourceBucketName = ossConfig.getBucketName();
        }
        if (StringUtils.isBlank((CharSequence)targetBucketName)) {
            targetBucketName = ossConfig.getBucketName();
        }
        if (null == ossConfig) {
            ossConfig = SCSOssFileUtils.ossConfig;
        }
        OSSClient ossClient = SCSOssFileUtils.getOssclient(ossConfig);
        try {
            ossClient.copyObject(sourceBucketName, sourceFileName, targetBucketName, targetFileName);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u62f7\u8d1doss\u6587\u4ef6\u5931\u8d25\uff1a" + e);
            throw new RuntimeException("\u62f7\u8d1doss\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
    }

    public static TkOssObjectRsp listFilesByPage(String nextMarker, int maxKeys, String filePath, SCSOssConfig ossConfig) {
        ObjectListing objectListing;
        if (0 > maxKeys || 1000 < maxKeys) {
            throw new RuntimeException("maxKeys\u4e0d\u80fd\u5c0f\u4e8e0\u4e14\u4e0d\u80fd\u5927\u4e8e1000");
        }
        if (null == ossConfig) {
            ossConfig = SCSOssFileUtils.ossConfig;
        }
        OSSClient ossClient = SCSOssFileUtils.getOssclient(ossConfig);
        TkOssObjectRsp rsp = new TkOssObjectRsp();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(ossConfig.getBucketName()).withMarker(nextMarker).withMaxKeys(Integer.valueOf(maxKeys));
        listObjectsRequest.setPrefix(filePath);
        try {
            objectListing = ossClient.listObjects(listObjectsRequest);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u5217\u4e3eoss\u6587\u4ef6\u5931\u8d25\uff1a" + e);
            throw new RuntimeException("\u5217\u4e3eoss\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
        List sums = objectListing.getObjectSummaries();
        nextMarker = objectListing.getNextMarker();
        boolean isTruncated = objectListing.isTruncated();
        rsp.setTruncated(Boolean.valueOf(isTruncated));
        rsp.setOssObjectSummaries(sums);
        rsp.setNextMarker(nextMarker);
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OSSObjectSummary> listFiles(String filePath, Boolean readSubFile, SCSOssConfig ossConfig) {
        List sums = new ArrayList();
        OSSClient ossClient = SCSOssFileUtils.getOssclient(ossConfig);
        try {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(ossConfig.getBucketName());
            if (!readSubFile.booleanValue()) {
                listObjectsRequest.setDelimiter("/");
            }
            if (!filePath.startsWith("/")) {
                filePath = "/" + filePath;
            }
            if (!filePath.endsWith("/")) {
                filePath = filePath + "/";
            }
            listObjectsRequest.setPrefix(ossConfig.getBucketName() + filePath);
            ObjectListing objectListing = ossClient.listObjects(listObjectsRequest);
            sums = objectListing.getObjectSummaries();
        }
        catch (OSSException var7) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
        }
        catch (ClientException var8) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
        }
        catch (Exception E) {
            log.error(E.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
        return sums;
    }

    public static void uploadFileToPath(File file, String uploadPath, SCSOssConfig ossConfig) {
        if (uploadPath.startsWith("/")) {
            uploadPath = uploadPath.substring(1, uploadPath.length());
        }
        if (null == ossConfig) {
            ossConfig = SCSOssFileUtils.ossConfig;
        }
        SCSOssFileUtils.uploadFilePubMethod(file, uploadPath, ossConfig);
    }

    public static File downloadFileFromPath(String filePath, SCSOssConfig ossConfig, boolean reName) {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1, filePath.length());
        }
        if (null == ossConfig) {
            ossConfig = SCSOssFileUtils.ossConfig;
        }
        return SCSOssFileUtils.downloadFilePubMethod(filePath, ossConfig, reName);
    }

    private static File downloadFilePubMethod(String filePath, SCSOssConfig ossConfig, boolean reName) {
        OSSClient ossClient = SCSOssFileUtils.getOssclient(ossConfig);
        String dir = System.getProperty("java.io.tmpdir");
        File dirFile = null;
        dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
        String fileName = filePath.substring(filePath.lastIndexOf("/"), filePath.length());
        if (reName) {
            fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        }
        dir = dir + File.separator + fileName;
        dirFile = new File(dir);
        try {
            ossClient.getObject(new GetObjectRequest(ossConfig.getBucketName(), filePath), dirFile);
        }
        catch (Throwable e) {
            log.error("\u4eceoss\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath + ";\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84:" + filePath, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
        return dirFile;
    }

    private static void uploadFilePubMethod(File file, String uploadPath, SCSOssConfig ossConfig) {
        OSSClient ossClient = SCSOssFileUtils.getOssclient(ossConfig);
        String fileName = file.getName();
        FileInputStream content = null;
        try {
            content = new FileInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(file.length());
            ossClient.putObject(ossConfig.getBucketName(), uploadPath + fileName, (InputStream)content, meta);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (FileNotFoundException e) {
            log.error("\u68c0\u67e5\u6587\u4ef6\u3010" + fileName + "\u662f\u5426\u5b58\u5728\u3011", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (null != content) {
                    ((InputStream)content).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
    }

    public static List<String> removeOssFile(List<String> keys, SCSOssConfig ossConfig, Boolean quiet) {
        if (CollectionUtils.isEmpty(keys)) {
            throw new RuntimeException("\u6587\u4ef6\u96c6\u5408\u5fc5\u586b");
        }
        if (keys.size() > 1000) {
            throw new RuntimeException("\u6587\u4ef6\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e1000");
        }
        if (null == quiet) {
            quiet = true;
        }
        if (null == ossConfig) {
            ossConfig = SCSOssFileUtils.ossConfig;
        }
        OSSClient ossClient = null;
        try {
            List deletedObjects;
            ossClient = SCSOssFileUtils.getOssclient(ossConfig);
            DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(ossConfig.getBucketName()).withKeys(keys).withQuiet(quiet.booleanValue()));
            List list = deletedObjects = deleteObjectsResult.getDeletedObjects();
            return list;
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            log.error("\u5220\u9664oss\u6587\u4ef6\u5931\u8d25\uff1a" + e);
            throw new RuntimeException("\u5220\u9664oss\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
    }

    public static OSSClient getOssclient(SCSOssConfig ossConfig) {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setSupportCname(true);
        OSSClient ossClient = new OSSClient(ossConfig.getEndpoint(), ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret(), conf);
        return ossClient;
    }
}

