/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.authority.controller.application;

import com.ohaotian.authority.application.bo.ChangeAppOrderReqBO;
import com.ohaotian.authority.application.bo.DeleteApplicationReqBO;
import com.ohaotian.authority.application.bo.SaveApplicationReqBO;
import com.ohaotian.authority.application.bo.SelectAppforUserHaveReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByIdReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByIdRspBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeReqBO;
import com.ohaotian.authority.application.bo.UpdateApplicationByRecReqBO;
import com.ohaotian.authority.application.service.ChangeAppOrderDownBusiService;
import com.ohaotian.authority.application.service.ChangeAppOrderUpBusiService;
import com.ohaotian.authority.application.service.DeleteApplicationBusiServcie;
import com.ohaotian.authority.application.service.SaveApplicationBusiService;
import com.ohaotian.authority.application.service.SelectAllApplicationsBusiService;
import com.ohaotian.authority.application.service.SelectAppforUserHaveService;
import com.ohaotian.authority.application.service.SelectApplicationByIdBusiService;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.application.service.SelectByValidBusiService;
import com.ohaotian.authority.application.service.UpdateApplicationByRecBusiService;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.gray.bo.DeleteGrayByAppIdReqBO;
import com.ohaotian.authority.gray.bo.GraySwitchReqBO;
import com.ohaotian.authority.gray.service.DeleteGrayByAppIdBusiService;
import com.ohaotian.authority.gray.service.InsertGraySwitchService;
import com.ohaotian.authority.gray.service.UpdateGraySwitchByAppIdBusiService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pesapp.common.JsonBusiResponseBody;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/author/application"}, method={RequestMethod.GET, RequestMethod.POST})
public class ApplicationController {
    private Logger logger = LoggerFactory.getLogger(ApplicationController.class);
    @Autowired
    private SelectByValidBusiService selectByValidBusiService;
    @Autowired
    private SaveApplicationBusiService saveApplicationBusiService;
    @Autowired
    private SelectAllApplicationsBusiService selectAllApplicationsBusiService;
    @Autowired
    private UpdateApplicationByRecBusiService updateApplicationByRecBusiService;
    @Autowired
    private SelectApplicationByIdBusiService selectApplicationByIdBusiService;
    @Autowired
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @Autowired
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @Autowired
    private ChangeAppOrderUpBusiService changeAppOrderUpBusiService;
    @Autowired
    private ChangeAppOrderDownBusiService changeAppOrderDownBusiService;
    @Autowired
    private DeleteApplicationBusiServcie deleteApplicationBusiServcie;
    @Autowired
    private InsertGraySwitchService insertGraySwitchService;
    @Autowired
    private UpdateGraySwitchByAppIdBusiService updateGraySwitchByAppIdBusiService;
    @Autowired
    private DeleteGrayByAppIdBusiService deleteGrayByAppIdBusiService;
    @Autowired
    private SelectAppforUserHaveService selectAppforUserHaveService;

    @RequestMapping(value={"/select"})
    @JsonBusiResponseBody
    public Object selectValidApplication() {
        if (UmcMemInfoHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectByValidBusiService.selectByValid();
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3");
    }

    @RequestMapping(value={"/save"})
    @JsonBusiResponseBody
    public Object save(@RequestBody SaveApplicationReqBO saveApplicationReqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)"auth:system:manage")) {
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            saveApplicationReqBO.setApplicationId(Long.valueOf(l));
            Long appId = this.saveApplicationBusiService.saveApplication(saveApplicationReqBO);
            GraySwitchReqBO graySwitchReqBO = new GraySwitchReqBO();
            long l1 = sequence.nextId();
            graySwitchReqBO.setSwitchId(Long.valueOf(l1));
            graySwitchReqBO.setApplyId(appId);
            graySwitchReqBO.setContextPath(saveApplicationReqBO.getContentPath());
            graySwitchReqBO.setGrayDomain(saveApplicationReqBO.getGrayDomain());
            graySwitchReqBO.setStatus(Constants.COMMON_INVALID_STATUS);
            graySwitchReqBO.setOperater(UmcMemInfoHelper.getCurrentUser().getUserId());
            graySwitchReqBO.setOperatingTime(new Date());
            this.insertGraySwitchService.InsertGraySwitchService(graySwitchReqBO);
            return null;
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/list"})
    @JsonBusiResponseBody
    public Object selectApplicationPage() {
        if (UmcMemInfoHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectAllApplicationsBusiService.selectAllApplys();
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/update"})
    @JsonBusiResponseBody
    public Object update(@RequestBody UpdateApplicationByRecReqBO updateApplicationByRecReqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)"auth:system:manage")) {
            SelectApplicationByIdReqBO reqBO = new SelectApplicationByIdReqBO();
            reqBO.setApplicationId(updateApplicationByRecReqBO.getApplicationId());
            SelectApplicationByIdRspBO rspBO = this.selectApplicationByIdBusiService.selectApplicationById(reqBO);
            this.updateApplicationByRecBusiService.updateApplicationByRecord(updateApplicationByRecReqBO);
            GraySwitchReqBO graySwitchReqBO = new GraySwitchReqBO();
            graySwitchReqBO.setApplyId(updateApplicationByRecReqBO.getApplicationId());
            graySwitchReqBO.setContextPath(updateApplicationByRecReqBO.getContentPath());
            graySwitchReqBO.setGrayDomain(updateApplicationByRecReqBO.getGrayDomain());
            graySwitchReqBO.setOperater(UmcMemInfoHelper.getCurrentUser().getUserId());
            graySwitchReqBO.setOperatingTime(new Date());
            this.updateGraySwitchByAppIdBusiService.updateGarySwitch(graySwitchReqBO);
            return null;
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/selectById"})
    @JsonBusiResponseBody
    public Object selectById(@RequestBody SelectApplicationByIdReqBO selectApplicationByIdReqBO) {
        return this.selectApplicationByIdBusiService.selectApplicationById(selectApplicationByIdReqBO);
    }

    @RequestMapping(value={"/selectByUser"})
    @JsonBusiResponseBody
    public Object selectByUser(@RequestBody SelectApplicationByUserReqBO applicationByUserReqBO) {
        UmcMemInfoBO currentUser = UmcMemInfoHelper.getCurrentUser();
        if (currentUser != null && currentUser.getTenantId() == null && !UmcMemInfoHelper.hasAuthority((String)"auth:system:manage") && !UmcMemInfoHelper.hasAuthority((String)"auth:overall:manage")) {
            return null;
        }
        return this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
    }

    @RequestMapping(value={"/selectforUserHave"})
    @JsonBusiResponseBody
    public Object selectforUserHave(@RequestBody SelectAppforUserHaveReqBO selectAppforUserHaveReqBO) {
        UmcMemInfoBO currentUser = UmcMemInfoHelper.getCurrentUser();
        if (currentUser != null && currentUser.getTenantId() == null && !UmcMemInfoHelper.hasAuthority((String)"auth:system:manage") && !UmcMemInfoHelper.hasAuthority((String)"auth:overall:manage")) {
            return null;
        }
        Map menus = UmcMemInfoHelper.getCurrentUser().getMenus();
        LinkedList<String> appCode = new LinkedList<String>();
        for (String key : menus.keySet()) {
            appCode.add(key);
        }
        selectAppforUserHaveReqBO.setAppCodeList(appCode);
        return this.selectAppforUserHaveService.selectAppforUser(selectAppforUserHaveReqBO);
    }

    @RequestMapping(value={"/delete"})
    @JsonBusiResponseBody
    public Object delete(@RequestBody DeleteApplicationReqBO deleteApplicationReqBO) {
        UpdateApplicationByRecReqBO update = new UpdateApplicationByRecReqBO();
        update.setApplicationId(deleteApplicationReqBO.getApplicationId());
        update.setIsDel(Constants.COMMON_INVALID_STATUS);
        this.updateApplicationByRecBusiService.updateApplicationByRecord(update);
        return null;
    }

    @RequestMapping(value={"/selectByCode"})
    @JsonBusiResponseBody
    public Object selectById(@RequestBody SelectByApplicationCodeReqBO selectByApplicationCodeReqBO) {
        return this.selectByApplicationCodeBusiService.selectByApplicationCode(selectByApplicationCodeReqBO);
    }

    @RequestMapping(value={"/reOpen"})
    @JsonBusiResponseBody
    public Object reOpen(@RequestBody DeleteApplicationReqBO deleteApplicationReqBO) {
        UpdateApplicationByRecReqBO update = new UpdateApplicationByRecReqBO();
        update.setApplicationId(deleteApplicationReqBO.getApplicationId());
        update.setIsDel(Constants.COMMON_VALID_STATUS);
        this.updateApplicationByRecBusiService.updateApplicationByRecord(update);
        return null;
    }

    @RequestMapping(value={"/up"})
    @JsonBusiResponseBody
    public Object up(@RequestBody ChangeAppOrderReqBO changeAppOrderReqBO) {
        this.changeAppOrderUpBusiService.changeAppOrderUp(changeAppOrderReqBO);
        return null;
    }

    @RequestMapping(value={"/down"})
    @JsonBusiResponseBody
    public Object down(@RequestBody ChangeAppOrderReqBO changeAppOrderReqBO) {
        this.changeAppOrderDownBusiService.changeAppOrderDown(changeAppOrderReqBO);
        return null;
    }

    @RequestMapping(value={"phyDel"})
    @JsonBusiResponseBody
    public Object phyDel(@RequestBody DeleteApplicationReqBO deleteApplicationReqBO) {
        try {
            SelectApplicationByIdReqBO reqBO = new SelectApplicationByIdReqBO();
            reqBO.setApplicationId(deleteApplicationReqBO.getApplicationId());
            SelectApplicationByIdRspBO selectApplicationByIdRspBO = this.selectApplicationByIdBusiService.selectApplicationById(reqBO);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u5b50\u7cfb\u7edf", (Throwable)e);
        }
        this.deleteApplicationBusiServcie.deleteApplication(deleteApplicationReqBO);
        DeleteGrayByAppIdReqBO deleteGrayByAppIdReqBO = new DeleteGrayByAppIdReqBO();
        deleteGrayByAppIdReqBO.setApplicationId(deleteApplicationReqBO.getApplicationId());
        this.deleteGrayByAppIdBusiService.deleteGrayByAppId(deleteGrayByAppIdReqBO);
        return null;
    }
}

