/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.authority.controller.districts;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.districts.bo.RegionNameListReqBO;
import com.ohaotian.authority.districts.bo.SelectDistrictByIdReqBO;
import com.ohaotian.authority.districts.bo.SelectDistrictByIdRspBO;
import com.ohaotian.authority.districts.bo.SysAreaReqBO;
import com.ohaotian.authority.districts.service.AddDistrictsService;
import com.ohaotian.authority.districts.service.DeleteDistrictsService;
import com.ohaotian.authority.districts.service.SelectDistrictByIdService;
import com.ohaotian.authority.districts.service.SelectDistrictsService;
import com.ohaotian.authority.districts.service.SelectRegionNameListService;
import com.ohaotian.authority.districts.service.UpdateDistrictsService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.pesapp.common.JsonBusiResponseBody;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/author/districts"}, method={RequestMethod.GET, RequestMethod.POST})
public class DistrictsController {
    private static final Logger logger = LoggerFactory.getLogger(DistrictsController.class);
    @Autowired
    private SelectDistrictsService selectDistrictsService;
    @Autowired
    private AddDistrictsService addDistrictsService;
    @Autowired
    private UpdateDistrictsService updateDistrictsService;
    @Autowired
    private DeleteDistrictsService deleteDistrictsService;
    @Autowired
    private SelectRegionNameListService selectRegionNameListService;
    @Autowired
    private SelectDistrictByIdService selectDistrictByIdService;

    @RequestMapping(value={"/search"})
    @JsonBusiResponseBody
    public Object search(@RequestBody SysAreaReqBO sysAreaReqBO) {
        logger.debug("......" + sysAreaReqBO);
        return this.selectDistrictsService.findPage(sysAreaReqBO);
    }

    @RequestMapping(value={"/add"})
    @JsonBusiResponseBody
    public Object add(@RequestBody SysAreaReqBO sysAreaReqBO) {
        this.addDistrictsService.insert(sysAreaReqBO);
        return null;
    }

    @RequestMapping(value={"/update"})
    @JsonBusiResponseBody
    public Object update(@RequestBody SysAreaReqBO sysAreaReqBO) {
        try {
            SelectDistrictByIdReqBO reqBO = new SelectDistrictByIdReqBO();
            reqBO.setId(sysAreaReqBO.getId());
            SelectDistrictByIdRspBO selectDistrictByIdRspBO = this.selectDistrictByIdService.selectDistrict(reqBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91", (Throwable)e);
        }
        this.updateDistrictsService.update(sysAreaReqBO);
        return null;
    }

    @RequestMapping(value={"/delete"})
    @JsonBusiResponseBody
    public Object delete(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            throw new ZTBusinessException("\u5165\u53c2\u884c\u653f\u533a\u5212ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List integers = JSON.parseArray((String)ids, Integer.class);
        this.deleteDistrictsService.delete(integers);
        return null;
    }

    @RequestMapping(value={"/qryRegNameByParent"})
    @JsonBusiResponseBody
    public Object qryRegNameByParent(@RequestBody RegionNameListReqBO reqBO) {
        return this.selectRegionNameListService.selectRegNameList(reqBO);
    }

    @RequestMapping(value={"/selectById"})
    @JsonBusiResponseBody
    public Object selectById(@RequestBody SelectDistrictByIdReqBO selectDistrictByIdReqBO) {
        return this.selectDistrictByIdService.selectDistrict(selectDistrictByIdReqBO);
    }
}

