/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.authority.controller.tenant;

import com.ohaotian.authority.tenant.bo.AppConfigBO;
import com.ohaotian.authority.tenant.bo.CreateTenantBO;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantReqBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.bo.TenantSearchPageReqBO;
import com.ohaotian.authority.tenant.service.CreateAppFroTenantService;
import com.ohaotian.authority.tenant.service.CreateTenantService;
import com.ohaotian.authority.tenant.service.DeleteTenantByIdService;
import com.ohaotian.authority.tenant.service.SelectAppForTenantService;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.tenant.service.SelectTenantPageService;
import com.ohaotian.authority.tenant.service.StopTenantByTenantIdService;
import com.ohaotian.authority.tenant.service.UpdateTenantByTenantIdService;
import com.ohaotian.authority.user.bo.SelectTenantListByUserIdReqBO;
import com.ohaotian.authority.user.service.SelectTenantListByUserIdService;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pesapp.common.JsonBusiResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/author/tenant"}, method={RequestMethod.GET, RequestMethod.POST})
public class TenantController {
    private static final Logger logger = LoggerFactory.getLogger(TenantController.class);
    @Autowired
    private CreateTenantService createTenantService;
    @Autowired
    private SelectTenantPageService selectTenantPageService;
    @Autowired
    private DeleteTenantByIdService deleteTenantByIdService;
    @Autowired
    private SelectTenantByIdService selectTenantByIdService;
    @Autowired
    private UpdateTenantByTenantIdService updateTenantByTenantIdService;
    @Autowired
    private CreateAppFroTenantService createAppFroTenantService;
    @Autowired
    private SelectAppForTenantService selectAppForTenantService;
    @Autowired
    private SelectTenantListByUserIdService selectTenantListByUserIdService;
    @Autowired
    private StopTenantByTenantIdService stopTenantByTenantIdService;

    @RequestMapping(value={"/create"})
    @JsonBusiResponseBody
    public Object create(@RequestBody CreateTenantBO createTenantBO) {
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        createTenantBO.setTenantId(Long.valueOf(l));
        this.createTenantService.insertTenant(createTenantBO);
        return null;
    }

    @RequestMapping(value={"/search"})
    @JsonBusiResponseBody
    public Object search(@RequestBody TenantSearchPageReqBO tenantSearchPageReqBO) {
        return this.selectTenantPageService.selectTenantPage(tenantSearchPageReqBO);
    }

    @RequestMapping(value={"/delete"})
    @JsonBusiResponseBody
    public Object delete(@RequestBody TenantIdBO tenantId) {
        try {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(tenantId.getTenantId());
            TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u79df\u6237", (Throwable)e);
        }
        this.deleteTenantByIdService.deleteTenantById(tenantId);
        return null;
    }

    @RequestMapping(value={"/select"})
    @JsonBusiResponseBody
    public Object select(@RequestBody TenantIdBO tenantIdBO) {
        return this.selectTenantByIdService.selectTenantById(tenantIdBO);
    }

    @RequestMapping(value={"/add"})
    @JsonBusiResponseBody
    public Object add(@RequestBody TenantReqBO tenantReqBO) {
        try {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(tenantReqBO.getTenantId());
            TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u79df\u6237", (Throwable)e);
        }
        this.updateTenantByTenantIdService.updateTenantByTenantId(tenantReqBO);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @JsonBusiResponseBody
    public Object stop(@RequestBody TenantIdBO tenantId) {
        TenantReqBO tenantReqBO = new TenantReqBO();
        tenantReqBO.setTenantId(tenantId.getTenantId());
        tenantReqBO.setStatus(Integer.valueOf(2));
        this.stopTenantByTenantIdService.stopTenantByTenantId(tenantReqBO);
        return null;
    }

    @RequestMapping(value={"/restart"})
    @JsonBusiResponseBody
    public Object restart(@RequestBody TenantIdBO tenantId) {
        TenantReqBO tenantReqBO = new TenantReqBO();
        tenantReqBO.setTenantId(tenantId.getTenantId());
        tenantReqBO.setStatus(Integer.valueOf(0));
        this.updateTenantByTenantIdService.updateTenantByTenantId(tenantReqBO);
        return null;
    }

    @RequestMapping(value={"/configApp"})
    @JsonBusiResponseBody
    public Object configApp(@RequestBody AppConfigBO appConfigForTenantReqBO) {
        this.createAppFroTenantService.createAppforTenant(appConfigForTenantReqBO);
        return null;
    }

    @RequestMapping(value={"/selectconfigApp"})
    @JsonBusiResponseBody
    public Object selectconfigApp(@RequestBody TenantIdBO tenantIdBO) {
        return this.selectAppForTenantService.selectAppforTenant(tenantIdBO);
    }

    @RequestMapping(value={"/selectUserTenant"})
    @JsonBusiResponseBody
    public Object selectUserTenant(@RequestParam(value="userId") String userId, SelectTenantListByUserIdReqBO selectTenantListByUserIdReqBO) {
        return this.selectTenantListByUserIdService.selectTenants(selectTenantListByUserIdReqBO);
    }
}

