/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesRspBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectUserAlreadyStationsRspBO;
import com.ohaotian.authority.user.bo.UserAuthReqBO;
import com.ohaotian.authority.user.service.SelectUserAlreadyAuthRolesService;
import com.ohaotian.authority.user.service.SelectUserAlreadyAuthStationsService;
import com.tydic.pesapp.common.JsonBusiResponseBody;
import com.tydic.pesapp.common.ability.OperatorUmcResetPasswordAbilityService;
import com.tydic.pesapp.common.ability.OperatorUmcSaveUserAuthAbilityService;
import com.tydic.pesapp.common.ability.OperatorUmcSelectUserRolesAbilityService;
import com.tydic.pesapp.common.ability.bo.OperatorUmcResetPasswordAbilityReqBO;
import com.tydic.pesapp.common.ability.bo.OperatorUmcSaveUserAuthAbilityReqBO;
import com.tydic.pesapp.common.ability.bo.OperatorUmcSelectUserRolesAbilityReqBO;
import com.tydic.pesapp.common.ability.bo.OperatorUmcSelectUserRolesAbilityRspBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/umc/authority/user"})
public class OperatorUmcAuthorityUserController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorUmcAuthorityUserController.class);
    @Autowired
    private OperatorUmcResetPasswordAbilityService operatorUmcResetPasswordAbilityService;
    @Autowired
    private OperatorUmcSelectUserRolesAbilityService operatorUmcSelectUserRolesAbilityService;
    @Autowired
    private OperatorUmcSaveUserAuthAbilityService operatorUmcSaveUserAuthAbilityService;
    @Autowired
    private SelectUserAlreadyAuthRolesService selectUserAlreadyAuthRolesService;
    @Autowired
    private SelectUserAlreadyAuthStationsService selectUserAlreadyAuthStationsService;

    @PostMapping(value={"/reset"})
    @JsonBusiResponseBody
    public Map<String, String> resetPasswordByUserId(@RequestBody OperatorUmcResetPasswordAbilityReqBO reqBo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5bc6\u7801\u91cd\u7f6e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        return this.operatorUmcResetPasswordAbilityService.resetPasswordByUserId(reqBo);
    }

    @PostMapping(value={"/authUser"})
    @JsonBusiResponseBody
    public OperatorUmcSelectUserRolesAbilityRspBO selectUserRoles(@RequestBody OperatorUmcSelectUserRolesAbilityReqBO reqBo) {
        if (UmcMemInfoHelper.hasAuthority((String)"auth:org:manage")) {
            reqBo.setHasAuthority(Boolean.valueOf(true));
        } else {
            reqBo.setHasAuthority(Boolean.valueOf(false));
        }
        return this.operatorUmcSelectUserRolesAbilityService.selectUserRoles(reqBo);
    }

    @PostMapping(value={"/authUserCommit"})
    @JsonBusiResponseBody
    public Map<String, String> saveUserAuthService(@RequestBody OperatorUmcSaveUserAuthAbilityReqBO reqBo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u7ed9\u7528\u6237\u6388\u6743\u63d0\u4ea4\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        return this.operatorUmcSaveUserAuthAbilityService.saveUserAuthService(reqBo);
    }

    @RequestMapping(value={"/authUserAlreadyRolesAndStations"})
    @JsonBusiResponseBody
    public Object authUserAlreadyRolesAndStations(@RequestBody UserAuthReqBO userAuthReqBO) {
        SelectOrgAlreadyRolesRspBO selectOrgAlreadyRolesRspBO = this.selectUserAlreadyAuthRolesService.selectOrgAlreadyRoles(userAuthReqBO);
        List hasGrantRoles = selectOrgAlreadyRolesRspBO.getHasGrantRoles();
        SelectUserAlreadyStationsRspBO selectUserAlreadyStationsRspBO = this.selectUserAlreadyAuthStationsService.selectUserAlreadyStations(userAuthReqBO);
        List hasGrantStations = selectUserAlreadyStationsRspBO.getHasGrantStations();
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasGrantRoles);
        orgDistributeRspBO.setHasGrantStations(hasGrantStations);
        return orgDistributeRspBO;
    }
}

