/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.selfrun.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.pesapp.selfrun.ability.CnncSelfrunBatchImportGoodsService;
import com.tydic.pesapp.selfrun.ability.bo.CnncExcelCommodityAttrButesBO;
import com.tydic.pesapp.selfrun.ability.bo.CnncExcelCommodityBO;
import com.tydic.pesapp.selfrun.ability.bo.CnncExcelSkuBO;
import com.tydic.pesapp.selfrun.ability.bo.CnncSelfrunBatchImportGoodsReqBO;
import com.tydic.pesapp.selfrun.ability.bo.CnncSelfrunBatchImportGoodsRspBO;
import com.tydic.pesapp.selfrun.ability.constant.ExcelUtils;
import com.tydic.uccext.bo.CnncCreateCommdityBo;
import com.tydic.uccext.bo.CnncExtSalesAttributesBo;
import com.tydic.uccext.bo.UccCommodityImportAbilityReqBO;
import com.tydic.uccext.bo.UccCommodityImportAbilityRspBO;
import com.tydic.uccext.service.UccCommodityImportAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"self-run_DEV_GROUP/1.0.0/com.tydic.pesapp.selfrun.ability.CnncSelfrunBatchImportGoodsService"})
public class CnncSelfrunBatchImportGoodsServiceImpl
implements CnncSelfrunBatchImportGoodsService {
    private static final Logger log = LoggerFactory.getLogger(CnncSelfrunBatchImportGoodsServiceImpl.class);
    private static final int startReadLineSheet0 = 9;
    private static final int startReadLineSheet1 = 6;
    @Autowired
    private UccCommodityImportAbilityService uccCommodityImportAbilityService;

    @PostMapping(value={"batchImportGoods"})
    public CnncSelfrunBatchImportGoodsRspBO batchImportGoods(@RequestBody CnncSelfrunBatchImportGoodsReqBO reqBO) {
        CnncSelfrunBatchImportGoodsRspBO rspBO = new CnncSelfrunBatchImportGoodsRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getImportUrl())) {
            throw new ZTBusinessException("url\u4e3a\u7a7a");
        }
        String url = reqBO.getImportUrl();
        List<CnncExcelCommodityBO> commodityBOList = this.getCommodityBOList(url);
        List<CnncExcelSkuBO> skuBOList = this.getSkuBOList(url);
        ArrayList<CnncCreateCommdityBo> cnncCreateCommdityBos = new ArrayList<CnncCreateCommdityBo>();
        for (CnncExcelCommodityBO cnncExcelCommodityBO : commodityBOList) {
            Long id = cnncExcelCommodityBO.getId();
            String commodityJsonString = JSONObject.toJSONString((Object)cnncExcelCommodityBO);
            CnncCreateCommdityBo cnncCreateCommdityBo = (CnncCreateCommdityBo)JSONObject.parseObject((String)commodityJsonString, CnncCreateCommdityBo.class);
            List cnncExcelSkuBOList = skuBOList.stream().filter(s -> s.getId().equals(id)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(cnncExcelSkuBOList)) {
                String skuJsonString = JSONArray.toJSONString(cnncExcelSkuBOList);
                List cnncExtSalesAttributesBos = JSONArray.parseArray((String)skuJsonString, CnncExtSalesAttributesBo.class);
                cnncCreateCommdityBo.setSalesAttrs(cnncExtSalesAttributesBos);
            }
            cnncCreateCommdityBos.add(cnncCreateCommdityBo);
        }
        UccCommodityImportAbilityReqBO uccCommodityImportAbilityReqBO = new UccCommodityImportAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccCommodityImportAbilityReqBO);
        uccCommodityImportAbilityReqBO.setCnncCreateCommdityBos(cnncCreateCommdityBos);
        UccCommodityImportAbilityRspBO uccCommodityImportAbilityRspBO = this.uccCommodityImportAbilityService.dealCommodityImport(uccCommodityImportAbilityReqBO);
        if ("0000".equals(uccCommodityImportAbilityRspBO.getRespCode())) {
            rspBO.setCode("0000");
            rspBO.setMessage("\u6210\u529f");
            rspBO.setFailMessage(uccCommodityImportAbilityRspBO.getFailMessage());
            return rspBO;
        }
        throw new ZTBusinessException("\u63d2\u5165\u5931\u8d25");
    }

    private List<CnncExcelCommodityBO> getCommodityBOList(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 8, 0);
            head = excel.get(0);
            data = this.dealEcxel(url, 9, 0);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 8;
        ArrayList<CnncExcelCommodityBO> cnncExcelCommodityBOList = new ArrayList<CnncExcelCommodityBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    CnncExcelCommodityBO cnncExcelCommodityBO = new CnncExcelCommodityBO();
                    int i = 0;
                    String id = (String)list.get(i++);
                    cnncExcelCommodityBO.setId(Long.valueOf(id));
                    String commodityTypeName = (String)list.get(i++);
                    cnncExcelCommodityBO.setCommodityTypeName(commodityTypeName);
                    String commodityName = (String)list.get(i++);
                    cnncExcelCommodityBO.setCommodityName(commodityName);
                    String commodityBanner = (String)list.get(i++);
                    cnncExcelCommodityBO.setCommodityBanner(commodityBanner);
                    String commodityLinkChar = (String)list.get(i++);
                    cnncExcelCommodityBO.setCommodityLinkChar(commodityLinkChar);
                    String commodityLinkUrl = (String)list.get(i++);
                    cnncExcelCommodityBO.setCommodityLinkUrl(commodityLinkUrl);
                    String upcCode = (String)list.get(i++);
                    cnncExcelCommodityBO.setUpcCode(upcCode);
                    String brandId = (String)list.get(i++);
                    cnncExcelCommodityBO.setBrandId(Long.valueOf(brandId));
                    String servenRejectAllow = (String)list.get(i++);
                    cnncExcelCommodityBO.setServenRejectAllow(Integer.valueOf(servenRejectAllow));
                    String commodityPcDetailChar = (String)list.get(i++);
                    cnncExcelCommodityBO.setCommodityPcDetailChar(commodityPcDetailChar);
                    String packParam = (String)list.get(i++);
                    cnncExcelCommodityBO.setPackParam(packParam);
                    String afterService = (String)list.get(i++);
                    cnncExcelCommodityBO.setAfterService(afterService);
                    String poolIds = (String)list.get(i++);
                    if (!StringUtils.isEmpty((Object)poolIds) && poolIds.contains(",")) {
                        String[] split = poolIds.split(",");
                        ArrayList<Long> poolIdList = new ArrayList<Long>();
                        for (String str : split) {
                            poolIdList.add(Long.valueOf(str));
                        }
                        cnncExcelCommodityBO.setPoolIds(poolIdList);
                    }
                    ArrayList<CnncExcelCommodityAttrButesBO> commodityAttrButesBOS = new ArrayList<CnncExcelCommodityAttrButesBO>();
                    while (true) {
                        String propValue = (String)list.get(i++);
                        String propName = head.get(i++);
                        if (StringUtils.isEmpty((Object)propValue) || StringUtils.isEmpty((Object)propName)) break;
                        CnncExcelCommodityAttrButesBO commodityAttrButesBO = new CnncExcelCommodityAttrButesBO();
                        commodityAttrButesBO.setPropName(propName);
                        commodityAttrButesBO.setPropValue(propValue);
                        commodityAttrButesBOS.add(commodityAttrButesBO);
                    }
                    cnncExcelCommodityBO.setCommdAttrGroups(commodityAttrButesBOS);
                    cnncExcelCommodityBOList.add(cnncExcelCommodityBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return cnncExcelCommodityBOList;
    }

    private List<CnncExcelSkuBO> getSkuBOList(String url) {
        List<Object> data = new ArrayList();
        List<String> head = null;
        try {
            List<List<String>> excel = this.dealEcxel(url, 5, 1);
            head = excel.get(0);
            data = this.dealEcxel(url, 6, 1);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        int rowNum = 5;
        ArrayList<CnncExcelSkuBO> cnncExcelSkuBOList = new ArrayList<CnncExcelSkuBO>();
        try {
            if (CollectionUtils.isNotEmpty(data)) {
                for (List list : data) {
                    ++rowNum;
                    CnncExcelSkuBO cnncExcelSkuBO = new CnncExcelSkuBO();
                    int i = 0;
                    String id = (String)list.get(i++);
                    cnncExcelSkuBO.setId(Long.valueOf(id));
                    String materialId = (String)list.get(i++);
                    cnncExcelSkuBO.setMaterialId(materialId);
                    String materialName = (String)list.get(i++);
                    cnncExcelSkuBO.setMaterialName(materialName);
                    String longDesc = (String)list.get(i++);
                    String taxRate = (String)list.get(i++);
                    cnncExcelSkuBO.setTaxRate(new BigDecimal(taxRate));
                    String taxCode = (String)list.get(i++);
                    cnncExcelSkuBO.setTaxCode(taxCode);
                    String marketPrice = (String)list.get(i++);
                    cnncExcelSkuBO.setMarketPrice(Long.valueOf(Long.parseLong(marketPrice) * 10000L));
                    String agreementPrice = (String)list.get(i++);
                    cnncExcelSkuBO.setAgreementPrice(Long.valueOf(Long.parseLong(agreementPrice) * 10000L));
                    String salePrice = (String)list.get(i++);
                    cnncExcelSkuBO.setSalePrice(Long.valueOf(Long.parseLong(salePrice) * 10000L));
                    String measureId = (String)list.get(i++);
                    cnncExcelSkuBO.setMeasureId(Long.valueOf(measureId));
                    ArrayList<CnncExcelCommodityAttrButesBO> skuAttrGroups = new ArrayList<CnncExcelCommodityAttrButesBO>();
                    while (true) {
                        String propValue = (String)list.get(i++);
                        String propName = head.get(i++);
                        if (StringUtils.isEmpty((Object)propValue) || StringUtils.isEmpty((Object)propName)) break;
                        CnncExcelCommodityAttrButesBO skuAttrGroup = new CnncExcelCommodityAttrButesBO();
                        skuAttrGroup.setPropName(propName);
                        skuAttrGroup.setPropValue(propValue);
                        skuAttrGroups.add(skuAttrGroup);
                    }
                    cnncExcelSkuBO.setSkuAttrGroups(skuAttrGroups);
                    cnncExcelSkuBOList.add(cnncExcelSkuBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u7b2c" + rowNum + "\u884c\u6570\u636e\u51fa\u73b0\u95ee\u9898,\u8bf7\u68c0\u67e5\u683c\u5f0f!");
        }
        return cnncExcelSkuBOList;
    }

    private List<List<String>> dealEcxel(String url, Integer startReadLine, Integer sheetAt) {
        if (StringUtils.isEmpty((Object)url)) {
            return new ArrayList<List<String>>();
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            ExcelUtils.getExcelDate(url, lines, startReadLine, sheetAt);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u5904\u7406Excel\u5931\u8d25");
        }
        log.info("\u8bfb\u53d6\u5230\u7684\u6570\u636e\uff1a" + JSONObject.toJSONString(lines));
        return lines;
    }
}

