/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.wx.refund;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.wx.refund.bo.PayStandardWxRefundRspBo;
import com.tydic.payment.pay.wx.req.bo.WXApiRefundReqBO;
import com.tydic.payment.pay.wx.util.HttpsRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import sun.misc.BASE64Decoder;

@Controller
@RequestMapping(value={"/pay"})
public class PayStandardWxRefundController {
    private final Logger LOG = LoggerFactory.getLogger(PayStandardWxRefundController.class);
    private static final String WX_REFUND_URL = "https://api.mch.weixin.qq.com/secapi/pay/refund";
    private static final String FAILUR = "8888";
    private static final String SUCCESS = "0000";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/proxyWxRefund"})
    @ResponseBody
    public PayStandardWxRefundRspBo proxyWxRefund(String fileBase64Str, String certPassword, WXApiRefundReqBO refundReqData, String realSignStr) {
        this.LOG.info("\u5fae\u4fe1\u9000\u6b3e\u8fdc\u7a0b\u8c03\u7528\u5165\u53c2\uff1a" + JSON.toJSONString((Object)refundReqData));
        this.LOG.info("certPassword\uff1a" + certPassword);
        this.LOG.info("fileMd5Str\uff1a" + fileBase64Str);
        this.LOG.info("realSignStr\uff1a" + realSignStr);
        PayStandardWxRefundRspBo retBo = new PayStandardWxRefundRspBo();
        String validateArgStr = this.validateArg(fileBase64Str, certPassword, refundReqData, realSignStr);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode(FAILUR);
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        refundReqData.setSign(realSignStr);
        String certPath = "";
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            String originalFilename = df.format(new Date()) + ".p12";
            String sepa = File.separator;
            String tempDir = System.getProperty("java.io.tmpdir");
            certPath = tempDir + sepa + "wxRefundFile" + sepa + originalFilename;
            System.out.println("\u9000\u6b3e\u6587\u4ef6\u4fdd\u5b58\u5728\uff1a" + certPath);
            this.isExists(certPath);
            byte[] buffer = new BASE64Decoder().decodeBuffer(fileBase64Str);
            FileOutputStream out = new FileOutputStream(certPath);
            out.write(buffer);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            retBo.setRespCode(FAILUR);
            retBo.setRespDesc("\u4fdd\u5b58\u6587\u4ef6\u5f02\u5e38\uff1a" + e);
            return retBo;
        }
        HttpsRequest httpsRequest = null;
        String resultString = "";
        try {
            httpsRequest = new HttpsRequest(certPath, certPassword);
            resultString = httpsRequest.sendPostPayPro(WX_REFUND_URL, (Object)refundReqData);
        }
        catch (Exception e) {
            System.out.println("\u8c03\u7528\u5fae\u4fe1\u9000\u6b3e\u5f02\u5e38\uff1a" + e);
            e.printStackTrace();
        }
        finally {
            this.isExists(certPath);
        }
        retBo.setRespDesc("\u8c03\u7528\u6210\u529f");
        retBo.setRespCode(SUCCESS);
        retBo.setResultStr(resultString);
        return retBo;
    }

    private String validateArg(String fileBase64Str, String certPassword, WXApiRefundReqBO refundReqData, String realSignStr) {
        if (StringUtils.isEmpty((Object)fileBase64Str)) {
            return "\u5165\u53c2fileMd5Str\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)certPassword)) {
            return "\u5165\u53c2certPassword\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)refundReqData)) {
            return "\u5165\u53c2\u5bf9\u8c61refundReqData\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)realSignStr)) {
            return "\u5165\u53c2realSignStr\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public void isExists(String certPath) {
        File savedFile = new File(certPath);
        if (savedFile.exists()) {
            savedFile.delete();
        } else if (!savedFile.getParentFile().exists()) {
            savedFile.getParentFile().mkdirs();
        }
    }
}

