/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.coc.atom.impl;

import com.tydic.coc.atom.CocGetObjIdAtomService;
import com.tydic.coc.atom.bo.CocGetObjIdReqBO;
import com.tydic.coc.atom.bo.CocGetObjIdRspBO;
import com.tydic.coc.constant.CocCommConstant;
import com.tydic.coc.dao.ServOrderMapper;
import com.tydic.coc.po.ServOrderPO;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cocGetObjIdAtomService")
public class CocGetObjIdAtomServiceImpl
implements CocGetObjIdAtomService {
    @Autowired
    private ServOrderMapper servOrderMapper;

    @Override
    public CocGetObjIdRspBO getObjId(CocGetObjIdReqBO req) {
        CocGetObjIdRspBO rsp = new CocGetObjIdRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u83b7\u53d6\u5355\u636e\u53f7\u6210\u529f");
        Integer objType = req.getObjType();
        Long orderId = req.getOrderId();
        if (CocCommConstant.OBJ_TYPE.ORDER.equals(objType)) {
            rsp.setObjIdList(Arrays.asList(orderId));
        } else if (CocCommConstant.OBJ_TYPE.COC.equals(objType)) {
            ServOrderPO servOrderPO = new ServOrderPO();
            servOrderPO.setOrderId(orderId);
            List<ServOrderPO> list = this.servOrderMapper.getList(servOrderPO);
            if (CollectionUtils.isNotEmpty(list)) {
                rsp.setObjIdList(list.stream().map(ServOrderPO::getServOrderId).collect(Collectors.toList()));
            }
        } else {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u4e0d\u652f\u6301\u7684objType\u3010" + objType + "\u3011\u7c7b\u578b");
        }
        return rsp;
    }
}

