/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.coc.atom.impl;

import com.tydic.coc.atom.CocChgVoucherStateAtomService;
import com.tydic.coc.atom.CocGetObjIdAtomService;
import com.tydic.coc.atom.CocTacheStateUpdateAtomService;
import com.tydic.coc.atom.bo.CocChgVoucherStateReqBO;
import com.tydic.coc.atom.bo.CocChgVoucherStateRspBO;
import com.tydic.coc.atom.bo.CocGetObjIdReqBO;
import com.tydic.coc.atom.bo.CocGetObjIdRspBO;
import com.tydic.coc.atom.bo.CocTacheStateUpdateReqBO;
import com.tydic.coc.atom.bo.CocTacheStateUpdateRspBO;
import com.tydic.coc.bo.VoucherStateBO;
import com.tydic.coc.constant.StateTypeCode;
import com.tydic.orderbase.dao.OrderBaseConfTacheStateMapper;
import com.tydic.orderbase.po.ConfTacheStatePO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cocTacheStateUpdateAtomService")
public class CocTacheStateUpdateAtomServiceImpl
implements CocTacheStateUpdateAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CocTacheStateUpdateAtomServiceImpl.class);
    private OrderBaseConfTacheStateMapper orderBaseConfTacheStateMapper;
    private CocChgVoucherStateAtomService cocChgVoucherStateAtomService;
    private CocGetObjIdAtomService cocGetObjIdAtomService;

    @Autowired
    public CocTacheStateUpdateAtomServiceImpl(OrderBaseConfTacheStateMapper orderBaseConfTacheStateMapper, CocChgVoucherStateAtomService cocChgVoucherStateAtomService, CocGetObjIdAtomService cocGetObjIdAtomService) {
        this.orderBaseConfTacheStateMapper = orderBaseConfTacheStateMapper;
        this.cocChgVoucherStateAtomService = cocChgVoucherStateAtomService;
        this.cocGetObjIdAtomService = cocGetObjIdAtomService;
    }

    @Override
    public CocTacheStateUpdateRspBO dealCoreTacheStateUpdate(CocTacheStateUpdateReqBO atomReqBO) {
        CocTacheStateUpdateRspBO rsp = new CocTacheStateUpdateRspBO();
        ConfTacheStatePO tacheStatePO = new ConfTacheStatePO();
        tacheStatePO.setTacheCode(atomReqBO.getCurTacheCode());
        List confTacheList = this.orderBaseConfTacheStateMapper.getList(tacheStatePO);
        ArrayList<VoucherStateBO> voucherStateList = new ArrayList<VoucherStateBO>();
        if (confTacheList != null && confTacheList.size() > 0) {
            for (ConfTacheStatePO tacheState : confTacheList) {
                Integer orderState = Integer.valueOf(tacheState.getOrdState());
                String stateType = tacheState.getStateType();
                if (StateTypeCode.contains(stateType)) {
                    Integer objType = StateTypeCode.valueOf((String)stateType).objType;
                    CocGetObjIdReqBO cocGetObjIdReqBO = new CocGetObjIdReqBO();
                    cocGetObjIdReqBO.setObjType(objType);
                    cocGetObjIdReqBO.setOrderId(atomReqBO.getOrderId());
                    CocGetObjIdRspBO cocGetObjIdRspBO = this.cocGetObjIdAtomService.getObjId(cocGetObjIdReqBO);
                    if (!"0000".equals(cocGetObjIdRspBO.getRespCode())) continue;
                    for (Long objId : cocGetObjIdRspBO.getObjIdList()) {
                        VoucherStateBO voucherStateBO = new VoucherStateBO();
                        voucherStateBO.setObjId(objId);
                        voucherStateBO.setObjType(objType);
                        voucherStateBO.setAfterState(orderState);
                        voucherStateList.add(voucherStateBO);
                    }
                    continue;
                }
                LOGGER.error("\u66f4\u65b0\u73af\u8282\u72b6\u6001\u539f\u5b50\u670d\u52a1\uff1a\u73af\u8282\u5bf9\u5e94\u72b6\u6001\u8868\u67e5\u8be2\u5230\u672a\u5b9a\u4e49\u7684stateType=" + stateType);
            }
            CocChgVoucherStateReqBO voucherStateAtomReqBO = new CocChgVoucherStateReqBO();
            voucherStateAtomReqBO.setVoucherStateList(voucherStateList);
            voucherStateAtomReqBO.setOperId(atomReqBO.getOperId());
            voucherStateAtomReqBO.setOrderId(atomReqBO.getOrderId());
            voucherStateAtomReqBO.setDealDesc(atomReqBO.getDealDesc());
            CocChgVoucherStateRspBO voucherStateAtomRspBO = this.cocChgVoucherStateAtomService.dealCoreChgVoucherState(voucherStateAtomReqBO);
            if (!"0000".equals(voucherStateAtomRspBO.getRespCode())) {
                rsp.setRespCode(voucherStateAtomRspBO.getRespCode());
                rsp.setRespDesc(voucherStateAtomRspBO.getRespDesc());
                return rsp;
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5f00\u901a\u4e2d\u5fc3\u73af\u8282\u72b6\u6001\u66f4\u65b0\u539f\u5b50\u670d\u52a1\u6210\u529f!");
        return rsp;
    }
}

