/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.coc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.coc.atom.CocBusiOperRecordAtomService;
import com.tydic.coc.atom.CocDealOrderAtomService;
import com.tydic.coc.atom.CocUniCallIntfAtomService;
import com.tydic.coc.atom.bo.CocBusiOperRecordReqBO;
import com.tydic.coc.atom.bo.CocBusiOperRecordRspBO;
import com.tydic.coc.atom.bo.CocDealOrderReqBO;
import com.tydic.coc.atom.bo.CocDealOrderRspBO;
import com.tydic.coc.atom.bo.CocUniCallIntfReqBO;
import com.tydic.coc.atom.bo.CocUniCallIntfRspBO;
import com.tydic.coc.busi.CocCommonFlowBusiService;
import com.tydic.coc.busi.bo.CocCommonFlowReqBO;
import com.tydic.coc.busi.bo.CocCommonFlowRspBO;
import com.tydic.coc.constant.CocCommConstant;
import com.tydic.coc.dao.ConfTacheModMapper;
import com.tydic.coc.dao.TaskRwriteRecMapper;
import com.tydic.coc.po.ConfTacheModPO;
import com.tydic.coc.po.TaskRwriteRecPO;
import com.tydic.orderbase.atom.OrderBaseQryTacheIntfAtomService;
import com.tydic.orderbase.atom.OrderBaseQryTaskInstAtomService;
import com.tydic.orderbase.atom.bo.OrderBaseQryTacheIntfReqBO;
import com.tydic.orderbase.atom.bo.OrderBaseQryTacheIntfRspBO;
import com.tydic.orderbase.atom.bo.OrderBaseQryTaskInstReqBO;
import com.tydic.orderbase.atom.bo.OrderBaseQryTaskInstRspBO;
import com.tydic.orderbase.bo.InterfaceDefBO;
import com.tydic.orderbase.dao.OrderBaseOrderMapper;
import com.tydic.orderbase.po.OrderPO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cocCommonFlowBusiService")
public class CocCommonFlowBusiServiceImpl
implements CocCommonFlowBusiService {
    private OrderBaseOrderMapper orderBaseOrderMapper;
    private ConfTacheModMapper confTacheModMapper;
    private TaskRwriteRecMapper taskRwriteRecMapper;
    private OrderBaseQryTaskInstAtomService orderBaseQryTaskInstAtomService;
    private CocBusiOperRecordAtomService cocBusiOperRecordAtomService;
    private OrderBaseQryTacheIntfAtomService orderBaseQryTacheIntfAtomService;
    private CocUniCallIntfAtomService cocUniCallIntfAtomService;
    private CocDealOrderAtomService cocDealOrderAtomService;

    @Autowired
    public CocCommonFlowBusiServiceImpl(OrderBaseOrderMapper orderBaseOrderMapper, ConfTacheModMapper confTacheModMapper, TaskRwriteRecMapper taskRwriteRecMapper, OrderBaseQryTaskInstAtomService orderBaseQryTaskInstAtomService, CocBusiOperRecordAtomService cocBusiOperRecordAtomService, OrderBaseQryTacheIntfAtomService orderBaseQryTacheIntfAtomService, CocUniCallIntfAtomService cocUniCallIntfAtomService, CocDealOrderAtomService cocDealOrderAtomService) {
        this.orderBaseOrderMapper = orderBaseOrderMapper;
        this.confTacheModMapper = confTacheModMapper;
        this.taskRwriteRecMapper = taskRwriteRecMapper;
        this.orderBaseQryTaskInstAtomService = orderBaseQryTaskInstAtomService;
        this.cocBusiOperRecordAtomService = cocBusiOperRecordAtomService;
        this.orderBaseQryTacheIntfAtomService = orderBaseQryTacheIntfAtomService;
        this.cocUniCallIntfAtomService = cocUniCallIntfAtomService;
        this.cocDealOrderAtomService = cocDealOrderAtomService;
    }

    @Override
    public CocCommonFlowRspBO dealCommonFlow(CocCommonFlowReqBO busiReqBO) {
        CocDealOrderReqBO cocDealOrderReqBO;
        CocDealOrderRspBO cocDealOrderRspBO;
        OrderBaseQryTaskInstReqBO orderBaseQryTaskInstReqBO;
        OrderBaseQryTaskInstRspBO orderBaseQryTaskInstRspBO;
        CocCommonFlowRspBO rsp = new CocCommonFlowRspBO();
        HashMap<String, Object> allWfParamMap = new HashMap<String, Object>(8);
        this.validateParam(busiReqBO);
        if (StringUtils.isBlank((CharSequence)busiReqBO.getDealOperId())) {
            OrderPO orderPO = this.orderBaseOrderMapper.getModelById(busiReqBO.getOrderId().longValue());
            if (null == orderPO) {
                throw new BusinessException("8888", "\u6ca1\u6709\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f");
            }
            busiReqBO.setDealOperId(orderPO.getCreateOperId());
        }
        ConfTacheModPO confTacheModPO = new ConfTacheModPO();
        confTacheModPO.setTacheCode(busiReqBO.getTacheCode());
        confTacheModPO.setModType(CocCommConstant.MOD_TYPE.REBACK_MOD);
        ConfTacheModPO confTacheMod = this.confTacheModMapper.getModelBy(confTacheModPO);
        if (null != confTacheMod && CocCommConstant.IS_NEED_CHECK_YES.equals(confTacheMod.getIsNeedCheck())) {
            TaskRwriteRecPO taskRwriteRecPO = new TaskRwriteRecPO();
            taskRwriteRecPO.setOrderId(busiReqBO.getOrderId());
            taskRwriteRecPO.setTaskId(busiReqBO.getTaskId());
            List<TaskRwriteRecPO> taskRwriteRecPOList = this.taskRwriteRecMapper.getList(taskRwriteRecPO);
            if (null == taskRwriteRecPOList || taskRwriteRecPOList.size() <= 0) {
                throw new BusinessException("8888", "\u8be5\u73af\u5883\u7f16\u7801\u3010" + busiReqBO.getTacheCode() + "\u3011\u5bf9\u5e94\u56de\u586b\u6a21\u7248\u9700\u8981\u6821\u9a8c\uff0c\u4f46\u4efb\u52a1\u56de\u586b\u4fe1\u606f\u8868\u67e5\u8be2\u65e0\u7ed3\u679c\uff01");
            }
        }
        if (!"0000".equals((orderBaseQryTaskInstRspBO = this.orderBaseQryTaskInstAtomService.qryTaskInst(orderBaseQryTaskInstReqBO = this.buildQryTaskInstParm(busiReqBO))).getRespCode())) {
            throw new BusinessException("8888", this.buildExceptionMsg("\u4efb\u52a1\u83b7\u53d6\u670d\u52a1\u5931\u8d25!", orderBaseQryTaskInstRspBO.getRespDesc()));
        }
        if (StringUtils.isNotBlank((CharSequence)busiReqBO.getTacheCode()) && !busiReqBO.getTacheCode().equals(orderBaseQryTaskInstRspBO.getTaskInstBO().getTacheCode())) {
            throw new BusinessException("8888", "\u4f20\u5165\u73af\u8282\u4e0d\u662f\u5f53\u524d\u4efb\u52a1\u73af\u8282");
        }
        if (CocCommConstant.TASK_TYPE.HANDLE_TASK.equals(orderBaseQryTaskInstRspBO.getTaskInstBO().getTaskType())) {
            CocBusiOperRecordReqBO cocBusiOperRecordReqBO = new CocBusiOperRecordReqBO();
            cocBusiOperRecordReqBO.setRecordType(CocCommConstant.BUSI_OPER_RECORD_TYPE.TASK_OPER_RECORD);
            cocBusiOperRecordReqBO.setOrderId(busiReqBO.getOrderId());
            cocBusiOperRecordReqBO.setObjId(busiReqBO.getObjId());
            cocBusiOperRecordReqBO.setObjType(busiReqBO.getObjType());
            cocBusiOperRecordReqBO.setDealOperId(busiReqBO.getDealOperId());
            cocBusiOperRecordReqBO.setDealOperName(busiReqBO.getUserName());
            cocBusiOperRecordReqBO.setDealCompId(busiReqBO.getCompanyId());
            cocBusiOperRecordReqBO.setDealCompName(busiReqBO.getCompanyName());
            cocBusiOperRecordReqBO.setDealDeptId(busiReqBO.getOrgId());
            cocBusiOperRecordReqBO.setDealDeptName(busiReqBO.getOrgName());
            cocBusiOperRecordReqBO.setDealTypeId(busiReqBO.getTacheCode());
            cocBusiOperRecordReqBO.setDealDesc(busiReqBO.getDealDesc());
            CocBusiOperRecordRspBO cocBusiOperRecordRspBO = this.cocBusiOperRecordAtomService.dealBusiOperRecord(cocBusiOperRecordReqBO);
            if (!"0000".equals(cocBusiOperRecordRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u8c03\u7528\u7535\u5546\u901a\u7528\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff01" + cocBusiOperRecordRspBO.getRespDesc());
            }
        }
        OrderBaseQryTacheIntfReqBO orderBaseQryTacheIntfReqBO = new OrderBaseQryTacheIntfReqBO();
        orderBaseQryTacheIntfReqBO.setTacheCode(orderBaseQryTaskInstRspBO.getTaskInstBO().getTacheCode());
        orderBaseQryTacheIntfReqBO.setFlowFlag(Integer.valueOf(1));
        OrderBaseQryTacheIntfRspBO orderBaseQryTacheIntfRspBO = this.orderBaseQryTacheIntfAtomService.qryTacheIntf(orderBaseQryTacheIntfReqBO);
        if (!"0000".equals(orderBaseQryTacheIntfRspBO.getRespCode())) {
            throw new BusinessException("8888", this.buildExceptionMsg("\u63a5\u53e3\u67e5\u8be2\u5931\u8d25!", orderBaseQryTacheIntfRspBO.getRespDesc()));
        }
        List interfaceList = orderBaseQryTacheIntfRspBO.getInterfaceList();
        if (null != interfaceList && interfaceList.size() > 0) {
            for (InterfaceDefBO bo : interfaceList) {
                CocUniCallIntfReqBO cocUniCallIntfReqBO = this.buildUniCallIntf(busiReqBO, bo);
                CocUniCallIntfRspBO cocUniCallIntfRspBO = this.cocUniCallIntfAtomService.dealUniCallIntf(cocUniCallIntfReqBO);
                Integer isAllowException = bo.getIsAllowException();
                if (isAllowException == null) {
                    isAllowException = CocCommConstant.IS_ALLOW_EXCEPTION_YES;
                }
                if (!"0000".equals(cocUniCallIntfRspBO.getRespCode())) {
                    if (isAllowException.intValue() == CocCommConstant.IS_ALLOW_EXCEPTION_YES.intValue()) {
                        rsp.setRespCode(cocUniCallIntfRspBO.getRespCode());
                        rsp.setRespDesc(cocUniCallIntfRspBO.getRespDesc());
                        return rsp;
                    }
                    throw new BusinessException("8888", this.buildExceptionMsg("\u63a5\u53e3\u67e5\u8be2\u5931\u8d25!", cocUniCallIntfRspBO.getRespDesc()));
                }
                Map<String, Object> wfParamMap = cocUniCallIntfRspBO.getWfParamMap();
                if (wfParamMap == null) continue;
                allWfParamMap.putAll(wfParamMap);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)busiReqBO.getExtParamMapJson())) {
            JSONObject extParmMap = JSON.parseObject((String)busiReqBO.getExtParamMapJson());
            allWfParamMap.putAll((Map<String, Object>)extParmMap);
        }
        if (!"0000".equals((cocDealOrderRspBO = this.cocDealOrderAtomService.dealCoreDealOrder(cocDealOrderReqBO = this.buildDealOrderParm(busiReqBO, allWfParamMap, orderBaseQryTaskInstRspBO))).getRespCode())) {
            throw new BusinessException("8888", this.buildExceptionMsg("\u63a5\u53e3\u8c03\u7528\u5931\u8d25", cocDealOrderRspBO.getRespDesc()));
        }
        rsp.setRespDesc("\u5f00\u901a\u4e2d\u5fc3\u901a\u7528\u6d41\u8f6c\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        rsp.setRespCode("0000");
        rsp.setTaskList(cocDealOrderRspBO.getTaskList());
        return rsp;
    }

    private CocDealOrderReqBO buildDealOrderParm(CocCommonFlowReqBO busiReqBO, Map<String, Object> allWfParamMap, OrderBaseQryTaskInstRspBO orderBaseQryTaskInstRspBO) {
        CocDealOrderReqBO cocDealOrderReqBO = new CocDealOrderReqBO();
        cocDealOrderReqBO.setOrderId(busiReqBO.getOrderId());
        if (busiReqBO.getTaskId() == null) {
            cocDealOrderReqBO.setTaskId(orderBaseQryTaskInstRspBO.getTaskInstBO().getTaskId());
        } else {
            cocDealOrderReqBO.setTaskId(busiReqBO.getTaskId());
        }
        cocDealOrderReqBO.setTacheCode(busiReqBO.getTacheCode());
        cocDealOrderReqBO.setCurState(busiReqBO.getOrderState());
        cocDealOrderReqBO.setParamMap(allWfParamMap);
        cocDealOrderReqBO.setDealOperId(busiReqBO.getDealOperId());
        cocDealOrderReqBO.setDealDesc(busiReqBO.getDealDesc());
        return cocDealOrderReqBO;
    }

    private CocUniCallIntfReqBO buildUniCallIntf(CocCommonFlowReqBO busiReqBO, InterfaceDefBO bo) {
        CocUniCallIntfReqBO cocUniCallIntfReqBO = new CocUniCallIntfReqBO();
        cocUniCallIntfReqBO.setObjId(busiReqBO.getObjId());
        cocUniCallIntfReqBO.setObjType(busiReqBO.getObjType());
        cocUniCallIntfReqBO.setOrderId(busiReqBO.getOrderId());
        cocUniCallIntfReqBO.setInterfaceDefBO(bo);
        cocUniCallIntfReqBO.setIntfParamMap((Map<String, Object>)JSON.parseObject((String)busiReqBO.getExtParamMapJson()));
        return cocUniCallIntfReqBO;
    }

    private String buildExceptionMsg(String msg, String desc) {
        StringBuilder builder = new StringBuilder(msg);
        return builder.append(desc).toString();
    }

    private OrderBaseQryTaskInstReqBO buildQryTaskInstParm(CocCommonFlowReqBO busiReqBO) {
        OrderBaseQryTaskInstReqBO orderBaseQryTaskInstReqBO = new OrderBaseQryTaskInstReqBO();
        orderBaseQryTaskInstReqBO.setOrderId(busiReqBO.getOrderId());
        orderBaseQryTaskInstReqBO.setTaskId(busiReqBO.getTaskId());
        orderBaseQryTaskInstReqBO.setTacheCode(busiReqBO.getTacheCode());
        orderBaseQryTaskInstReqBO.setCurState(busiReqBO.getOrderState());
        orderBaseQryTaskInstReqBO.setTaskId(busiReqBO.getTaskId());
        return orderBaseQryTaskInstReqBO;
    }

    private void validateParam(CocCommonFlowReqBO busiReqBO) {
        if (busiReqBO == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (busiReqBO.getObjType() == null) {
            throw new BusinessException("8888", "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (busiReqBO.getOrderId() == null) {
            throw new BusinessException("8888", "\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

