/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.coc.atom.impl;

import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.coc.atom.CocBusiOperRecordAtomService;
import com.tydic.coc.atom.bo.CocBusiOperRecordReqBO;
import com.tydic.coc.atom.bo.CocBusiOperRecordRspBO;
import com.tydic.coc.constant.CocCommConstant;
import com.tydic.coc.dic.DicDictionaryService;
import com.tydic.orderbase.atom.OrderBaseBusiOperRecordAtomService;
import com.tydic.orderbase.atom.OrderBaseQryTaskInstAtomService;
import com.tydic.orderbase.atom.bo.OrderBaseBusiOperRecordReqBO;
import com.tydic.orderbase.atom.bo.OrderBaseBusiOperRecordRspBO;
import com.tydic.orderbase.atom.bo.OrderBaseQryTaskInstReqBO;
import com.tydic.orderbase.atom.bo.OrderBaseQryTaskInstRspBO;
import com.tydic.orderbase.bo.TaskInstBO;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cocBusiOperRecordAtomService")
public class CocBusiOperRecordAtomServiceImpl
implements CocBusiOperRecordAtomService {
    private static final String DEAL_TYPE_KEY = "task_deal_type";
    private static final String DEAL_CODE_KEY = "task_deal_code";
    private DicDictionaryService dicDictionaryService;
    private OrderBaseQryTaskInstAtomService orderBaseQryTaskInstAtomService;
    private OrderBaseBusiOperRecordAtomService orderBaseBusiOperRecordAtomService;
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;

    @Autowired
    public CocBusiOperRecordAtomServiceImpl(DicDictionaryService dicDictionaryService, OrderBaseQryTaskInstAtomService orderBaseQryTaskInstAtomService, OrderBaseBusiOperRecordAtomService orderBaseBusiOperRecordAtomService, SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService) {
        this.dicDictionaryService = dicDictionaryService;
        this.orderBaseQryTaskInstAtomService = orderBaseQryTaskInstAtomService;
        this.orderBaseBusiOperRecordAtomService = orderBaseBusiOperRecordAtomService;
        this.selectUserInfoByUserIdBusiService = selectUserInfoByUserIdBusiService;
    }

    @Override
    public CocBusiOperRecordRspBO dealBusiOperRecord(CocBusiOperRecordReqBO atomReqBO) {
        OrderBaseBusiOperRecordRspBO busiOperRecordRspBO;
        Map<String, String> dealCode;
        CocBusiOperRecordRspBO rsp = new CocBusiOperRecordRspBO();
        this.validateParam(atomReqBO);
        OrderBaseQryTaskInstReqBO qryTaskInstReqBO = new OrderBaseQryTaskInstReqBO();
        qryTaskInstReqBO.setOrderId(atomReqBO.getOrderId());
        OrderBaseQryTaskInstRspBO taskInstRspBO = this.orderBaseQryTaskInstAtomService.qryTaskInst(qryTaskInstReqBO);
        if (!"0000".equals(taskInstRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5f53\u524d\u4efb\u52a1\u5b9e\u4f8b\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + taskInstRspBO.getRespDesc());
        }
        TaskInstBO taskInstBO = taskInstRspBO.getTaskInstBO();
        OrderBaseBusiOperRecordReqBO operRecordReqBO = new OrderBaseBusiOperRecordReqBO();
        BeanUtils.copyProperties((Object)atomReqBO, (Object)operRecordReqBO);
        operRecordReqBO.setCreateTime(taskInstBO.getCreateTime());
        Integer recordType = atomReqBO.getRecordType();
        if (CocCommConstant.BUSI_OPER_RECORD_TYPE.TASK_OPER_RECORD.equals(recordType)) {
            if (!taskInstBO.getTacheCode().equals(atomReqBO.getDealTypeId())) {
                throw new BusinessException("8888", "\u4f20\u5165\u73af\u8282\u4e0d\u662f\u5f53\u524d\u4efb\u52a1\u73af\u8282");
            }
            operRecordReqBO.setTaskId(taskInstBO.getTaskId());
            operRecordReqBO.setTaskName(taskInstBO.getTaskName());
        } else if (!CocCommConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD.equals(recordType)) {
            throw new BusinessException("8888", "\u7535\u5546\u901a\u7528\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\uff1a\u4e0d\u652f\u6301\u7684\u8bb0\u5f55\u7c7b\u578b");
        }
        if (!"AUTO".equals(atomReqBO.getDealOperId()) && atomReqBO.getDealCompId() == null) {
            SelectUserInfoByUserIdReqBO selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
            selectUserInfoReqBO.setUserId(Long.valueOf(atomReqBO.getDealOperId()));
            SelectUserInfoByUserIdRspBO selectUserInfo = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
            if (null == selectUserInfo || null == selectUserInfo.getUserId()) {
                throw new BusinessException("8888", "\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + selectUserInfo.getRespDesc());
            }
            operRecordReqBO.setDealOperName(selectUserInfo.getName());
            operRecordReqBO.setDealCompId(selectUserInfo.getCompId().toString());
            operRecordReqBO.setDealDeptId(selectUserInfo.getOrgId().toString());
        } else {
            operRecordReqBO.setDealCompId(String.valueOf(atomReqBO.getDealCompId()));
            operRecordReqBO.setDealDeptId(String.valueOf(atomReqBO.getDealDeptId()));
        }
        Map<String, String> dealType = this.dicDictionaryService.getValueByCode(DEAL_TYPE_KEY);
        if (dealType != null && StringUtils.isNotBlank((CharSequence)dealType.get(atomReqBO.getDealTypeId()))) {
            operRecordReqBO.setDealTypeName(dealType.get(atomReqBO.getDealTypeId()));
        }
        if ((dealCode = this.dicDictionaryService.getValueByCode(DEAL_CODE_KEY)) != null && StringUtils.isNotBlank((CharSequence)dealCode.get(atomReqBO.getDealCode()))) {
            operRecordReqBO.setDealName(dealCode.get(atomReqBO.getDealCode()));
        }
        if (!"0000".equals((busiOperRecordRspBO = this.orderBaseBusiOperRecordAtomService.createBusiOperRecord(operRecordReqBO)).getRespCode())) {
            rsp.setRespCode(busiOperRecordRspBO.getRespCode());
            rsp.setRespDesc("\u8c03\u7528\u6838\u5fc3\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff1a" + busiOperRecordRspBO.getRespDesc());
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5f00\u901a\u4e2d\u5fc3\u901a\u7528\u6838\u5fc3\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u6210\u529f!");
        return rsp;
    }

    private void validateParam(CocBusiOperRecordReqBO atomReqBO) {
        if (atomReqBO.getRecordType() == null || atomReqBO.getOrderId() == null || atomReqBO.getObjType() == null || StringUtils.isBlank((CharSequence)atomReqBO.getDealOperId())) {
            throw new BusinessException("8888", "\u7535\u5546\u901a\u7528\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)atomReqBO.getDealTypeId())) {
            throw new BusinessException("8888", "\u5904\u7406\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

