/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.coc.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.coc.atom.CocChgVoucherStateAtomService;
import com.tydic.coc.atom.bo.CocChgVoucherStateReqBO;
import com.tydic.coc.atom.bo.CocChgVoucherStateRspBO;
import com.tydic.coc.bo.VoucherStateBO;
import com.tydic.coc.constant.CocCommConstant;
import com.tydic.coc.dao.OrdStateChgLogMapper;
import com.tydic.coc.dao.ServOrderMapper;
import com.tydic.coc.po.OrdStateChgLogPO;
import com.tydic.coc.po.ServOrderPO;
import com.tydic.orderbase.dao.OrderBaseOrderMapper;
import com.tydic.orderbase.po.OrderPO;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cocChgVoucherStateAtomService")
public class CocChgVoucherStateAtomServiceImpl
implements CocChgVoucherStateAtomService {
    private ServOrderMapper servOrderMapper;
    private OrderBaseOrderMapper orderBaseOrderMapper;
    private OrdStateChgLogMapper ordStateChgLogMapper;

    @Autowired
    public CocChgVoucherStateAtomServiceImpl(ServOrderMapper servOrderMapper, OrderBaseOrderMapper orderBaseOrderMapper, OrdStateChgLogMapper ordStateChgLogMapper) {
        this.servOrderMapper = servOrderMapper;
        this.orderBaseOrderMapper = orderBaseOrderMapper;
        this.ordStateChgLogMapper = ordStateChgLogMapper;
    }

    @Override
    public CocChgVoucherStateRspBO dealCoreChgVoucherState(CocChgVoucherStateReqBO atomReqBO) {
        CocChgVoucherStateRspBO rsp = new CocChgVoucherStateRspBO();
        this.validateParam(atomReqBO);
        Long orderId = atomReqBO.getOrderId();
        String operId = atomReqBO.getOperId();
        ArrayList<OrdStateChgLogPO> logList = new ArrayList<OrdStateChgLogPO>();
        for (VoucherStateBO voucherStateBO : atomReqBO.getVoucherStateList()) {
            OrdStateChgLogPO ordStateChgLogPO = new OrdStateChgLogPO();
            ordStateChgLogPO.setOrderId(orderId);
            ordStateChgLogPO.setOperId(operId);
            StringBuilder extDesc = new StringBuilder();
            extDesc.append("[objType=").append(voucherStateBO.getObjType()).append("\uff0cobjId=").append(voucherStateBO.getObjId()).append("]");
            int updateRow = this.doChangeObjState(orderId, voucherStateBO, ordStateChgLogPO);
            if (updateRow == -1) {
                ordStateChgLogPO.setStateType("unknown");
                ordStateChgLogPO.setChgDesc(extDesc.insert(0, "objType\u672a\u5b9a\u4e49\uff0c\u8df3\u8fc7\u72b6\u6001\u66f4\u65b0").toString());
            } else if (updateRow == 1 && StringUtils.isNotBlank((CharSequence)atomReqBO.getDealDesc())) {
                OrderPO orderPO = new OrderPO();
                orderPO.setOrderId(orderId);
                orderPO.setUpdateTime(new Date());
                this.orderBaseOrderMapper.updateById(orderPO);
                ordStateChgLogPO.setChgDesc(extDesc.insert(0, atomReqBO.getDealDesc()).toString());
            } else if (updateRow == 0) {
                ordStateChgLogPO.setChgDesc(extDesc.insert(0, "\u66f4\u65b0\u8be5\u8ba2\u5355\u72b6\u6001\u5931\u8d25").toString());
            }
            logList.add(ordStateChgLogPO);
        }
        this.ordStateChgLogMapper.insertBatch(logList);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5355\u636e\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        return rsp;
    }

    public int doChangeObjState(Long orderId, VoucherStateBO voucherStateBO, OrdStateChgLogPO ordStateChgLogPO) {
        int updateRow;
        String stateType;
        Integer oldState;
        Integer objType = voucherStateBO.getObjType();
        Long objId = voucherStateBO.getObjId();
        Integer orderState = voucherStateBO.getAfterState();
        if (CocCommConstant.OBJ_TYPE.ORDER.equals(objType)) {
            OrderPO orderQuery = new OrderPO();
            orderQuery.setOrderId(orderId);
            orderQuery = this.orderBaseOrderMapper.getModelBy(orderQuery);
            oldState = orderQuery.getOrderState();
            stateType = "A00";
            OrderPO orderPO = new OrderPO();
            orderPO.setOrderId(orderId);
            orderPO.setOrderState(orderState);
            updateRow = this.orderBaseOrderMapper.updateById(orderPO);
        } else if (CocCommConstant.OBJ_TYPE.COC.equals(objType)) {
            ServOrderPO servOrderQuery = new ServOrderPO();
            servOrderQuery.setOrderId(orderId);
            servOrderQuery.setServOrderId(objId);
            servOrderQuery = this.servOrderMapper.getModelBy(servOrderQuery);
            oldState = servOrderQuery.getOrderState();
            stateType = "A01";
            ServOrderPO servOrderPO = new ServOrderPO();
            servOrderPO.setOrderId(orderId);
            servOrderPO.setServOrderId(objId);
            servOrderPO.setOrderState(orderState);
            updateRow = this.servOrderMapper.updateByModel(servOrderPO);
        } else {
            return -1;
        }
        ordStateChgLogPO.setOldState(oldState);
        ordStateChgLogPO.setNewState(orderState);
        ordStateChgLogPO.setStateType(stateType);
        return updateRow;
    }

    private void validateParam(CocChgVoucherStateReqBO atomReqBO) {
        if (StringUtils.isBlank((CharSequence)atomReqBO.getOperId()) || atomReqBO.getOrderId() == null || CollectionUtils.isEmpty(atomReqBO.getVoucherStateList())) {
            throw new BusinessException("8888", "\u8ba2\u5355ID\u3001\u66f4\u65b0\u5355\u636e\u548c\u5904\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (VoucherStateBO voucherStateBO : atomReqBO.getVoucherStateList()) {
            if (voucherStateBO.getObjType() != null && voucherStateBO.getAfterState() != null) continue;
            throw new BusinessException("8888", "\u5355\u636e\u7c7b\u578b\u548c\u5355\u636e\u66f4\u65b0\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

