/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.coc.comb.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.coc.busi.CocCommonFlowBusiService;
import com.tydic.coc.busi.bo.CocCommonFlowReqBO;
import com.tydic.coc.busi.bo.CocCommonFlowRspBO;
import com.tydic.coc.comb.CocCommonFlowCombService;
import com.tydic.orderbase.bo.TaskBO;
import com.tydic.orderbase.busi.OrderBaseSubmitWFQueueBusiService;
import com.tydic.orderbase.busi.OrderBaseToErrorTaskBusiService;
import com.tydic.orderbase.busi.bo.OrderBaseSubmitWFQueueReqBO;
import com.tydic.orderbase.busi.bo.OrderBaseSubmitWFQueueRspBO;
import com.tydic.orderbase.busi.bo.OrderBaseToErrorTaskReqBO;
import com.tydic.orderbase.busi.bo.OrderBaseToErrorTaskRspBO;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cocCommonFlowCombService")
public class CocCommonFlowCombServiceImpl
implements CocCommonFlowCombService {
    private CocCommonFlowBusiService cocCommonFlowBusiService;
    private OrderBaseSubmitWFQueueBusiService orderBaseSubmitWFQueueBusiService;
    private OrderBaseToErrorTaskBusiService orderBaseToErrorTaskBusiService;

    @Autowired
    public CocCommonFlowCombServiceImpl(CocCommonFlowBusiService cocCommonFlowBusiService, OrderBaseSubmitWFQueueBusiService orderBaseSubmitWFQueueBusiService, OrderBaseToErrorTaskBusiService orderBaseToErrorTaskBusiService) {
        this.cocCommonFlowBusiService = cocCommonFlowBusiService;
        this.orderBaseSubmitWFQueueBusiService = orderBaseSubmitWFQueueBusiService;
        this.orderBaseToErrorTaskBusiService = orderBaseToErrorTaskBusiService;
    }

    @Override
    public CocCommonFlowRspBO dealCommonFlow(CocCommonFlowReqBO reqBO) {
        CocCommonFlowRspBO cocCommonFlowRspBO = this.cocCommonFlowBusiService.dealCommonFlow(reqBO);
        if (!"0000".equals(cocCommonFlowRspBO.getRespCode())) {
            this.toErrorTask(reqBO, cocCommonFlowRspBO.getRespCode());
            throw new BusinessException("8888", "\u901a\u7528\u6d41\u8f6c\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5931\u8d25" + cocCommonFlowRspBO.getRespDesc());
        }
        OrderBaseSubmitWFQueueReqBO orderBaseSubmitWFQueueReqBO = new OrderBaseSubmitWFQueueReqBO();
        orderBaseSubmitWFQueueReqBO.setOrderId(reqBO.getOrderId());
        List<TaskBO> taskBOList = cocCommonFlowRspBO.getTaskList();
        if (!CollectionUtils.isEmpty(taskBOList)) {
            for (int i = 0; i < taskBOList.size(); ++i) {
                orderBaseSubmitWFQueueReqBO.setTask(taskBOList.get(i));
                OrderBaseSubmitWFQueueRspBO orderBaseSubmitWFQueueRspBO = this.orderBaseSubmitWFQueueBusiService.submitWFQueue(orderBaseSubmitWFQueueReqBO);
                if ("0000".equals(orderBaseSubmitWFQueueRspBO.getRespCode())) continue;
                this.toErrorTask(reqBO, orderBaseSubmitWFQueueRspBO.getRespDesc());
                throw new BusinessException("8888", "\u6838\u5fc3\u81ea\u52a8\u73af\u8282\u6d88\u606f\u961f\u5217\u786e\u8ba4\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5931\u8d25" + orderBaseSubmitWFQueueRspBO.getRespDesc());
            }
        }
        cocCommonFlowRspBO.setRespCode("0000");
        cocCommonFlowRspBO.setRespDesc("\u901a\u7528\u6d41\u8f6c\u5904\u7406\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u6210\u529f");
        return cocCommonFlowRspBO;
    }

    private void toErrorTask(CocCommonFlowReqBO cocCommonFlowReqBO, String errorDesc) {
        OrderBaseToErrorTaskReqBO orderBaseToErrorTaskReqBO = this.buildToErrorTaskParm(cocCommonFlowReqBO);
        orderBaseToErrorTaskReqBO.setDealDesc(errorDesc);
        OrderBaseToErrorTaskRspBO orderBaseToErrorTaskRspBO = this.orderBaseToErrorTaskBusiService.dealCoreToErrorTask(orderBaseToErrorTaskReqBO);
        if (!"0000".equals(orderBaseToErrorTaskRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u5f02\u5e38\u4efb\u52a1\u63a5\u53e3\u5f02\u5e38\uff1a" + orderBaseToErrorTaskRspBO.getRespDesc());
        }
    }

    private OrderBaseToErrorTaskReqBO buildToErrorTaskParm(CocCommonFlowReqBO cocCommonFlowReqBO) {
        OrderBaseToErrorTaskReqBO orderBaseToErrorTaskReqBO = new OrderBaseToErrorTaskReqBO();
        orderBaseToErrorTaskReqBO.setOrderId(cocCommonFlowReqBO.getOrderId());
        orderBaseToErrorTaskReqBO.setTaskId(cocCommonFlowReqBO.getTaskId());
        orderBaseToErrorTaskReqBO.setTacheCode(cocCommonFlowReqBO.getTacheCode());
        orderBaseToErrorTaskReqBO.setOrderState(cocCommonFlowReqBO.getOrderState());
        orderBaseToErrorTaskReqBO.setDealOper(cocCommonFlowReqBO.getDealOperId());
        return orderBaseToErrorTaskReqBO;
    }
}

