/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.coc.dic.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.coc.dao.CocDicDictionaryMapper;
import com.tydic.coc.dic.DicDictionaryService;
import com.tydic.coc.dic.bo.DicDictionary;
import com.tydic.coc.dic.bo.DicDictionaryBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dicDictionaryService")
public class DicDictionaryServiceImpl
implements DicDictionaryService {
    @Autowired
    private CocDicDictionaryMapper cocDicDictionaryMapper;
    @Autowired
    private CacheClient cacheService;

    @Override
    public void adddict(DicDictionaryBO dict) {
        DicDictionary dicDictionary = new DicDictionary();
        int count = this.cocDicDictionaryMapper.selectcount(dict.getCode(), dict.getPCode());
        if (count > 0) {
            throw new BusinessException("ERROR", "\u7f16\u7801\u5df2\u5b58\u5728");
        }
        BeanUtils.copyProperties((Object)dict, (Object)dicDictionary);
        this.cocDicDictionaryMapper.insertdicty(dicDictionary);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dict.getPCode()})) {
            this.cacheService.delete(dict.getPCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updatedict(DicDictionaryBO dict) {
        DicDictionary dicDictionary = this.cocDicDictionaryMapper.selectdictionaryByCodeAndCode(dict.getCode(), dict.getPCode());
        dicDictionary.setTitle(dict.getTitle());
        dicDictionary.setOrderId(dict.getOrderId());
        dicDictionary.setUpdateUid(dict.getUpdateUid());
        dicDictionary.setUpdateTm(dict.getUpdateTm());
        int num = this.cocDicDictionaryMapper.updatedicty(dicDictionary);
        if (num > 0 && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dicDictionary.getpCode()})) {
            this.cacheService.delete(dicDictionary.getpCode());
        }
        return num;
    }

    @Override
    public DicDictionaryBO selectdict(String code) {
        DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
        DicDictionary dictionary = this.cocDicDictionaryMapper.selectdictionary(code);
        BeanUtils.copyProperties((Object)dictionary, (Object)dicDictionaryBO);
        return dicDictionaryBO;
    }

    @Override
    public DicDictionaryBO selectdictionaryByCodeAndCode(String code, String pcode) {
        DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
        DicDictionary dictionary = this.cocDicDictionaryMapper.selectdictionaryByCodeAndCode(code, pcode);
        if (dictionary != null) {
            BeanUtils.copyProperties((Object)dictionary, (Object)dicDictionaryBO);
        }
        return dicDictionaryBO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deletedict(String code) {
        DicDictionary dicDictionary = this.cocDicDictionaryMapper.selectByPrimaryKey(code);
        int num = this.cocDicDictionaryMapper.updateDisFlag(code);
        this.cocDicDictionaryMapper.selectByPrimaryKey(code);
        if (num > 0 && dicDictionary != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dicDictionary.getpCode()})) {
            this.cacheService.delete(dicDictionary.getpCode());
        }
        return num;
    }

    @Override
    @Transactional
    public List<DicDictionaryBO> selectDictValByCode(String code) {
        ArrayList<DicDictionaryBO> list = new ArrayList<DicDictionaryBO>();
        List<DicDictionary> dicDictionaries = this.cocDicDictionaryMapper.selectDictValByCode(code);
        DicDictionaryBO tmpDicDictionaryBO = null;
        for (DicDictionary dicDictionary : dicDictionaries) {
            tmpDicDictionaryBO = new DicDictionaryBO();
            BeanUtils.copyProperties((Object)dicDictionary, (Object)tmpDicDictionaryBO);
            list.add(tmpDicDictionaryBO);
        }
        return list;
    }

    @Override
    public Map<String, String> getValueByCode(String pCode) {
        List<DicDictionary> list = this.cocDicDictionaryMapper.selectByPCode(pCode);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (DicDictionary dicDictionary : list) {
            map.put(dicDictionary.getCode(), dicDictionary.getTitle());
        }
        return map;
    }

    @Override
    public DicDictionaryBO getCodeByVal(String queryStr, String pCode) {
        DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
        DicDictionary codeByVal = this.cocDicDictionaryMapper.getCodeByVal(queryStr, pCode);
        BeanUtils.copyProperties((Object)codeByVal, (Object)dicDictionaryBO);
        return dicDictionaryBO;
    }
}

