/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.ESupermarketCommdBO;
import com.tydic.commodity.external.bo.JdBookBO;
import com.tydic.commodity.external.bo.JdCommdBO;
import com.tydic.commodity.external.bo.JdVedioBO;
import com.tydic.commodity.external.bo.NotJdCommdDetailsBO;
import com.tydic.commodity.external.bo.Param_entity;
import com.tydic.commodity.external.bo.UccCommdDetailsQryReqBO;
import com.tydic.commodity.external.bo.UccCommdDetailsQryRspBO;
import com.tydic.commodity.external.service.UccCommdDetailsQryService;
import com.tydic.commodity.external.service.impl.UccQryMsgFromInterServiceImpl;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccCommdDetailsQryService")
public class UccCommdDetailsQryServiceImpl
implements UccCommdDetailsQryService {
    private static final Log LOG = LogFactory.getLog(UccQryMsgFromInterServiceImpl.class);
    @Value(value="${jd_imgPath}")
    private String jd_imgPath;
    @Value(value="${grainger_imgPath}")
    private String grainger_imgPath;
    @Value(value="${qst_imgPath}")
    private String qst_imgPath;
    @Value(value="${suning_imgPath}")
    private String suning_imgPath;

    public UccCommdDetailsQryRspBO qryCommdDetails(UccCommdDetailsQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_DETAIL_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_DETAIL_URL") + "]"));
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccCommdDetailsQryRspBO resolveRsp = this.resolveRsp(returnString, reqBO);
            if (resolveRsp != null) {
                LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString()));
            }
            return resolveRsp;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(UccCommdDetailsQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        if (!"jd".equals(reqBO.getSupplierCode())) {
            jsonObject.put("sku", (Object)reqBO.getSkuId());
            jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
            jsonObject.put("isShow", (Object)false);
        } else {
            jsonObject.put("sku", (Object)reqBO.getSkuId());
            jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
            jsonObject.put("queryExts", (Object)"appintroduce,shouhou,isFactoryShip,isEnergySaving,contractSkuExt,ChinaCatalog");
        }
        return jsonObject.toString();
    }

    private UccCommdDetailsQryRspBO resolveRsp(String returnString, UccCommdDetailsQryReqBO reqBO) {
        UccCommdDetailsQryRspBO rspBO = new UccCommdDetailsQryRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess(((Boolean)rspJsonObject.get((Object)"success")).booleanValue());
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    rspBO.setResultMessage("\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u5546\u54c1\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef");
                }
                rspBO.setResultCode("8888");
                return rspBO;
            }
            ESupermarketCommdBO eSupermarketCommdBO = new ESupermarketCommdBO();
            if ("jd".equals(reqBO.getSupplierCode())) {
                if (reqBO.getSkuId().length() < 8) {
                    JSONObject result = (JSONObject)rspJsonObject.get((Object)"result");
                    if (result != null) {
                        String str = JSONObject.toJSONString((Object)result);
                        JdCommdBO jdCommdBO = (JdCommdBO)JSONObject.parseObject((String)str, JdCommdBO.class);
                        JSONArray category = result.getJSONArray("category");
                        ArrayList<String> categorys = new ArrayList<String>();
                        if (category != null && category.size() > 0) {
                            for (int i = 0; i < category.size(); ++i) {
                                categorys.add((String)category.get(i));
                            }
                        }
                        jdCommdBO.setCategory(categorys);
                        String imgPath = (String)result.get((Object)"imagePath");
                        imgPath = this.jd_imgPath + imgPath;
                        jdCommdBO.setImagePath(imgPath);
                        eSupermarketCommdBO.setJdCommdInfo(jdCommdBO);
                    }
                } else {
                    JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
                    String skuType = (String)jsonObject.get((Object)"skuType");
                    String jsonObject1 = JSONObject.toJSONString((Object)rspJsonObject.get((Object)"result"));
                    if ("book".equals(skuType)) {
                        JdBookBO jdBookBO = (JdBookBO)JSONObject.parseObject((String)jsonObject1, JdBookBO.class);
                        String img = jdBookBO.getImage();
                        img = this.jd_imgPath + img;
                        jdBookBO.setImage(img);
                        eSupermarketCommdBO.setJdBookInfo(jdBookBO);
                    } else if ("vedio".equals(skuType)) {
                        JdVedioBO jdVedioBO = (JdVedioBO)JSONObject.parseObject((String)jsonObject1, JdVedioBO.class);
                        String img = jdVedioBO.getImage();
                        img = img + this.jd_imgPath;
                        jdVedioBO.setImage(img);
                        eSupermarketCommdBO.setJdVedioInfo(jdVedioBO);
                    }
                }
            } else {
                String result = JSONObject.toJSONString((Object)rspJsonObject.get((Object)"result"));
                NotJdCommdDetailsBO notJdCommdDetailsBO = (NotJdCommdDetailsBO)JSONObject.parseObject((String)result, NotJdCommdDetailsBO.class);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String category = JSONObject.toJSONString((Object)jsonObject.get((Object)"category"));
                List categoryList = JSONObject.parseArray((String)category, String.class);
                notJdCommdDetailsBO.setCategory(categoryList);
                String param = JSONObject.toJSONString((Object)jsonObject.get((Object)"param"));
                List param_entities = JSONObject.parseArray((String)param, Param_entity.class);
                notJdCommdDetailsBO.setParam(param_entities);
                String imgPath = notJdCommdDetailsBO.getImagePath();
                if ("qst".equals(reqBO.getSupplierCode())) {
                    imgPath = this.qst_imgPath + imgPath;
                } else if ("suning".equals(reqBO.getSupplierCode())) {
                    imgPath = this.suning_imgPath + imgPath;
                } else if ("grainger".equals(reqBO.getSupplierCode())) {
                    imgPath = this.grainger_imgPath + imgPath;
                }
                notJdCommdDetailsBO.setImagePath(imgPath);
                eSupermarketCommdBO.setNotJdCommdDetails(notJdCommdDetailsBO);
            }
            rspBO.setResult(eSupermarketCommdBO);
            return rspBO;
        }
        catch (Exception var10) {
            LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10));
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

