/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.CommdStockBO;
import com.tydic.commodity.external.bo.UccCurrentStockQryReqBO;
import com.tydic.commodity.external.bo.UccCurrentStockQryRspBO;
import com.tydic.commodity.external.service.UccCurrentStockQryService;
import com.tydic.commodity.external.service.impl.UccQryMsgFromInterServiceImpl;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccCurrentStockQryService")
public class UccCurrentStockQryServiceImpl
implements UccCurrentStockQryService {
    private static final Log LOG = LogFactory.getLog(UccQryMsgFromInterServiceImpl.class);

    public UccCurrentStockQryRspBO qryCommdCurrentStock(UccCurrentStockQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_STOCK_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_STOCK_URL") + "]"));
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccCurrentStockQryRspBO resolveRsp = this.resolveRsp(returnString);
            if (resolveRsp != null) {
                LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString()));
            }
            return resolveRsp;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(UccCurrentStockQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuNums", (Object)reqBO.getSkuNum());
        String area = "" + reqBO.getProvince() + "_" + reqBO.getCity() + "_" + reqBO.getCounty() + "";
        jsonObject.put("area", (Object)area);
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        return jsonObject.toString();
    }

    private UccCurrentStockQryRspBO resolveRsp(String returnString) {
        UccCurrentStockQryRspBO rspBO = new UccCurrentStockQryRspBO();
        ArrayList<CommdStockBO> list = new ArrayList<CommdStockBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess(((Boolean)rspJsonObject.get((Object)"success")).booleanValue());
            rspBO.setResultCode(rspJsonObject.get((Object)"resultCode").toString());
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    rspBO.setResultMessage("\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u5e93\u5b58\u6570\u91cf\u5b9e\u65f6\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef");
                }
                rspBO.setResultCode("8888");
                return rspBO;
            }
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    CommdStockBO jsonStringToJavaBean = (CommdStockBO)JSON.parseObject((String)jsonStr, CommdStockBO.class);
                    list.add(jsonStringToJavaBean);
                }
                rspBO.setCommdStockInfo(list);
            }
            return rspBO;
        }
        catch (Exception var10) {
            LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10));
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

