/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.JsonUtils;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.SkuStateRspBo;
import com.tydic.commodity.external.bo.UccSkuStateReqBO;
import com.tydic.commodity.external.bo.UccSkuStateRsp;
import com.tydic.commodity.external.service.UccQrySkuStateService;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccQrySkuStateService")
public class UccQrySkuStateServiceImpl
implements UccQrySkuStateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQrySkuStateServiceImpl.class);

    public UccSkuStateRsp qrySkuStatus(UccSkuStateReqBO reqBO) {
        UccSkuStateRsp skuStateRsp = new UccSkuStateRsp();
        if (null == reqBO.getSupplierId()) {
            skuStateRsp.setRespCode("8888");
            skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u4f9b\u5e94\u5546supplierId[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            return skuStateRsp;
        }
        if (reqBO.getExtSkuIds().isEmpty()) {
            skuStateRsp.setRespCode("8888");
            skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5546\u54c1ID\u96c6\u5408[extSkuIds]\u4e0d\u80fd\u4e3a\u7a7a");
            return skuStateRsp;
        }
        try {
            ArrayList<Long> existSkuIds = new ArrayList<Long>();
            String resultCode = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(resultCode, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_STATE_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOGGER.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_STATE_URL") + "]");
                skuStateRsp.setRespCode((String)null);
                skuStateRsp.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u5931\u8d25");
                return skuStateRsp;
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                skuStateRsp.setRespCode("8888");
                skuStateRsp.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return skuStateRsp;
            }
            skuStateRsp = this.resolveRspMsg(returnString, existSkuIds);
            return skuStateRsp;
        }
        catch (Exception var9) {
            LOGGER.error("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + var9);
            String resultCode = "";
            if (var9 instanceof BusinessException) {
                resultCode = StringUtils.isEmpty((Object)((BusinessException)((Object)var9)).getMsgCode()) ? "RSP_CODE_BUSI_SERVICE_ERROR" : ((BusinessException)((Object)var9)).getMsgCode();
                skuStateRsp.setRespCode("8888");
                skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + var9.getMessage());
                return skuStateRsp;
            }
            skuStateRsp.setRespCode("8888");
            skuStateRsp.setRespDesc("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            return skuStateRsp;
        }
    }

    private String initReqStr(UccSkuStateReqBO skuStateReqBO) {
        ArrayList<String> extSkuIds = new ArrayList<String>();
        for (String extSkuId : skuStateReqBO.getExtSkuIds()) {
            extSkuIds.add('\"' + extSkuId + '\"');
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"sku\":").append(extSkuIds).append("}");
        return sb.toString();
    }

    private UccSkuStateRsp resolveRspMsg(String rspStr, List<Long> existSkuIds) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        List resultList = (List)jsonObject.get((Object)"result");
        UccSkuStateRsp skuStateRsp = new UccSkuStateRsp();
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue() && null != resultList) {
            if (!resultList.isEmpty()) {
                try {
                    SkuStateRspBo[] skuStateRspBoArr = (SkuStateRspBo[])JsonUtils.jsonStringToJavaBean((String)JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), SkuStateRspBo[].class);
                    List<SkuStateRspBo> skuStateRspBos = Arrays.asList(skuStateRspBoArr);
                    skuStateRsp.setSkuStates(skuStateRspBos);
                    if (!StringUtils.isEmpty((Object)JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")))) {
                        skuStateRsp.setResultMessage(JSONObject.toJSONString((Object)jsonObject.get((Object)"resultMessage")));
                    }
                    if (!existSkuIds.isEmpty()) {
                        String existSkuIdStr = "";
                        for (int i = 0; i < existSkuIds.size(); ++i) {
                            existSkuIdStr = i == existSkuIds.size() - 1 ? existSkuIdStr + existSkuIds.get(i) : existSkuIdStr + existSkuIds.get(i) + ",";
                        }
                        skuStateRsp.setResultMessage("\u5546\u54c1SKUID[" + existSkuIdStr + "]\u5728\u5e93\u4e2d\u4e0d\u5b58\u5728");
                    }
                    skuStateRsp.setRespCode("0000");
                    skuStateRsp.setRespDesc("\u6210\u529f");
                    return skuStateRsp;
                }
                catch (Exception var10) {
                    LOGGER.error("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + var10);
                    skuStateRsp.setRespCode("8888");
                    skuStateRsp.setRespDesc("\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u5931\u8d25");
                    return skuStateRsp;
                }
            }
            LOGGER.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            skuStateRsp.setRespCode("8888");
            skuStateRsp.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            return skuStateRsp;
        }
        LOGGER.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001\u4e1a\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u5546\u54c1\u533a\u57df\u8d2d\u4e70\u9650\u5236\u67e5\u8be2\uff1a" + jsonObject.get((Object)"resultMessage"));
        skuStateRsp.setRespCode("8888");
        skuStateRsp.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        return skuStateRsp;
    }
}

