/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.CommdShufflingPicBO;
import com.tydic.commodity.external.bo.JdCommdPicBO;
import com.tydic.commodity.external.bo.NotJdCommdPicBO;
import com.tydic.commodity.external.bo.UccShufflingPicQryReqBO;
import com.tydic.commodity.external.bo.UccShufflingPicQryRspBO;
import com.tydic.commodity.external.service.UccShufflingPicQryService;
import com.tydic.commodity.external.service.impl.UccQryMsgFromInterServiceImpl;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccShufflingPicQryService")
public class UccShufflingPicQryServiceImpl
implements UccShufflingPicQryService {
    private static final Log LOG = LogFactory.getLog(UccQryMsgFromInterServiceImpl.class);
    @Value(value="${jd_imgPath}")
    private String jd_imgPath;
    @Value(value="${grainger_imgPath}")
    private String grainger_imgPath;
    @Value(value="${qst_imgPath}")
    private String qst_imgPath;
    @Value(value="${suning_imgPath}")
    private String suning_imgPath;
    @Value(value="${deli_imgPath}")
    private String deli_imgPath;
    @Value(value="${zkh_imgPath}")
    private String zkh_imgPath;

    public UccShufflingPicQryRspBO qryShufflingPic(UccShufflingPicQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_IMG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_IMG_URL") + "]"));
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccShufflingPicQryRspBO resolveRsp = this.resolveRsp(returnString, reqBO);
            if (resolveRsp != null) {
                LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString()));
            }
            return resolveRsp;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(UccShufflingPicQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sku", (Object)reqBO.getSkuIds());
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        return jsonObject.toString();
    }

    private UccShufflingPicQryRspBO resolveRsp(String returnString, UccShufflingPicQryReqBO reqBO) {
        UccShufflingPicQryRspBO rspBO = new UccShufflingPicQryRspBO();
        ArrayList<CommdShufflingPicBO> list = new ArrayList<CommdShufflingPicBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess(((Boolean)rspJsonObject.get((Object)"success")).booleanValue());
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    rspBO.setResultMessage("\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u5546\u54c1\u56fe\u7247\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef");
                }
                rspBO.setResultCode("8888");
                return rspBO;
            }
            if (!"jd".equals(reqBO.getSupplierCode())) {
                JSONArray object = rspJsonObject.getJSONArray("result");
                if (null != object) {
                    for (int i = 0; i < object.size(); ++i) {
                        JSONObject obj = (JSONObject)object.get(i);
                        String jsonStr = JSONObject.toJSONString((Object)obj);
                        if (StringUtils.isEmpty((Object)jsonStr)) continue;
                        CommdShufflingPicBO commdShufflingPicBO1 = (CommdShufflingPicBO)JSONObject.parseObject((String)jsonStr, CommdShufflingPicBO.class);
                        if (obj.get((Object)"skuPic") != null) {
                            String skuPics = JSONObject.toJSONString((Object)obj.get((Object)"skuPic"));
                            List notJdCommdPicBOList = JSONObject.parseArray((String)skuPics, NotJdCommdPicBO.class);
                            ArrayList<NotJdCommdPicBO> newNotJdPicBO = new ArrayList<NotJdCommdPicBO>();
                            if (notJdCommdPicBOList != null && notJdCommdPicBOList.size() > 0) {
                                for (NotJdCommdPicBO notJdCommdPicBO : notJdCommdPicBOList) {
                                    NotJdCommdPicBO notJdCommdPicBO1 = new NotJdCommdPicBO();
                                    BeanUtils.copyProperties((Object)notJdCommdPicBO, (Object)notJdCommdPicBO1);
                                    if ("grainger".equals(reqBO.getSupplierCode())) {
                                        notJdCommdPicBO1.setPath(this.grainger_imgPath + notJdCommdPicBO.getPath());
                                    } else if ("qst".equals(reqBO.getSupplierCode())) {
                                        notJdCommdPicBO1.setPath(this.qst_imgPath + notJdCommdPicBO.getPath());
                                    } else if ("suning".equals(reqBO.getSupplierCode())) {
                                        notJdCommdPicBO1.setPath(this.suning_imgPath + notJdCommdPicBO.getPath());
                                    } else if ("deli".equals(reqBO.getSupplierCode())) {
                                        notJdCommdPicBO1.setPath(this.deli_imgPath + notJdCommdPicBO.getPath());
                                    } else if ("zkh".equals(reqBO.getSupplierCode())) {
                                        notJdCommdPicBO1.setPath(this.zkh_imgPath + notJdCommdPicBO.getPath());
                                    }
                                    newNotJdPicBO.add(notJdCommdPicBO1);
                                }
                            }
                            commdShufflingPicBO1.setNotJdCommdPicInfo(newNotJdPicBO);
                        }
                        list.add(commdShufflingPicBO1);
                    }
                    rspBO.setResult(list);
                }
            } else {
                Map skuImage = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rspJsonObject.get((Object)"result")), Map.class);
                Set set = skuImage.keySet();
                if (set != null && set.size() > 0) {
                    for (String key : set) {
                        CommdShufflingPicBO commdShufflingPicBO = new CommdShufflingPicBO();
                        commdShufflingPicBO.setSku(key);
                        if (skuImage.get(key) != null) {
                            String skuImgs = JSONObject.toJSONString(skuImage.get(key));
                            List skuImgs1 = JSONObject.parseArray((String)skuImgs, JdCommdPicBO.class);
                            ArrayList<JdCommdPicBO> jdCommdPicBOS = new ArrayList<JdCommdPicBO>();
                            if (skuImgs1 != null && skuImgs1.size() > 0) {
                                for (JdCommdPicBO jdCommdPicBO : skuImgs1) {
                                    JdCommdPicBO jdCommdPicBO1 = new JdCommdPicBO();
                                    BeanUtils.copyProperties((Object)jdCommdPicBO, (Object)jdCommdPicBO1);
                                    jdCommdPicBO1.setPath(this.jd_imgPath + jdCommdPicBO.getPath());
                                    jdCommdPicBOS.add(jdCommdPicBO1);
                                }
                            }
                            commdShufflingPicBO.setJdCommdPicInfos(jdCommdPicBOS);
                        }
                        list.add(commdShufflingPicBO);
                    }
                }
                rspJsonObject.get((Object)"result");
            }
            return rspBO;
        }
        catch (Exception var10) {
            LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10));
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

