/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.UccTmCommdQryReqBO;
import com.tydic.commodity.external.bo.UccTmCommdQryRspBO;
import com.tydic.commodity.external.service.UccTmCommdQryService;
import com.tydic.commodity.external.service.impl.UccTmCommdStockQryServiceImpl;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.SignUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccTmCommdQryService")
public class UccTmCommdQryServiceImpl
implements UccTmCommdQryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccTmCommdStockQryServiceImpl.class);
    @Value(value="${linkmall_app_key}")
    private String appKey;
    @Value(value="${linkmall_appSecret}")
    private String appSecret;

    public UccTmCommdQryRspBO qryTmCommd(UccTmCommdQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            LOGGER.info("\u8c03\u7528\u5929\u732b\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqStr));
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("TM_QRY_COMMD_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOGGER.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_STOCK_URL") + "]");
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            LOGGER.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccTmCommdQryRspBO rspBO = this.resolveRsp(returnString);
            if (rspBO != null) {
                LOGGER.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + rspBO.toString());
            }
            return rspBO;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(UccTmCommdQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        String sign = this.getSign(reqBO);
        jsonObject.put("sign", (Object)sign);
        jsonObject.put("appKey", (Object)this.appKey);
        jsonObject.put("itemId", (Object)reqBO.getItemId());
        return jsonObject.toString();
    }

    private UccTmCommdQryRspBO resolveRsp(String returnString) {
        UccTmCommdQryRspBO rspBO = new UccTmCommdQryRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            JSONObject data = (JSONObject)rspJsonObject.get((Object)"data");
            JSONObject item = (JSONObject)data.get((Object)"item");
            rspBO = (UccTmCommdQryRspBO)item.toJavaObject(UccTmCommdQryRspBO.class);
            rspBO.setRespCode(rspJsonObject.get((Object)"code").toString());
            rspBO.setRespDesc(rspJsonObject.get((Object)"message").toString());
            return rspBO;
        }
        catch (Exception var10) {
            LOGGER.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }

    private String getSign(UccTmCommdQryReqBO reqBO) {
        HashMap<String, String> paramStockString = new HashMap<String, String>();
        paramStockString.put("itemId", reqBO.getItemId().toString());
        paramStockString.put("appKey", this.appKey);
        String sign = "";
        try {
            sign = SignUtil.getSignMp(paramStockString, this.appSecret);
            System.out.println("\u5546\u54c1\u8be6\u60c5\uff1a" + sign);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sign;
    }
}

