/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.tydic.commodity.ability.api.QueryFtpFoldersService;
import com.tydic.commodity.bo.ability.FolderBO;
import com.tydic.commodity.bo.ability.QueryFtpFoldersReqBO;
import com.tydic.commodity.bo.ability.QueryFtpFoldersRspBO;
import com.tydic.commodity.util.FtpCollectionUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.ability.api.QueryFtpFoldersService"})
public class QueryFtpFoldersServiceImpl
implements QueryFtpFoldersService {
    private static final Logger log = LoggerFactory.getLogger(QueryFtpFoldersServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(QueryFtpFoldersServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Value(value="${ftp.host}")
    private String hostname;
    @Value(value="${ftp.port}")
    private Integer port;
    @Value(value="${ftp.user}")
    private String username;
    @Value(value="${ftp.pwd}")
    private String password;

    @PostMapping(value={"queryFtpFolders"})
    public QueryFtpFoldersRspBO queryFtpFolders(@RequestBody QueryFtpFoldersReqBO queryFtpFoldersReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2 ftp \u6587\u4ef6\u5939\u5217\u8868\u670d\u52a1\u5165\u53c2\uff1a" + queryFtpFoldersReqBO.toString());
        }
        QueryFtpFoldersRspBO rspBO = new QueryFtpFoldersRspBO();
        FtpCollectionUtil ftpUtil = new FtpCollectionUtil(this.username, this.password, this.hostname, this.port);
        ArrayList<FolderBO> folderList = new ArrayList<FolderBO>();
        try {
            ftpUtil.listFolders(queryFtpFoldersReqBO.getPath(), folderList);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5217\u8868\u67e5\u8be2\u5931\u8d25 \uff1a" + e.getMessage());
        }
        rspBO.setFolderList(folderList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

