/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.ability.api.UccCommdDetailQryAbilityService;
import com.tydic.commodity.bo.ability.SkuInfoSaleNumBo;
import com.tydic.commodity.bo.ability.UccCommdDetailQryAbilityReqBO;
import com.tydic.commodity.bo.ability.UccCommdDetailQryAbilityRspBO;
import com.tydic.commodity.bo.ability.UccCommdDetailsQryAbilityReqBo;
import com.tydic.commodity.bo.ability.UccCommdDetailsQryAbilityRspBo;
import com.tydic.commodity.bo.busi.AreaAvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.AvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.CommdDetailsBO_busi;
import com.tydic.commodity.bo.busi.CommdPriceBO_busi;
import com.tydic.commodity.bo.busi.CommdShufflingPicBO_busi;
import com.tydic.commodity.bo.busi.CommdStockBO_busi;
import com.tydic.commodity.bo.busi.ESupermarketCommdBO;
import com.tydic.commodity.bo.busi.NotJdCommdDetailsBO_busi;
import com.tydic.commodity.bo.busi.NotJdCommdPicBO_busi;
import com.tydic.commodity.bo.busi.NotJdPriceBO_busi;
import com.tydic.commodity.bo.busi.SkuBo;
import com.tydic.commodity.bo.busi.SupplierShopBO;
import com.tydic.commodity.bo.busi.UccCommdDetailsQryReqBO;
import com.tydic.commodity.bo.busi.UccCommdDetailsQryRspBo;
import com.tydic.commodity.busi.api.UccAgreementProduceCommdQryBusiService;
import com.tydic.commodity.busi.api.UccCommdDetailsQryBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccChannelPutMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccChannelPutPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccMallBrandRelPO;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccVendorPo;
import com.tydic.commodity.enumType.SkuSourceEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.external.bo.UccTmCommdQryReqBO;
import com.tydic.commodity.external.bo.UccTmCommdQryRspBO;
import com.tydic.commodity.external.service.UccTmCommdQryService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.ability.api.UccCommdDetailQryAbilityService"})
public class UccCommdDetailQryAbilityServiceImpl
implements UccCommdDetailQryAbilityService {
    @Autowired
    private UccCommdDetailsQryBusiService uccCommdDetailsQryBusiService;
    @Autowired
    private UccTmCommdQryService uccTmCommdQryService;
    @Autowired
    private UccAgreementProduceCommdQryBusiService uccAgreementProduceCommdQryBusiService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccChannelPutMapper uccChannelPutMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;

    @PostMapping(value={"qryCommdDetail"})
    public UccCommdDetailQryAbilityRspBO qryCommdDetail(@RequestBody UccCommdDetailQryAbilityReqBO reqBo) {
        UccCommdDetailQryAbilityRspBO rspBo = new UccCommdDetailQryAbilityRspBO();
        if (null == reqBo || null == reqBo.getSkuId() || null == reqBo.getSupplierShopId()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5355\u54c1ID\u3001\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        CommdDetailsBO_busi commdDetailsBOBusi = new CommdDetailsBO_busi();
        UccCommodityPo uccCommodityPo = this.judgeSource(reqBo);
        if (uccCommodityPo != null && uccCommodityPo.getCommodityId() != null) {
            rspBo = this.getImCommdInfo(uccCommodityPo, reqBo);
            return rspBo;
        }
        UccSkuPo uccSkuPo1 = new UccSkuPo();
        uccSkuPo1.setSkuId(reqBo.getSkuId());
        uccSkuPo1.setSupplierShopId(reqBo.getSupplierShopId());
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo1);
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("sku_id =" + reqBo.getSkuId() + "\u5355\u54c1\u4e0d\u5b58\u5728");
            return rspBo;
        }
        if (uccSkuPos.get(0).getSkuSource().equals(SkuSourceEnum.AGREEMENT_SOURCE.getSource())) {
            UccCommdDetailsQryAbilityReqBo detailsQryReqBo = new UccCommdDetailsQryAbilityReqBo();
            detailsQryReqBo.setSkuId(reqBo.getSkuId());
            detailsQryReqBo.setSupplierShopId(reqBo.getSupplierShopId());
            UccCommdDetailsQryAbilityRspBo uccCommdDetailsQryAbilityRspBo = this.uccAgreementProduceCommdQryBusiService.getAgreementProduceCommd(detailsQryReqBo);
            rspBo.setRespCode(uccCommdDetailsQryAbilityRspBo.getRespCode());
            rspBo.setRespDesc(uccCommdDetailsQryAbilityRspBo.getRespDesc());
            rspBo.setCommdDetailsInfo(uccCommdDetailsQryAbilityRspBo.getCommdDetailsInfo());
            return rspBo;
        }
        SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId());
        if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
            rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode("8888");
            return rspBo;
        }
        Long supplierId = supplierShopPo.getSupplierId();
        SupplierShopBO supplierShopBO = new SupplierShopBO();
        BeanUtils.copyProperties((Object)supplierShopPo, (Object)supplierShopBO);
        commdDetailsBOBusi.setSupplierShopInfo(supplierShopBO);
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(supplierId);
        if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
            rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode("8888");
            return rspBo;
        }
        String supplierCode = supplierBusiPo.getSupplierCode();
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
        uccSkuPo.setSkuId(reqBo.getSkuId());
        List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
        if (uccSkuPoList == null) {
            commdDetailsBOBusi.setStatus("3");
            rspBo.setCommdDetailsInfo(commdDetailsBOBusi);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u5355\u54c1\u5931\u6548");
            return rspBo;
        }
        if (uccSkuPoList.size() != 1) {
            rspBo.setRespDesc("\u5355\u54c1\u4e0d\u552f\u4e00");
            rspBo.setRespCode("8888");
            return rspBo;
        }
        String extSkuId = uccSkuPoList.get(0).getExtSkuId();
        if (StringUtils.isEmpty((CharSequence)extSkuId)) {
            rspBo.setRespDesc("\u5916\u90e8\u5355\u54c1ID\u4e3a\u7a7a");
            rspBo.setRespCode("8888");
            return rspBo;
        }
        if (!uccSkuPoList.get(0).getSkuStatus().equals(ModelRuleConstant.SKU_STATUS_ON_SHELF)) {
            commdDetailsBOBusi.setStatus("2");
        } else {
            commdDetailsBOBusi.setStatus("1");
        }
        SkuBo skuBo = new SkuBo();
        BeanUtils.copyProperties((Object)uccSkuPoList.get(0), (Object)skuBo);
        if (skuBo.getSkuStatus().equals(SkuStatusEnum.ON_SHELVES_STATUS.getStatus())) {
            skuBo.setSkuStatus(Integer.valueOf(1));
        } else {
            skuBo.setSkuStatus(Integer.valueOf(2));
        }
        if (skuBo.getSkuSource() != null) {
            skuBo.setSkuSourceDesc(SkuSourceEnum.getSourceDesc((Integer)skuBo.getSkuSource()).getSourceDesc());
        }
        UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
        uccMallBrandRelPo.setBrandId(skuBo.getBrandId());
        List<UccMallBrandRelPO> mallBrandRelPoList = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo);
        if (CollectionUtils.isNotEmpty(mallBrandRelPoList)) {
            skuBo.setBrandId(mallBrandRelPoList.get(0).getMallBrandId());
            skuBo.setBrandName(mallBrandRelPoList.get(0).getMallBrandName());
        }
        commdDetailsBOBusi.setSkuInfo(skuBo);
        commdDetailsBOBusi.setSupplierId(supplierId);
        commdDetailsBOBusi.setSupplierCode(supplierCode);
        UccCommdDetailsQryReqBO uccCommdDetailsQryReqBO = new UccCommdDetailsQryReqBO();
        uccCommdDetailsQryReqBO.setSkuId(reqBo.getSkuId());
        uccCommdDetailsQryReqBO.setSupplierShopId(reqBo.getSupplierShopId());
        UccCommdDetailsQryRspBo uccCommdDetailsQryRspBO = this.uccCommdDetailsQryBusiService.qryCommdDetails(uccCommdDetailsQryReqBO);
        if (!"0000".equals(uccCommdDetailsQryRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)uccCommdDetailsQryRspBO, (Object)rspBo);
            return rspBo;
        }
        if (uccCommdDetailsQryRspBO.getCommdInfo() != null) {
            commdDetailsBOBusi.setCommdInfo(uccCommdDetailsQryRspBO.getCommdInfo());
        }
        String catalogCode = this.uccSkuMapper.qryMdmCodeBySkuId(reqBo.getSkuId());
        commdDetailsBOBusi.setCatalogCode(catalogCode);
        UccChannelPutPo uccChannelPutPo = new UccChannelPutPo();
        uccChannelPutPo.setPutObjId(reqBo.getSkuId());
        uccChannelPutPo.setSupplierShopId(reqBo.getSupplierShopId());
        List<UccChannelPutPo> channelPutPos = this.uccChannelPutMapper.qryChannels(uccChannelPutPo);
        if (channelPutPos != null && channelPutPos.size() > 0) {
            ArrayList<Long> chanelIds = new ArrayList<Long>();
            for (UccChannelPutPo each : channelPutPos) {
                chanelIds.add(each.getChannelId());
            }
            commdDetailsBOBusi.setChannelIds(chanelIds);
        }
        List<UccSaleNumPo> uccSaleNumPos = this.uccSaleNumMapper.qryBySkuIds(Lists.newArrayList((Object[])new Long[]{reqBo.getSkuId()}));
        SkuInfoSaleNumBo skuInfoSaleNumBo = new SkuInfoSaleNumBo();
        if (CollectionUtils.isNotEmpty(uccSaleNumPos)) {
            if (uccSaleNumPos.get(0).getSoldNumber() == null) {
                skuInfoSaleNumBo.setSoldNumber(new BigDecimal(0));
            } else {
                skuInfoSaleNumBo.setSoldNumber(uccSaleNumPos.get(0).getSoldNumber());
            }
            if (uccSaleNumPos.get(0).getEcommerceSale() == null) {
                skuInfoSaleNumBo.setEcommerceSale(new BigDecimal(0));
            } else {
                skuInfoSaleNumBo.setEcommerceSale(uccSaleNumPos.get(0).getEcommerceSale());
            }
        } else {
            skuInfoSaleNumBo.setEcommerceSale(new BigDecimal(0));
            skuInfoSaleNumBo.setSoldNumber(new BigDecimal(0));
        }
        rspBo.setSkuInfoSaleNumBo(skuInfoSaleNumBo);
        rspBo.setCommdDetailsInfo(commdDetailsBOBusi);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccCommodityPo judgeSource(UccCommdDetailQryAbilityReqBO reqBO) {
        UccSkuPo skuInfo;
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccSkuPo.setSkuId(reqBO.getSkuId());
        List<UccSkuPo> uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isNotEmpty(uccSkuPoList) && (skuInfo = uccSkuPoList.get(0)).getSkuSource().equals(SkuSourceEnum.PROPRIETARY_SKU_SOURCE.getSource()) && (uccCommodityPo = this.uccCommodityMapper.qryCommdByCommdId(skuInfo.getCommodityId(), reqBO.getSupplierShopId())) != null && uccCommodityPo.getVendorId() != null) {
            UccVendorPo uccVendorPo = new UccVendorPo();
            uccVendorPo.setVendorId(uccCommodityPo.getVendorId());
            List<UccVendorPo> uccVendorPos = this.uccVendorMapper.queryVerdor(uccVendorPo);
            if (CollectionUtils.isNotEmpty(uccVendorPos) && !"tianmao".equals(uccVendorPos.get(0).getVendorCode())) {
                uccCommodityPo = new UccCommodityPo();
            }
        }
        return uccCommodityPo;
    }

    private UccCommdDetailQryAbilityRspBO getImCommdInfo(UccCommodityPo uccCommodityPo, UccCommdDetailQryAbilityReqBO reqBO) {
        UccCommdDetailQryAbilityRspBO rspBo = new UccCommdDetailQryAbilityRspBO();
        rspBo.setRespCode("8888");
        rspBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        UccTmCommdQryReqBO uccTmCommdQryReqBO = new UccTmCommdQryReqBO();
        uccTmCommdQryReqBO.setItemId(Long.valueOf(Long.parseLong(uccCommodityPo.getExtSkuId())));
        UccTmCommdQryRspBO uccTmCommdQryRspBO = this.uccTmCommdQryService.qryTmCommd(uccTmCommdQryReqBO);
        if (!"0000".equals(uccTmCommdQryRspBO.getRespCode())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(uccTmCommdQryRspBO.getRespDesc());
            return rspBo;
        }
        CommdDetailsBO_busi commdDetailsBO_busi = new CommdDetailsBO_busi();
        ArrayList<AvailableCommdBO_busi> availableCommdInfos = new ArrayList<AvailableCommdBO_busi>();
        AvailableCommdBO_busi availableCommdBO_busi = new AvailableCommdBO_busi();
        availableCommdBO_busi.setSkuId(reqBO.getSkuId().toString());
        availableCommdBO_busi.setName(uccCommodityPo.getCommodityName());
        availableCommdBO_busi.setIs7ToReturn(Integer.valueOf(1));
        availableCommdBO_busi.setIsCanVAT(Integer.valueOf(1));
        if (uccTmCommdQryRspBO.getCanSell() == 1) {
            availableCommdBO_busi.setSaleState(Integer.valueOf(1));
        } else {
            availableCommdBO_busi.setSaleState(Integer.valueOf(0));
        }
        availableCommdInfos.add(availableCommdBO_busi);
        commdDetailsBO_busi.setAvailableCommdInfos(availableCommdInfos);
        ArrayList<AreaAvailableCommdBO_busi> areaAvailableCommdInfos = new ArrayList<AreaAvailableCommdBO_busi>();
        AreaAvailableCommdBO_busi areaAvailableCommdBO_busi = new AreaAvailableCommdBO_busi();
        areaAvailableCommdBO_busi.setSkuId(reqBO.getSkuId().toString());
        areaAvailableCommdBO_busi.setAreaRestrict(false);
        areaAvailableCommdInfos.add(areaAvailableCommdBO_busi);
        commdDetailsBO_busi.setAreaAvailableCommdInfos(areaAvailableCommdInfos);
        ArrayList commdStockInfo = new ArrayList();
        CommdStockBO_busi commdStockBO_busi = new CommdStockBO_busi();
        commdStockBO_busi.setSkuId(reqBO.getSkuId().toString());
        commdStockBO_busi.setRemainNum(Integer.valueOf(uccTmCommdQryRspBO.getStock().intValue()));
        commdDetailsBO_busi.setCommdStockInfo(commdStockInfo);
        ESupermarketCommdBO commdInfo = new ESupermarketCommdBO();
        NotJdCommdDetailsBO_busi notJdCommdDetailsBO_busi = new NotJdCommdDetailsBO_busi();
        notJdCommdDetailsBO_busi.setImagePath(uccTmCommdQryRspBO.getMainPicUrl());
        notJdCommdDetailsBO_busi.setName(uccTmCommdQryRspBO.getItemTitle());
        notJdCommdDetailsBO_busi.setIntroduction(uccTmCommdQryRspBO.getDescPath());
        if (uccTmCommdQryRspBO.getIsPost() == 1) {
            uccCommodityPo.setFreeFhipping(1);
        } else {
            uccCommodityPo.setFreeFhipping(0);
        }
        uccCommodityPo.setPostFee(uccTmCommdQryRspBO.getPostFee());
        commdInfo.setNotJdCommdDetails(notJdCommdDetailsBO_busi);
        commdDetailsBO_busi.setCommdInfo(commdInfo);
        CommdPriceBO_busi commdPriceInfo = new CommdPriceBO_busi();
        ArrayList<NotJdPriceBO_busi> notJdPriceBO_busis = new ArrayList<NotJdPriceBO_busi>();
        NotJdPriceBO_busi notJdPriceBO_busi = new NotJdPriceBO_busi();
        notJdPriceBO_busi.setEcPrice(uccTmCommdQryRspBO.getOriginalPrice());
        notJdPriceBO_busi.setPrice(uccTmCommdQryRspBO.getCurrentPrice());
        notJdPriceBO_busi.setSkuId(reqBO.getSkuId().toString());
        notJdPriceBO_busis.add(notJdPriceBO_busi);
        commdPriceInfo.setNotJdPriceInfo(notJdPriceBO_busis);
        commdDetailsBO_busi.setCommdPriceInfo(commdPriceInfo);
        ArrayList<CommdShufflingPicBO_busi> commdShufflingPicInfos = new ArrayList<CommdShufflingPicBO_busi>();
        CommdShufflingPicBO_busi commdShufflingPicBO_busi = new CommdShufflingPicBO_busi();
        ArrayList<NotJdCommdPicBO_busi> notJdCommdPicBO_busis = new ArrayList<NotJdCommdPicBO_busi>();
        if (StringUtils.isNotEmpty((CharSequence)uccTmCommdQryRspBO.getItemImages())) {
            String[] imgs;
            for (String img : imgs = uccTmCommdQryRspBO.getItemImages().split(",")) {
                NotJdCommdPicBO_busi notJdCommdPicBO_busi = new NotJdCommdPicBO_busi();
                notJdCommdPicBO_busi.setPath(img);
                notJdCommdPicBO_busis.add(notJdCommdPicBO_busi);
            }
        }
        commdShufflingPicBO_busi.setNotJdCommdPicInfo(notJdCommdPicBO_busis);
        commdShufflingPicInfos.add(commdShufflingPicBO_busi);
        commdDetailsBO_busi.setCommdShufflingPicInfos(commdShufflingPicInfos);
        rspBo.setCommdDetailsInfo(commdDetailsBO_busi);
        return rspBo;
    }
}

