/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.tydic.commodity.ability.api.UccExpectDeliveryTimeQueryAbilityService;
import com.tydic.commodity.atom.UccExpectDeliveryTimeQueryAtomService;
import com.tydic.commodity.atom.bo.UccExpectDeliveryTimeQueryAtomReqBo;
import com.tydic.commodity.atom.bo.UccExpectDeliveryTimeQueryAtomRspBo;
import com.tydic.commodity.bo.ability.UccExpectDeliveryTimeQueryAbilityReqBo;
import com.tydic.commodity.bo.ability.UccExpectDeliveryTimeQueryAbilityRspBo;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.ability.api.UccExpectDeliveryTimeQueryAbilityService"})
public class UccExpectDeliveryTimeQueryAbilityServiceImpl
implements UccExpectDeliveryTimeQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccExpectDeliveryTimeQueryAbilityServiceImpl.class);
    @Autowired
    private UccExpectDeliveryTimeQueryAtomService uccExpectDeliveryTimeQueryAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Value(value="${ESB_QRY_SKU_EXPECT_DELIVERY_TIME}")
    private String url;

    @PostMapping(value={"getExpectDeliveryTime"})
    public UccExpectDeliveryTimeQueryAbilityRspBo getExpectDeliveryTime(@RequestBody UccExpectDeliveryTimeQueryAbilityReqBo reqBo) {
        SupplierBusiPo supplierBusiPo;
        SupplierShopPo supplierShopPo;
        UccExpectDeliveryTimeQueryAbilityRspBo rspBo = new UccExpectDeliveryTimeQueryAbilityRspBo();
        String s = this.checkReq(reqBo);
        if (!StringUtils.isEmpty((Object)s)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(s);
            return rspBo;
        }
        String extSkuId = "";
        if (reqBo.getSkuId() != null) {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(reqBo.getSkuId());
            uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
            List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
            if (!CollectionUtils.isEmpty(uccSkuPos)) {
                extSkuId = uccSkuPos.get(0).getExtSkuId();
            } else {
                throw new BusinessException("8888", "\u8f93\u5165\u5355\u54c1\u4fe1\u606f\u6709\u8bef");
            }
        }
        Long supplierId = null;
        String supplierCode = "";
        if (reqBo.getSupplierShopId() != null && (supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId())) != null && (supplierBusiPo = this.supplierMapper.selectSupplierById(supplierShopPo.getSupplierId())) != null) {
            supplierId = supplierBusiPo.getSupplierId();
            supplierCode = supplierBusiPo.getSupplierCode();
        }
        try {
            UccExpectDeliveryTimeQueryAtomReqBo uccExpectDeliveryTimeQueryAtomReqBo = new UccExpectDeliveryTimeQueryAtomReqBo();
            BeanUtils.copyProperties((Object)reqBo, (Object)uccExpectDeliveryTimeQueryAtomReqBo);
            uccExpectDeliveryTimeQueryAtomReqBo.setUrl(this.url);
            uccExpectDeliveryTimeQueryAtomReqBo.setSkuId(extSkuId);
            uccExpectDeliveryTimeQueryAtomReqBo.setSupplierId(supplierId);
            uccExpectDeliveryTimeQueryAtomReqBo.setSupplierCode(supplierCode);
            UccExpectDeliveryTimeQueryAtomRspBo uccExpectDeliveryTimeQueryAtomRspBo = this.uccExpectDeliveryTimeQueryAtomService.getExpectDeliveryTime(uccExpectDeliveryTimeQueryAtomReqBo);
            BeanUtils.copyProperties((Object)((Object)uccExpectDeliveryTimeQueryAtomRspBo), (Object)rspBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        return rspBo;
    }

    private String checkReq(UccExpectDeliveryTimeQueryAbilityReqBo reqBo) {
        String s = "";
        if (reqBo.getSupplierShopId() == null) {
            s = "\u8bf7\u8f93\u5165\u5e97\u94faID";
        }
        if (reqBo.getSkuId() == null) {
            s = "\u8bf7\u8f93\u5165\u5355\u54c1ID";
        }
        if (StringUtils.isEmpty((Object)reqBo.getNum())) {
            s = "\u8bf7\u8f93\u5165\u6570\u91cf";
        }
        return s;
    }
}

