/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.ability.api.UccPriceCompareAbilityService;
import com.tydic.commodity.bo.ability.UccPriceCompareAbilityListReqBO;
import com.tydic.commodity.bo.ability.UccPriceCompareAbilityReqBO;
import com.tydic.commodity.bo.ability.UccPriceCompareAbilityRspBO;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPriceCompareMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccCommodityPriceComparePO;
import com.tydic.commodity.dao.po.UccSkuPo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.ability.api.UccPriceCompareAbilityService"})
public class UccPriceCompareAbilityServiceImpl
implements UccPriceCompareAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccPriceCompareAbilityServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccCommodityPriceCompareMapper uccCommodityPriceCompareMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    private Sequence sequenceUtil = Sequence.getInstance();

    @PostMapping(value={"qryAndAddUccPriceCompareAbility"})
    public UccPriceCompareAbilityRspBO qryAndAddUccPriceCompareAbility(@RequestBody UccPriceCompareAbilityListReqBO reqBO) {
        UccPriceCompareAbilityRspBO rspBO = new UccPriceCompareAbilityRspBO();
        log.info("\u722c\u53d6\u7535\u5546\u4ef7\u683c\u5165\u53c2\uff1a" + com.alibaba.fastjson.JSONObject.toJSONString((Object)reqBO));
        rspBO.setRespCode("8888");
        if (null == reqBO) {
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        for (UccPriceCompareAbilityReqBO bo : reqBO.getListParam()) {
            UccSkuPo skuPo = new UccSkuPo();
            skuPo.setSkuId(bo.getSkuId());
            skuPo.setSupplierShopId(bo.getSupplierShopId());
            List<UccSkuPo> skuPoList = this.uccSkuMapper.qerySku(skuPo);
            Long vendorPrice = null;
            if (skuPoList.size() == 0) {
                rspBO.setRespDesc("\u67e5\u8be2\u4e0d\u5230\u5355\u54c1\u76f8\u5173\u4fe1\u606f");
                return rspBO;
            }
            SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(skuPoList.get(0).getSupplierShopId());
            BigDecimal result = UccPriceCompareAbilityServiceImpl.send(supplierShopPo.getSupplierName(), skuPoList.get(0).getExtSkuId());
            if (null == result) {
                log.info("\u7535\u5546skuId\uff1a" + skuPoList.get(0).getExtSkuId());
                log.info("\u7535\u5546\u540d\u79f0\uff1a" + supplierShopPo.getSupplierName());
                rspBO.setRespDesc("\u67e5\u8be2\u4e0d\u5230\u6b64\u5546\u54c1\u7684\u7535\u89c6\u4ef7\u683c");
                return rspBO;
            }
            vendorPrice = result.multiply(new BigDecimal(10000)).longValue();
            UccCommodityPriceComparePO po = new UccCommodityPriceComparePO();
            Long id = this.sequenceUtil.nextId();
            po.setId(id);
            try {
                LocalDate nowTime = LocalDate.now();
                int year = nowTime.getYear();
                int month = nowTime.get(ChronoField.MONTH_OF_YEAR);
                int day = nowTime.get(ChronoField.DAY_OF_MONTH);
                Random r = new Random();
                String time = String.valueOf(year) + String.valueOf(month) + String.valueOf(day);
                po.setCompareId(new Long(time + Math.abs(r.nextInt())));
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u5bf9\u6bd4\u5355\u53f7\u9519\u8bef\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u751f\u6210\u5bf9\u6bd4\u5355\u53f7\u9519\u8bef:" + e.getMessage());
            }
            po.setSource(1);
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.qryCommdByCommdId(skuPoList.get(0).getCommodityId(), bo.getSupplierShopId());
            if (null == uccCommodityPo) {
                rspBO.setRespDesc("\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u76f8\u5173\u4fe1\u606f");
                return rspBO;
            }
            po.setCommodityName(uccCommodityPo.getCommodityName());
            po.setCommodityCode(uccCommodityPo.getCommodityCode());
            po.setCommodityTypeId(uccCommodityPo.getCommodityTypeId());
            po.setVendorPrice(vendorPrice);
            po.setSkuPrice(skuPoList.get(0).getSkuPrice());
            po.setBrand(skuPoList.get(0).getBrandName());
            po.setVendor(bo.getSupplierShopId());
            po.setCreateNo(bo.getUsername());
            po.setCreateTime(new Date());
            try {
                this.uccCommodityPriceCompareMapper.insert(po);
            }
            catch (Exception e) {
                log.error("\u5bf9\u6bd4\u4ef7\u683c\u4fe1\u606f\u5199\u5165\u5931\u8d25\uff1a" + e.getMessage());
                throw new ZTBusinessException("\u5bf9\u6bd4\u4ef7\u683c\u4fe1\u606f\u5199\u5165\u5931\u8d25:" + e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bf9\u6bd4\u4ef7\u683c\u4fe1\u606f\u5199\u5165\u6210\u529f");
        return rspBO;
    }

    private static BigDecimal send(String businessName, String skuId) {
        switch (businessName) {
            case "\u4eac\u4e1c": {
                return UccPriceCompareAbilityServiceImpl.sendGetJingdong("http://p.3.cn/prices/mgets?skuIds=J_" + skuId);
            }
            case "\u5f97\u529b": {
                return UccPriceCompareAbilityServiceImpl.sendGetDeli("https://b2b.nbdeli.com/Goods/ItemDetail_" + skuId + "_40.htm", skuId);
            }
            case "\u897f\u57df": {
                return UccPriceCompareAbilityServiceImpl.sendGetXiyu("http://www.ehsy.com/product-" + skuId);
            }
            case "\u4f01\u4e8b\u901a": {
                return UccPriceCompareAbilityServiceImpl.sendGetQst("https://mall.qstbg.com/gd/detail.do?goods_id=" + skuId);
            }
        }
        return null;
    }

    private static BigDecimal sendGetJingdong(String urlName) {
        String result = "";
        Object priceStr = null;
        try {
            String line;
            URL realURL = new URL(urlName);
            URLConnection conn = realURL.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 Safari/537.36");
            conn.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            while ((line = in.readLine()) != null) {
                result = result + "\n" + line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            JSONArray dataArray = new JSONArray(result.toString());
            JSONObject dataJsonObj = dataArray.getJSONObject(0);
            priceStr = dataJsonObj.get("p");
            if (StringUtils.isEmpty((Object)priceStr)) {
                return null;
            }
            log.info("\u4ef7\u683c\uff1a" + priceStr);
        }
        catch (Exception e) {
            log.info("\u4eac\u4e1c\u6570\u636e\u89e3\u6790\u9519\u8bef\uff1a" + e.getMessage());
        }
        return new BigDecimal((String)priceStr);
    }

    private static BigDecimal sendGetSuning(String url) {
        String price = null;
        try {
            Document document = Jsoup.parse((URL)new URL(url), (int)30000);
            price = document.select("#cart2Price").text();
            log.info("\u4ef7\u683c\uff1a" + price);
        }
        catch (Exception e) {
            log.info("\u82cf\u5b81\u6570\u636e\u89e3\u6790\u9519\u8bef\uff1a" + e.getMessage());
        }
        return new BigDecimal(price);
    }

    private static BigDecimal sendGetXiyu(String url) {
        String price = null;
        try {
            Document document = Jsoup.parse((URL)new URL(url), (int)30000);
            price = ((Element)document.select("div>span").select(".show-price").get(0)).text();
            price = price.substring(2, price.length());
            log.info("\u4ef7\u683c\uff1a" + price);
            if (StringUtils.isEmpty((Object)price)) {
                return null;
            }
        }
        catch (Exception e) {
            log.info("\u897f\u57df\u6570\u636e\u722c\u53d6\u9519\u8bef\uff1a" + e.getMessage());
        }
        return new BigDecimal(price);
    }

    private static BigDecimal sendGetDeli(String url, String skuId) {
        String price = null;
        try {
            Document document = Jsoup.parse((URL)new URL(url), (int)30000);
            String id = "ItemPrice" + skuId;
            price = ((Element)document.select("#" + id).get(0)).text();
            log.info("\u4ef7\u683c\uff1a" + price);
            if (StringUtils.isEmpty((Object)price)) {
                return null;
            }
        }
        catch (Exception e) {
            log.info("\u5f97\u529b\u6570\u636e\u722c\u53d6\u9519\u8bef\uff1a" + e.getMessage());
        }
        return new BigDecimal(price);
    }

    private static BigDecimal sendGetQst(String url) {
        String price = null;
        try {
            Document document = Jsoup.parse((URL)new URL(url), (int)30000);
            price = document.select("#totalPrice").text();
            log.info("\u4ef7\u683c\uff1a" + price);
            if (StringUtils.isEmpty((Object)price)) {
                return null;
            }
        }
        catch (Exception e) {
            log.info("\u4f01\u4e8b\u901a\u6570\u636e\u722c\u53d6\u9519\u8bef\uff1a" + e.getMessage());
        }
        return new BigDecimal(price);
    }
}

