/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccCreateUserOperRecordAtomService;
import com.tydic.commodity.atom.bo.UccCreateUserOperRecordAtomReqBO;
import com.tydic.commodity.atom.bo.UccCreateUserOperRecordAtomRspBO;
import com.tydic.commodity.atom.bo.UccUserOperInfoCreateBO;
import com.tydic.commodity.dao.UccSkuOperRecordMapper;
import com.tydic.commodity.dao.po.UccSkuOperRecordPO;
import com.tydic.commodity.enumType.SkuOperTypeEnum;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccCreateUserOperRecordAtomServiceImpl
implements UccCreateUserOperRecordAtomService {
    @Autowired
    private UccSkuOperRecordMapper uccSkuOperRecordMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccCreateUserOperRecordAtomRspBO createUserOperRecord(UccCreateUserOperRecordAtomReqBO reqBo) {
        UccCreateUserOperRecordAtomRspBO rspBo = new UccCreateUserOperRecordAtomRspBO();
        if (null == reqBo || CollectionUtils.isEmpty(reqBo.getUserOperInfoList())) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u3001\u64cd\u4f5c\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Set operTypes = Arrays.stream(SkuOperTypeEnum.values()).map(SkuOperTypeEnum::getOperType).collect(Collectors.toSet());
        for (UccUserOperInfoCreateBO userOperInfoCreateBo : reqBo.getUserOperInfoList()) {
            if (null == userOperInfoCreateBo.getOperType() || null == userOperInfoCreateBo.getCommodityId()) {
                throw new BusinessException("8888", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u3001\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!operTypes.contains(userOperInfoCreateBo.getOperType())) {
                throw new BusinessException("8888", "\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
            }
            if (!StringUtils.hasText((String)userOperInfoCreateBo.getCreateOper())) {
                userOperInfoCreateBo.setCreateOper(reqBo.getMemNickName());
            }
            if (!StringUtils.hasText((String)userOperInfoCreateBo.getCreateOperName())) {
                userOperInfoCreateBo.setCreateOperName(reqBo.getUsername());
            }
            if (null != userOperInfoCreateBo.getCreateTime()) continue;
            userOperInfoCreateBo.setCreateTime(new Date());
        }
        ArrayList<UccSkuOperRecordPO> operRecordList = new ArrayList<UccSkuOperRecordPO>();
        reqBo.getUserOperInfoList().forEach(operInfo -> {
            UccSkuOperRecordPO uccSkuOperRecordPo = new UccSkuOperRecordPO();
            uccSkuOperRecordPo.setRecordId(this.sequence.nextId());
            uccSkuOperRecordPo.setSkuId(operInfo.getSkuId());
            uccSkuOperRecordPo.setCommodityId(operInfo.getCommodityId());
            uccSkuOperRecordPo.setOperType(operInfo.getOperType());
            uccSkuOperRecordPo.setCreateOperId(operInfo.getCreateOper());
            uccSkuOperRecordPo.setCreateOperName(operInfo.getCreateOperName());
            uccSkuOperRecordPo.setCreateTime(operInfo.getCreateTime());
            uccSkuOperRecordPo.setRemark(operInfo.getRemark());
            operRecordList.add(uccSkuOperRecordPo);
        });
        this.uccSkuOperRecordMapper.insertBatch(operRecordList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

