/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.ApprovalAuthorBO;
import com.tydic.commodity.bo.busi.ApprovalCommoAuthor;
import com.tydic.commodity.busi.api.ApprovalCommoAuthorService;
import com.tydic.commodity.dao.UccApprovalConfigMapper;
import com.tydic.commodity.dao.po.ApprovalConfigPO;
import com.tydic.commodity.enumType.ApprovalCommoAuthDetailEnum;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.ApprovalCommoAuthorService"})
public class ApprovalCommoAuthorServiceImpl
implements ApprovalCommoAuthorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApprovalCommoAuthorServiceImpl.class);
    @Autowired
    private UccApprovalConfigMapper approvalConfigMapper;

    @PostMapping(value={"getApprovalRoleAuth"})
    public ApprovalCommoAuthor getApprovalRoleAuth(@RequestBody List<String> code) {
        HashMap map = new HashMap();
        List<ApprovalConfigPO> approvalConfigPOList = null;
        ArrayList approvalConfigPOS = Lists.newArrayList();
        for (String string : code) {
            ApprovalConfigPO approvalConfigPO = new ApprovalConfigPO();
            approvalConfigPO.setApprovalPost(string);
            approvalConfigPOS.add(approvalConfigPO);
        }
        try {
            approvalConfigPOList = this.approvalConfigMapper.selectByApprovalListCode(approvalConfigPOS);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5f02\u5e38:" + e);
            throw new BusinessException("8888", "\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty(approvalConfigPOList)) {
            LOGGER.error("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u6570\u636e\u5b57\u5178,code:" + code);
            return null;
        }
        ArrayList<String> step = new ArrayList<String>(approvalConfigPOList.size());
        for (ApprovalConfigPO configPO : approvalConfigPOList) {
            step.add(configPO.getApprovalStatus());
        }
        map.put(ApprovalCommoAuthDetailEnum.APPROVAL_LEVEL.code(), step);
        ApprovalCommoAuthor approvalCommoAuthor = new ApprovalCommoAuthor(map);
        return approvalCommoAuthor;
    }

    @PostMapping(value={"getApprovalStepAuth"})
    public ApprovalAuthorBO getApprovalStepAuth(@RequestBody ApprovalCommoAuthor approvalCommoAuthor) {
        if (approvalCommoAuthor.getMap() == null || approvalCommoAuthor.getMap().isEmpty()) {
            return null;
        }
        Map objectMap = approvalCommoAuthor.getMap();
        ApprovalAuthorBO approvalAuthorBO = new ApprovalAuthorBO();
        approvalAuthorBO.setStep((List)objectMap.get(ApprovalCommoAuthDetailEnum.APPROVAL_LEVEL.code()));
        return approvalAuthorBO;
    }
}

