/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.CommodityCheckNotPassBO;
import com.tydic.commodity.bo.busi.CommodityCheckPassBO;
import com.tydic.commodity.bo.busi.DealCommoApprovalLevelBO;
import com.tydic.commodity.bo.busi.SendNextCommoDealDetail;
import com.tydic.commodity.bo.busi.UccExaminationApprovalReqBO;
import com.tydic.commodity.bo.busi.UccExaminationApprovalRspBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.busi.api.DealCommoApprovalLevelService;
import com.tydic.commodity.busi.api.UccExaminationApprovalBusiService;
import com.tydic.commodity.dao.UccCommodityDetailMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.UccCommodityDetailPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.UacNoTaskAuditOrderSyncAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderSyncReqBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.DealCommoApprovalLevelService"})
public class DealCommoApprovalLevelServiceImpl
implements DealCommoApprovalLevelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DealCommoApprovalLevelServiceImpl.class);
    @Autowired
    private BatchUpdateCommoStatusForMarketService batchUpdateCommoStatusForMarketService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService auditCreateListAbilityService;
    @Autowired
    private UccExaminationApprovalBusiService approvalBusiService;
    @Value(value="${PROCESS_DEF_ID}")
    private String processDefId;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityDetailMapper uccCommodityDetailMapper;
    @Autowired
    private UacNoTaskAuditOrderSyncAbilityService uocAuditOrderSyncAbilityService;

    @PostMapping(value={"dealRejectDetail"})
    public void dealRejectDetail(@RequestBody DealCommoApprovalLevelBO dealCommoApprovalLevelBO) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dealCommoApprovalLevelBO.getNotPassCommodity())) {
            return;
        }
        BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = null;
        Long[] commodityIds = new Long[1];
        for (int i = 0; i < dealCommoApprovalLevelBO.getNotPassCommodity().size(); ++i) {
            batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
            batchUpdateCommoStatusForMarketBO.setReason(((CommodityCheckNotPassBO)dealCommoApprovalLevelBO.getNotPassCommodity().get(i)).getNotPassReason());
            commodityIds[0] = ((CommodityCheckNotPassBO)dealCommoApprovalLevelBO.getNotPassCommodity().get(i)).getCommodityId();
            batchUpdateCommoStatusForMarketBO.setBusinessId(commodityIds);
            try {
                this.batchUpdateCommoStatusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.REJECT_STATUS, SkuStatusEnum.REJECT_STATUS);
                continue;
            }
            catch (BusinessException e) {
                LOGGER.error("\u5546\u54c1\u6821\u9a8c\u5931\u8d25\uff0c\u76f4\u63a5\u9a73\u56de\uff0c\u5931\u8d25", (Throwable)e);
                throw new BusinessException("8888", e.getMsgInfo());
            }
        }
    }

    @PostMapping(value={"dealSendNextCommoDealDetail"})
    public UccExaminationApprovalRspBO dealSendNextCommoDealDetail(@RequestBody DealCommoApprovalLevelBO dealCommoApprovalLevelBO) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dealCommoApprovalLevelBO.getSendNextCommoDealDetail())) {
            return null;
        }
        UccExaminationApprovalReqBO uccExaminationApprovalReqBO = new UccExaminationApprovalReqBO();
        uccExaminationApprovalReqBO.setOperId(dealCommoApprovalLevelBO.getOperId());
        uccExaminationApprovalReqBO.setSupplierId(dealCommoApprovalLevelBO.getSupplierId());
        Long[] business = new Long[dealCommoApprovalLevelBO.getSendNextCommoDealDetail().size()];
        for (int i = 0; i < dealCommoApprovalLevelBO.getSendNextCommoDealDetail().size(); ++i) {
            business[i] = ((SendNextCommoDealDetail)dealCommoApprovalLevelBO.getSendNextCommoDealDetail().get(i)).getCommodityId();
        }
        uccExaminationApprovalReqBO.setBusinessId(business);
        UccExaminationApprovalRspBO uccExaminationApprovalRspBO = this.approvalBusiService.dealExaminationApproval(uccExaminationApprovalReqBO);
        return uccExaminationApprovalRspBO;
    }

    @PostMapping(value={"dealDirectUpperShelf"})
    public void dealDirectUpperShelf(@RequestBody DealCommoApprovalLevelBO dealCommoApprovalLevelBO) {
        LOGGER.info("\u5ba1\u6838\u76f4\u63a5\u4e0a\u67b6\u6570\u636e\uff1a" + JSON.toJSON((Object)dealCommoApprovalLevelBO));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dealCommoApprovalLevelBO.getPassCommodity())) {
            return;
        }
        BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
        Long[] business = new Long[dealCommoApprovalLevelBO.getPassCommodity().size()];
        for (int i = 0; i < dealCommoApprovalLevelBO.getPassCommodity().size(); ++i) {
            CommodityBo commodityBo = new CommodityBo();
            business[i] = ((CommodityCheckPassBO)dealCommoApprovalLevelBO.getPassCommodity().get(i)).getCommodityId();
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(((CommodityCheckPassBO)dealCommoApprovalLevelBO.getPassCommodity().get(i)).getCommodityId());
            UccCommodityDetailPo uccCommodityDetailPo = this.uccCommodityDetailMapper.getCommodityById(((CommodityCheckPassBO)dealCommoApprovalLevelBO.getPassCommodity().get(i)).getCommodityId());
            BeanUtils.copyProperties((Object)uccCommodityPo, (Object)commodityBo);
            if (null != uccCommodityDetailPo) {
                BeanUtils.copyProperties((Object)uccCommodityDetailPo, (Object)commodityBo);
            }
            commodityBo.setApprovalStatus("0");
            this.batchUpdateCommoStatusForMarketService.updateCommoApprovalStatus(commodityBo, AuditResultStatusEnum.Audit_Up_Shelf);
        }
        batchUpdateCommoStatusForMarketBO.setBusinessId(business);
        batchUpdateCommoStatusForMarketBO.setReason("\u53ef\u4ee5\u4e0a\u7684\u5546\u54c1\u7c7b\u578b");
        this.batchUpdateCommoStatusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.EFFECTIVE_STATUS, SkuStatusEnum.ON_SHELVES_STATUS);
    }

    @PostMapping(value={"dealInitiateApproval"})
    public void dealInitiateApproval(@RequestBody DealCommoApprovalLevelBO dealCommoApprovalLevelBO) {
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO;
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dealCommoApprovalLevelBO.getSendNextCommoDealDetail())) {
            return;
        }
        BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
        Long[] business = new Long[dealCommoApprovalLevelBO.getSendNextCommoDealDetail().size()];
        ArrayList listBusiReqBOS = Lists.newArrayList();
        List<Long> commdIds = dealCommoApprovalLevelBO.getSendNextCommoDealDetail().stream().map(CommodityCheckPassBO::getCommodityId).collect(Collectors.toList());
        List<UccCommodityPo> commodityPoList = this.uccCommodityMapper.qeryBatchCommdity(commdIds);
        if (CollectionUtils.isEmpty(commodityPoList)) {
            LOGGER.error("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5546\u54c1\u4e0d\u5b58\u5728");
            throw new BusinessException("8888", "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        Map<Long, Long> commdShop = commodityPoList.stream().collect(Collectors.toMap(UccCommodityPo::getCommodityId, UccCommodityPo::getSupplierShopId));
        for (int i = 0; i < dealCommoApprovalLevelBO.getSendNextCommoDealDetail().size(); ++i) {
            if (!commdShop.containsKey(((SendNextCommoDealDetail)dealCommoApprovalLevelBO.getSendNextCommoDealDetail().get(i)).getCommodityId())) {
                LOGGER.error("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5546\u54c1\u4e0d\u5b58\u5728" + ((SendNextCommoDealDetail)dealCommoApprovalLevelBO.getSendNextCommoDealDetail().get(i)).getCommodityId());
                continue;
            }
            ArrayList approvalObjBOS = Lists.newArrayList();
            ApprovalObjBO approvalObjBO = new ApprovalObjBO();
            approvalObjBO.setObjId(String.valueOf(((SendNextCommoDealDetail)dealCommoApprovalLevelBO.getSendNextCommoDealDetail().get(i)).getCommodityId()));
            approvalObjBO.setOrderId(commdShop.get(((SendNextCommoDealDetail)dealCommoApprovalLevelBO.getSendNextCommoDealDetail().get(i)).getCommodityId()));
            approvalObjBOS.add(approvalObjBO);
            UacNoTaskAuditCreateInfoReqBO auditOrderCreateListBusiReqBO = new UacNoTaskAuditCreateInfoReqBO();
            auditOrderCreateListBusiReqBO.setApprovalObjInfo((List)approvalObjBOS);
            auditOrderCreateListBusiReqBO.setObjNum(String.valueOf(approvalObjBOS.size()));
            auditOrderCreateListBusiReqBO.setObjType(Integer.valueOf(2));
            auditOrderCreateListBusiReqBO.setOrderId(commdShop.get(((SendNextCommoDealDetail)dealCommoApprovalLevelBO.getSendNextCommoDealDetail().get(i)).getCommodityId()));
            listBusiReqBOS.add(auditOrderCreateListBusiReqBO);
            business[i] = ((SendNextCommoDealDetail)dealCommoApprovalLevelBO.getSendNextCommoDealDetail().get(i)).getCommodityId();
        }
        UacNoTaskAuditCreateReqBO uocAuditAbiltyCreateListReqBO = new UacNoTaskAuditCreateReqBO();
        uocAuditAbiltyCreateListReqBO.setCreateBusiReqBO((List)listBusiReqBOS);
        uocAuditAbiltyCreateListReqBO.setProcDefKey(this.processDefId);
        try {
            LOGGER.info("\u521b\u5efa\u5ba1\u6279\u5355\u6570\u636euocAuditAbiltyCreateListReqBO \uff1a" + JSON.toJSON((Object)uocAuditAbiltyCreateListReqBO));
            uacNoTaskAuditCreateRspBO = this.auditCreateListAbilityService.auditOrderCreate(uocAuditAbiltyCreateListReqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
            throw new BusinessException("8888", "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        for (int i = 0; i < dealCommoApprovalLevelBO.getSendNextCommoDealDetail().size(); ++i) {
            CommodityBo commodityBo = new CommodityBo();
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(((SendNextCommoDealDetail)dealCommoApprovalLevelBO.getSendNextCommoDealDetail().get(i)).getCommodityId());
            BeanUtils.copyProperties((Object)uccCommodityPo, (Object)commodityBo);
            commodityBo.setApprovalStatus(uacNoTaskAuditCreateRspBO.getStepId());
            this.batchUpdateCommoStatusForMarketService.updateCommoApprovalStatus(commodityBo, AuditResultStatusEnum.Audit_Pass);
        }
        batchUpdateCommoStatusForMarketBO.setBusinessId(business);
        batchUpdateCommoStatusForMarketBO.setReason("\u521b\u5efa\u5ba1\u6279\u5355");
        batchUpdateCommoStatusForMarketBO.setOperId(dealCommoApprovalLevelBO.getOperId());
        this.batchUpdateCommoStatusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.PENDING_APPROVAL_STATUS, SkuStatusEnum.PENDING_APPROVAL_STATUS);
        if (dealCommoApprovalLevelBO.getRestoreShelfe().booleanValue()) {
            UacNoTaskAuditOrderSyncReqBO uocAuditOrderSyncReqBO = new UacNoTaskAuditOrderSyncReqBO();
            uocAuditOrderSyncReqBO.setObjType(Integer.valueOf(2));
            uocAuditOrderSyncReqBO.setAuditAdvice(dealCommoApprovalLevelBO.getReason());
            uocAuditOrderSyncReqBO.setDownload(null);
            uocAuditOrderSyncReqBO.setStepId(ApprovalTypeEnum.RESTORE_UP_SHELF.getStep());
            uocAuditOrderSyncReqBO.setStepName(ApprovalTypeEnum.RESTORE_UP_SHELF.code());
            uocAuditOrderSyncReqBO.setStepDesc(ApprovalTypeEnum.RESTORE_UP_SHELF.getMessage());
            uocAuditOrderSyncReqBO.setOperid(dealCommoApprovalLevelBO.getOperId());
            uocAuditOrderSyncReqBO.setObjId(Arrays.asList(business).stream().map(a -> String.valueOf(a)).collect(Collectors.toList()));
            HashMap<String, String> ext = new HashMap<String, String>();
            ext.put("dealStepName", "\u6062\u590d\u4e0a\u67b6");
            uocAuditOrderSyncReqBO.setExt(ext);
            this.uocAuditOrderSyncAbilityService.dealAuditOrderSync(uocAuditOrderSyncReqBO);
        }
    }
}

