/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccAddPropGrpReqBO;
import com.tydic.commodity.bo.busi.UccAddPropGrpRspBO;
import com.tydic.commodity.busi.api.UccAddPropGroupBusiService;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.po.UccCommodityPropGrpPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.enumType.CommodityPropGrpEnum;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccAddPropGroupBusiService"})
public class UccAddPropGroupBusiServiceImpl
implements UccAddPropGroupBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAddPropGroupBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private Sequence uccBrandSequence = Sequence.getInstance();

    @PostMapping(value={"addGroup"})
    public UccAddPropGrpRspBO addGroup(@RequestBody UccAddPropGrpReqBO reqBO) {
        UccAddPropGrpRspBO rspBO = new UccAddPropGrpRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        Page grpPage = new Page();
        UccCommodityPropGrpPo uccCommodityPropGrpPo = new UccCommodityPropGrpPo();
        uccCommodityPropGrpPo.setCommodityPropGrpCode(reqBO.getCommodityPropGrpCode());
        List<UccCommodityPropGrpPo> listPo = this.uccCommodityPropGrpMapper.queryGroup((Page<UccCommodityPropGrpPo>)grpPage, uccCommodityPropGrpPo);
        if (listPo != null && listPo.size() > 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u7f16\u7801:" + reqBO.getCommodityPropGrpCode() + "\u5df2\u5b58\u5728");
            return rspBO;
        }
        UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId());
        if (uccCommodityTypePo == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5546\u54c1\u7c7b\u578bID:" + reqBO.getCommodityTypeId());
            return rspBO;
        }
        UccCommodityPropGrpPo po = new UccCommodityPropGrpPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        int count = 0;
        try {
            po.setCommodityPropGrpId(this.uccBrandSequence.nextId());
            count = this.uccCommodityPropGrpMapper.addGroup(po);
        }
        catch (Exception e) {
            LOGGER.error("\u5c5e\u6027\u7ec4\u65b0\u589e\u5931\u8d25\uff1a" + e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u65b0\u589e\u5931\u8d25");
            return rspBO;
        }
        if (count < 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u65b0\u589e\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5c5e\u6027\u7ec4\u65b0\u589e\u6210\u529f");
        rspBO.setCommodityPropGrpId(po.getCommodityPropGrpId());
        return rspBO;
    }

    private String verify(UccAddPropGrpReqBO reqBO) {
        String errMsg = "";
        if (StringUtils.isEmpty((CharSequence)reqBO.getCommodityPropGrpCode())) {
            errMsg = "\u5c5e\u6027\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCommodityPropGrpName())) {
            errMsg = "\u5c5e\u6027\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getCommodityTypeId() == null || reqBO.getCommodityTypeId() == 0L) {
            errMsg = "\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("".equals(errMsg)) {
            errMsg = this.enumVerify(reqBO);
        }
        return errMsg;
    }

    private String enumVerify(UccAddPropGrpReqBO reqBO) {
        String errMsg = "";
        Map<String, String> map = null;
        if (reqBO.getCommodityPropGrpType() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropGrpEnum.COMMODITY_PROP_GRP_TYPE.toString())).containsKey(reqBO.getCommodityPropGrpType().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 commodityPropGrpType";
        }
        if (reqBO.getPropGrpStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropGrpEnum.COMMODITY_PROP_GRP_STATUS.toString())).containsKey(reqBO.getPropGrpStatus().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propTag\u503c";
        }
        return errMsg;
    }
}

