/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccBrandDateBO;
import com.tydic.commodity.bo.busi.UccBrandSelectReqBO;
import com.tydic.commodity.bo.busi.UccBrandSelectRspBO;
import com.tydic.commodity.busi.api.UccBrandSelectBusiService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.enumType.Brand;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccBrandSelectBusiService"})
public class UccBrandSelectBusiServiceImpl
implements UccBrandSelectBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBrandSelectBusiServiceImpl.class);
    @Autowired
    private UccBrandDealMapper mapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    UccBrandSelectRspBO rspBO = new UccBrandSelectRspBO();

    @PostMapping(value={"selectBrand"})
    public UccBrandSelectRspBO selectBrand(@RequestBody UccBrandSelectReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRows(null);
            return this.rspBO;
        }
        this.rspBO = new UccBrandSelectRspBO();
        UccBrandDealPO brandDealPO = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPO);
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        List<UccBrandDealPO> result = null;
        try {
            result = this.mapper.selectBrand(brandDealPO, (Page<UccBrandDealPO>)page);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u67e5\u8be2\u5f02\u5e38");
        }
        if (result != null && result.size() > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u6210\u529f");
            ArrayList<UccBrandDateBO> dataList = new ArrayList<UccBrandDateBO>();
            UccBrandDateBO result1 = null;
            Map<Object, Object> collectByCode = new HashMap(16);
            List<DicDictionaryPo> dicDictionaryPos = this.uccDictionaryAtomService.queryBypCodeBackPo(Brand.BRAND_STATUS.toString());
            if (!CollectionUtils.isEmpty(dicDictionaryPos)) {
                collectByCode = dicDictionaryPos.stream().collect(Collectors.groupingBy(DicDictionaryPo::getCode));
            }
            List<UccBrandDealPO> relSkuIdCount = this.mapper.getRelSkuIdCount(result.stream().map(UccBrandDealPO::getBrandId).collect(Collectors.toList()));
            Map<Object, Object> collectByBrandId = new HashMap(16);
            if (!CollectionUtils.isEmpty(relSkuIdCount)) {
                collectByBrandId = relSkuIdCount.stream().collect(Collectors.groupingBy(UccBrandDealPO::getBrandId));
            }
            for (UccBrandDealPO po : result) {
                List poList;
                result1 = new UccBrandDateBO();
                BeanUtils.copyProperties((Object)po, (Object)result1);
                result1.setCouldDelete(Boolean.valueOf(true));
                List dicDictionaryPoList = (List)collectByCode.get(String.valueOf(po.getBrandStatus()));
                if (!CollectionUtils.isEmpty((Collection)dicDictionaryPoList)) {
                    result1.setBrandStatusTranslation(((DicDictionaryPo)dicDictionaryPoList.get(0)).getTitle());
                }
                if (!(CollectionUtils.isEmpty((Collection)(poList = (List)collectByBrandId.get(po.getBrandId()))) || ((UccBrandDealPO)poList.get(0)).getRelSkuCount() <= 0 && ((UccBrandDealPO)poList.get(0)).getRelGiftCount() <= 0)) {
                    result1.setCouldDelete(Boolean.valueOf(false));
                }
                dataList.add(result1);
            }
            this.rspBO.setPageNo(page.getPageNo());
            this.rspBO.setRecordsTotal(page.getTotalCount());
            this.rspBO.setTotal(page.getTotalPages());
            this.rspBO.setRows(dataList);
        } else {
            this.rspBO.setRows(null);
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u6210\u529f");
        }
        return this.rspBO;
    }

    public boolean judge(UccBrandSelectReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getBrandStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString())).containsKey(String.valueOf(reqBO.getBrandStatus()))) {
            this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u54c1\u724c\u72b6\u6001");
            return false;
        }
        return true;
    }
}

