/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.UccCommodityPicBO;
import com.tydic.commodity.bo.busi.UccCommodityPicReqBO;
import com.tydic.commodity.bo.busi.UccCommodityPicRspBO;
import com.tydic.commodity.busi.api.UccCommodityPicInsertBusiService;
import com.tydic.commodity.busi.api.UccCommodityPicUpdateBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccCommodityPicUpdateBusiService"})
public class UccCommodityPicUpdateBusiServiceImpl
implements UccCommodityPicUpdateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityPicUpdateBusiServiceImpl.class);
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityPicInsertBusiService uccCommodityPicInsertBusiService;
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    @PostMapping(value={"updatePicture"})
    public UccCommodityPicRspBO updatePicture(@RequestBody UccCommodityPicReqBO reqBO) {
        UccCommodityPicRspBO commodityPicRspBO = new UccCommodityPicRspBO();
        try {
            this.judge(reqBO);
        }
        catch (BusinessException e) {
            commodityPicRspBO.setRespCode("8888");
            commodityPicRspBO.setRespDesc(e.getMsgInfo());
            return commodityPicRspBO;
        }
        List<SupplierShopPo> supplierShopPos = null;
        if (null != reqBO.getOrgIdIn()) {
            supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getUccCommodityPicBO())) {
            Long commodityId;
            Long supplierId = null;
            if (CollectionUtils.isNotEmpty(supplierShopPos)) {
                supplierId = supplierShopPos.get(0).getSupplierShopId();
            }
            if (null != (commodityId = ((UccCommodityPicBO)reqBO.getUccCommodityPicBO().get(0)).getCommodityId()) && null != supplierId) {
                this.uccCommodityPicMapper.deleteByCommodityId(commodityId, supplierId);
            }
        }
        try {
            this.uccCommodityPicInsertBusiService.insertPicture(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u5546\u54c1\u4e3b\u56fe\u4fee\u6539\u5931\u8d25:" + e);
            commodityPicRspBO.setRespDesc("\u5546\u54c1\u4e3b\u56fe\u4fee\u6539\u5931\u8d25");
            commodityPicRspBO.setRespCode("8888");
            return commodityPicRspBO;
        }
        commodityPicRspBO.setRespDesc("\u6210\u529f");
        commodityPicRspBO.setRespCode("0000");
        return commodityPicRspBO;
    }

    private void judge(UccCommodityPicReqBO reqBO) {
        try {
            if (CollectionUtils.isEmpty((Collection)reqBO.getUccCommodityPicBO())) {
                throw new BusinessException("8888", "\u5546\u54c1\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (UccCommodityPicBO uccCommodityPicBO : reqBO.getUccCommodityPicBO()) {
                if (uccCommodityPicBO.getCommodityPicId() == null) {
                    throw new BusinessException("8888", "\u5546\u54c1\u56fe\u7247id \u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (uccCommodityPicBO.getCommodityId() == null) {
                    throw new BusinessException("8888", "\u5546\u54c1id \u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (uccCommodityPicBO.getCommodityPicType() == null) {
                    throw new BusinessException("8888", "\u56fe\u7247\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((String)uccCommodityPicBO.getCommodityPicUrl())) {
                    throw new BusinessException("8888", "\u56fe\u7247\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (uccCommodityPicBO.getSupplierShopId() != null) continue;
                throw new BusinessException("8888", "\u5e97\u94faid \u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        catch (BusinessException e) {
            throw new BusinessException(e.getMsgCode(), e.getMsgInfo());
        }
    }
}

