/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccCreateUserOperRecordAtomService;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.atom.UccSkuUpAtomService;
import com.tydic.commodity.atom.bo.UccCreateUserOperRecordAtomReqBO;
import com.tydic.commodity.atom.bo.UccSkuUpReqBO;
import com.tydic.commodity.atom.bo.UccSkuUpRspBO;
import com.tydic.commodity.atom.bo.UccUserOperInfoCreateBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccCommodityUpReqBO;
import com.tydic.commodity.bo.busi.UccCommodityUpRspBO;
import com.tydic.commodity.busi.api.UccCommodityUpBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.SkuOperTypeEnum;
import com.tydic.commodity.enumType.SkuPutCirEnum;
import com.tydic.commodity.external.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccCommodityUpBusiService"})
public class UccCommodityUpBusiServiceImpl
implements UccCommodityUpBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuUpAtomService UccSkuUpAtomService;
    private static final String SHELF_SOURCES = "linkmall";
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityUpBusiServiceImpl.class);
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccCreateUserOperRecordAtomService uccCreateUserOperRecordAtomService;

    @PostMapping(value={"dealCommodityUp"})
    public UccCommodityUpRspBO dealCommodityUp(@RequestBody UccCommodityUpReqBO reqBO) {
        UccCommodityUpRspBO rspBO = new UccCommodityUpRspBO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespDesc(s);
            rspBO.setRespCode("8888");
            return rspBO;
        }
        List skuIds = reqBO.getSkuIds();
        for (Long skuId : skuIds) {
            try {
                UccSkuUpReqBO uccSkuUpReqBO = new UccSkuUpReqBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuUpReqBO);
                uccSkuUpReqBO.setSkuId(skuId);
                UccSkuUpRspBO uccSkuUpRspBO = this.UccSkuUpAtomService.dealSkuUp(uccSkuUpReqBO);
                if ("8888".equals(uccSkuUpRspBO.getRespCode())) {
                    BeanUtils.copyProperties((Object)((Object)uccSkuUpRspBO), (Object)rspBO);
                    return rspBO;
                }
                UccSkuPo po = new UccSkuPo();
                BeanUtils.copyProperties((Object)reqBO, (Object)po);
                List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(po);
                ArrayList<Long> commids = new ArrayList<Long>();
                commids.add(uccSkuPos.get(0).getCommodityId());
                this.syncEs(commids, reqBO.getSupplierShopId());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException("\u8c03\u7528\u5355\u54c1\u4e0a\u67b6\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            }
        }
        this.dealOperRecord(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u4e0a\u67b6\u6210\u529f");
        return rspBO;
    }

    private void dealOperRecord(UccCommodityUpReqBO reqBo) {
        Date now = new Date();
        UccCreateUserOperRecordAtomReqBO uccCreateUserOperRecordAtomReqBo = new UccCreateUserOperRecordAtomReqBO();
        ArrayList<UccUserOperInfoCreateBO> userOperInfoCreateBoList = new ArrayList<UccUserOperInfoCreateBO>();
        reqBo.getSkuIds().forEach(skuId -> {
            UccUserOperInfoCreateBO uccUserOperInfoCreateBo = new UccUserOperInfoCreateBO();
            uccUserOperInfoCreateBo.setCreateOper(reqBo.getMemNickName());
            uccUserOperInfoCreateBo.setCreateOperName(reqBo.getCreateOperId());
            uccUserOperInfoCreateBo.setCreateTime(now);
            uccUserOperInfoCreateBo.setOperType(SkuOperTypeEnum.ON_SHELF_SKU.getOperType());
            uccUserOperInfoCreateBo.setCommodityId((Long)skuId);
            uccUserOperInfoCreateBo.setSkuId((Long)skuId);
            userOperInfoCreateBoList.add(uccUserOperInfoCreateBo);
        });
        uccCreateUserOperRecordAtomReqBo.setUserOperInfoList(userOperInfoCreateBoList);
        this.uccCreateUserOperRecordAtomService.createUserOperRecord(uccCreateUserOperRecordAtomReqBo);
    }

    public String judge(UccCommodityUpReqBO reqBO) {
        String s = "";
        if (reqBO != null) {
            if (reqBO.getSkuIds().size() == 0) {
                s = "\u8bf7\u9009\u62e9\u5355\u54c1";
                return s;
            }
            if (reqBO.getSupplierShopId() == null) {
                s = "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a";
                return s;
            }
            if (!Objects.equals(SHELF_SOURCES, reqBO.getShelfSource())) {
                List skuIds = reqBO.getSkuIds();
                UccSkuPo skuPo = new UccSkuPo();
                skuPo.setSupplierShopId(reqBO.getSupplierShopId());
                for (Long skuId : skuIds) {
                    skuPo.setSkuId(skuId);
                    List<UccSkuPo> skuPos = this.uccSkuMapper.qerySku(skuPo);
                    if (skuPos.size() <= 0 || skuPos.get(0).getSkuStatus() == 2 || skuPos.get(0).getSkuStatus() == 5) continue;
                    s = "\u5355\u54c1ID\u4e3a\uff1a" + skuId + "\u7684\u72b6\u6001\u4e0d\u4e3a\u5141\u8bb8\u4e0a\u67b6\u7684\u72b6\u6001";
                    return s;
                }
            }
            Map<String, String> map = null;
            if (reqBO.getUpType() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuPutCirEnum.UP_TYPE.toString())).containsKey(String.valueOf(reqBO.getUpType()))) {
                s = "\u4e0a\u67b6\u65b9\u5f0f\u9519\u8bef";
                return s;
            }
        } else {
            s = "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
            return s;
        }
        return s;
    }

    private void syncEs(List<Long> commds, Long supplierShopId) {
        if (!CollectionUtils.isEmpty(commds)) {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(commds);
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
    }
}

