/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.CommodityCheckNotPassBO;
import com.tydic.commodity.bo.busi.CommodityCheckPassBO;
import com.tydic.commodity.bo.busi.DealCommoApprovalLevelBO;
import com.tydic.commodity.bo.busi.SendNextCommoDealDetail;
import com.tydic.commodity.bo.busi.UccExaminationApprovalReqBO;
import com.tydic.commodity.bo.busi.UccExaminationApprovalRspBO;
import com.tydic.commodity.busi.api.DealCommoApprovalLevelService;
import com.tydic.commodity.busi.api.UccExaminationApprovalBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.ApprovalLevelMapper;
import com.tydic.commodity.dao.po.ApprovalLevelPO;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccExaminationApprovalBusiService"})
public class UccExaminationApprovalBusiServiceImpl
implements UccExaminationApprovalBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccExaminationApprovalBusiServiceImpl.class);
    @Autowired
    private ApprovalLevelMapper approvalLevelMapper;
    @Autowired
    private DealCommoApprovalLevelService dealCommoApprovalLevelService;

    @PostMapping(value={"dealExaminationApproval"})
    public UccExaminationApprovalRspBO dealExaminationApproval(@RequestBody UccExaminationApprovalReqBO reqBO) {
        List<ApprovalLevelPO> approvalLevelPOS;
        UccExaminationApprovalRspBO uccExaminationApprovalRspBO = new UccExaminationApprovalRspBO();
        ApprovalLevelPO approvalLevelPO = new ApprovalLevelPO();
        approvalLevelPO.setCommodityIds(reqBO.getBusinessId());
        try {
            approvalLevelPOS = this.approvalLevelMapper.queryCommoAndLevelByCommIdAndSupplierId(approvalLevelPO);
        }
        catch (Exception e) {
            LOGGER.error("\u5546\u54c1\u5ba1\u6838\u7b49\u7ea7\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new BusinessException("8888", "\u5546\u54c1\u5ba1\u6838\u7b49\u7ea7\u67e5\u8be2\u5931\u8d25");
        }
        DealCommoApprovalLevelBO dealCommoApprovalLevelBO = null;
        try {
            dealCommoApprovalLevelBO = this.dealCommoApprovalLevel(approvalLevelPOS);
            dealCommoApprovalLevelBO.setOperId(reqBO.getOperId());
            dealCommoApprovalLevelBO.setRestoreShelfe(reqBO.getRestoreShelfe());
            dealCommoApprovalLevelBO.setReason(reqBO.getReason());
        }
        catch (BusinessException e) {
            uccExaminationApprovalRspBO.setRespDesc("8888");
            uccExaminationApprovalRspBO.setRespDesc("\u5546\u54c1\u7b49\u7ea7\u5ba1\u6838\u6821\u9a8c\u5931\u8d25");
            return uccExaminationApprovalRspBO;
        }
        try {
            this.dealCommoApprovalLevelService.dealRejectDetail(dealCommoApprovalLevelBO);
            this.dealCommoApprovalLevelService.dealInitiateApproval(dealCommoApprovalLevelBO);
            this.dealCommoApprovalLevelService.dealDirectUpperShelf(dealCommoApprovalLevelBO);
        }
        catch (BusinessException e) {
            LOGGER.error("\u5904\u7406\u5546\u54c1\u5ba1\u6838\u4e0a\u67b6\u5931\u8d25,\u539f\u56e0\uff1a" + (Object)((Object)e));
            uccExaminationApprovalRspBO.setRespCode(e.getMsgCode());
            uccExaminationApprovalRspBO.setRespDesc(e.getMsgInfo());
            return uccExaminationApprovalRspBO;
        }
        uccExaminationApprovalRspBO.setCommodityCheckNotPassBOList(dealCommoApprovalLevelBO.getNotPassCommodity());
        uccExaminationApprovalRspBO.setRespCode("0000");
        uccExaminationApprovalRspBO.setRespDesc("\u6210\u529f");
        return uccExaminationApprovalRspBO;
    }

    private DealCommoApprovalLevelBO dealCommoApprovalLevel(List<ApprovalLevelPO> approvalLevelPOS) {
        if (CollectionUtils.isEmpty(approvalLevelPOS)) {
            throw new BusinessException("8888", "\u5546\u54c1\u7b49\u7ea7\u5ba1\u6838\u5931\u8d25");
        }
        DealCommoApprovalLevelBO dealCommoApprovalLevelBO = new DealCommoApprovalLevelBO();
        ArrayList sendNextCommoDealDetails = Lists.newArrayList();
        ArrayList commodityCheckNotPassBOS = Lists.newArrayList();
        ArrayList commodityCheckPassBOS = Lists.newArrayList();
        for (ApprovalLevelPO approvalObjPOL : approvalLevelPOS) {
            if (approvalObjPOL.getApprovalLevel() == ModelRuleConstant.APPROVAL_LEVEL_BRAND || approvalObjPOL.getApprovalLevel() == ModelRuleConstant.APPROVAL_LEVEL_FOCUS) {
                SendNextCommoDealDetail sendNextCommoDealDetail = new SendNextCommoDealDetail();
                sendNextCommoDealDetail.setCommodityId(approvalObjPOL.getCommodityId());
                sendNextCommoDealDetails.add(sendNextCommoDealDetail);
                continue;
            }
            if (approvalObjPOL.getApprovalLevel() == ModelRuleConstant.APPROVAL_LEVEL_IN_ENAVLE) {
                CommodityCheckNotPassBO commodityCheckNotPassBO = new CommodityCheckNotPassBO();
                commodityCheckNotPassBO.setNotPassReason("\u4e0d\u53ef\u4ee5\u4e0a");
                commodityCheckNotPassBO.setCommodityIds(approvalObjPOL.getCommodityId());
                commodityCheckNotPassBOS.add(commodityCheckNotPassBO);
                continue;
            }
            if (approvalObjPOL.getApprovalLevel() != ModelRuleConstant.APPROVAL_LEVEL_ENAVLE) continue;
            CommodityCheckPassBO commodityCheckPassBO = new CommodityCheckPassBO();
            commodityCheckPassBO.setCommodityId(approvalObjPOL.getCommodityId());
            commodityCheckPassBOS.add(commodityCheckPassBO);
        }
        dealCommoApprovalLevelBO.setSendNextCommoDealDetail((List)sendNextCommoDealDetails);
        dealCommoApprovalLevelBO.setNotPassCommodity((List)commodityCheckNotPassBOS);
        dealCommoApprovalLevelBO.setPassCommodity((List)commodityCheckPassBOS);
        return dealCommoApprovalLevelBO;
    }
}

