/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.CommodityNumBo;
import com.tydic.commodity.bo.busi.UccEMdmCatalogListBO;
import com.tydic.commodity.bo.busi.UccLowerCatQryListReqBO;
import com.tydic.commodity.bo.busi.UccLowerCatQryListRspBO;
import com.tydic.commodity.busi.api.UccLowerCatQryListBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccEMdmCatalogPO;
import com.tydic.commodity.util.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccLowerCatQryListBusiService"})
public class UccLowerCatQryListBusiServiceImpl
implements UccLowerCatQryListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccLowerCatQryListBusiServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    @PostMapping(value={"queryLowerCatList"})
    public UccLowerCatQryListRspBO queryLowerCatList(@RequestBody UccLowerCatQryListReqBO reqBO) {
        Long parentIds;
        UccLowerCatQryListRspBO rspBO = new UccLowerCatQryListRspBO();
        List<UccEMdmCatalogListBO> uccEMdmCatalogListBOS = new ArrayList<UccEMdmCatalogListBO>();
        rspBO.setResult(uccEMdmCatalogListBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getOrgIdIn() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u673a\u6784ID");
            return rspBO;
        }
        if (reqBO.getCatalogId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u5bfc\u8d2d\u7c7b\u76eeID");
            return rspBO;
        }
        List<Long> commodityTypeIds = this.uccCatRCommdTypeMapper.qryCommodityTypeIds(reqBO.getCatalogId());
        if (CollectionUtils.isEmpty(commodityTypeIds)) {
            return rspBO;
        }
        ArrayList<Long> supplierShopIds = new ArrayList<Long>();
        if (reqBO.getSupplierShopId() != null) {
            supplierShopIds.add(reqBO.getSupplierShopId());
        } else {
            List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn());
            if (CollectionUtils.isNotEmpty(supplierShopPos)) {
                supplierShopIds.addAll(supplierShopPos.stream().map(SupplierShopPo::getSupplierShopId).collect(Collectors.toList()));
            }
        }
        List<CommodityNumBo> commodityNumBos = this.uccCommodityMapper.qryNumByType(commodityTypeIds, supplierShopIds);
        if (CollectionUtils.isEmpty(commodityNumBos)) {
            return rspBO;
        }
        commodityTypeIds = commodityNumBos.stream().map(CommodityNumBo::getCommodityTypeId).collect(Collectors.toList());
        List<UccCommodityTypePo> uccCommodityTypePos = this.uccCommodityTypeMapper.batchQryInType(commodityTypeIds);
        HashMap<Long, Long> catAndNums = new HashMap<Long, Long>();
        ArrayList<Long> catIds = new ArrayList<Long>();
        for (UccCommodityTypePo uccCommodityTypePo : uccCommodityTypePos) {
            for (CommodityNumBo commodityNumBo : commodityNumBos) {
                if (commodityNumBo.getCommodityTypeId() == null || !commodityNumBo.getCommodityTypeId().equals(uccCommodityTypePo.getCommodityTypeId())) continue;
                catAndNums.put(uccCommodityTypePo.getCatalogId(), commodityNumBo.getNum());
            }
            catIds.add(uccCommodityTypePo.getCatalogId());
        }
        List<UccEMdmCatalogPO> uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(catIds);
        for (UccEMdmCatalogPO uccEMdmCatalogPO : uccEMdmCatalogPOS) {
            UccEMdmCatalogListBO uccEMdmCatalogListBO = new UccEMdmCatalogListBO();
            BeanUtils.copyProperties((Object)uccEMdmCatalogPO, (Object)uccEMdmCatalogListBO);
            for (Map.Entry each : catAndNums.entrySet()) {
                if (each.getKey() == null || !((Long)each.getKey()).equals(uccEMdmCatalogPO.getCatalogId())) continue;
                uccEMdmCatalogListBO.setItemCount((Long)each.getValue());
            }
            uccEMdmCatalogListBOS.add(uccEMdmCatalogListBO);
        }
        List list = uccEMdmCatalogListBOS.stream().map(UccEMdmCatalogListBO::getCatalogLevel).collect(Collectors.toList());
        List list2 = ListUtils.removeReapet(list);
        int maxLevel = 1;
        for (int i = 0; i < list2.size(); ++i) {
            if ((Integer)list2.get(i) <= maxLevel) continue;
            maxLevel = (Integer)list2.get(i);
        }
        List<UccEMdmCatalogListBO> allCatBO = new ArrayList<UccEMdmCatalogListBO>();
        allCatBO.addAll(uccEMdmCatalogListBOS);
        while (!CollectionUtils.isEmpty(uccEMdmCatalogListBOS) && (parentIds = Long.valueOf(uccEMdmCatalogListBOS.stream().mapToLong(UccEMdmCatalogListBO::getParentCatalogId).sum())) != 0L) {
            uccEMdmCatalogListBOS = this.getParent(uccEMdmCatalogListBOS);
            allCatBO.addAll(uccEMdmCatalogListBOS);
        }
        allCatBO = ListUtils.removeReapet(allCatBO);
        Map<Integer, List<UccEMdmCatalogListBO>> groupsByLevel = allCatBO.stream().collect(Collectors.groupingBy(UccEMdmCatalogListBO::getCatalogLevel));
        List<UccEMdmCatalogListBO> uccEMdmCatalogListBOList = groupsByLevel.get(maxLevel);
        for (int i = 1; i < maxLevel; ++i) {
            if (!groupsByLevel.containsKey(maxLevel - i)) continue;
            uccEMdmCatalogListBOList = this.mergeChild(groupsByLevel.get(maxLevel - i), uccEMdmCatalogListBOList);
        }
        rspBO.setResult(uccEMdmCatalogListBOList);
        return rspBO;
    }

    private List<UccEMdmCatalogListBO> getParent(List<UccEMdmCatalogListBO> uccEMdmCatalogBOs) {
        if (CollectionUtils.isEmpty(uccEMdmCatalogBOs)) {
            return null;
        }
        List parentIds = uccEMdmCatalogBOs.stream().map(UccEMdmCatalogListBO::getParentCatalogId).collect(Collectors.toList());
        parentIds = ListUtils.removeReapet(parentIds);
        parentIds.remove(0L);
        ArrayList<UccEMdmCatalogListBO> uccEMdmCatalogListBOS = new ArrayList<UccEMdmCatalogListBO>();
        List<UccEMdmCatalogPO> uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(parentIds);
        if (CollectionUtils.isNotEmpty(uccEMdmCatalogPOS)) {
            for (UccEMdmCatalogPO uccEMdmCatalogPO : uccEMdmCatalogPOS) {
                UccEMdmCatalogListBO uccEMdmCatalogListBO = new UccEMdmCatalogListBO();
                BeanUtils.copyProperties((Object)uccEMdmCatalogPO, (Object)uccEMdmCatalogListBO);
                uccEMdmCatalogListBOS.add(uccEMdmCatalogListBO);
            }
        }
        return uccEMdmCatalogListBOS;
    }

    private List<UccEMdmCatalogListBO> mergeChild(List<UccEMdmCatalogListBO> parent, List<UccEMdmCatalogListBO> child) {
        ArrayList<UccEMdmCatalogListBO> result = new ArrayList<UccEMdmCatalogListBO>();
        HashMap<Long, UccEMdmCatalogListBO> parentMap = new HashMap<Long, UccEMdmCatalogListBO>();
        for (UccEMdmCatalogListBO each : parent) {
            if (parentMap.containsKey(each.getCatalogId())) continue;
            parentMap.put(each.getCatalogId(), each);
        }
        for (UccEMdmCatalogListBO each : child) {
            if (parentMap.containsKey(each.getParentCatalogId())) {
                ((UccEMdmCatalogListBO)parentMap.get(each.getParentCatalogId())).getChildren().add(each);
                continue;
            }
            System.out.println("\u5f53\u524d\u5b50\u7c7b\u76ee\u6ca1\u6709\u627e\u5230\u7236\u7c7b:" + each);
            parentMap.put(each.getParentCatalogId(), each);
        }
        Iterator entries = parentMap.entrySet().iterator();
        while (entries.hasNext()) {
            result.add((UccEMdmCatalogListBO)entries.next().getValue());
        }
        return result;
    }
}

