/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.bo.busi.MqSyncCommdPriceBo;
import com.tydic.commodity.bo.busi.MqSyncCommdPriceReqBo;
import com.tydic.commodity.bo.busi.MqSyncCommdPriceRspBo;
import com.tydic.commodity.bo.busi.SkuPriceBo;
import com.tydic.commodity.bo.busi.UccSkuAdjustPriceReqBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.busi.api.UccMqSyncCommdPriceBusiService;
import com.tydic.commodity.busi.api.UccSkuAdjustPriceBusiService;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.ECommercePriceChangeMapper;
import com.tydic.commodity.dao.UccIntervalPricePercentageMapper;
import com.tydic.commodity.dao.UccPercentagePirceMapper;
import com.tydic.commodity.dao.UccPricePreventMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceLogMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.dao.po.ECommercePriceChangePO;
import com.tydic.commodity.dao.po.UccIntervalPricePercentagePO;
import com.tydic.commodity.dao.po.UccPercentagePircePo;
import com.tydic.commodity.dao.po.UccPriceBetweenPo;
import com.tydic.commodity.dao.po.UccPricePreventPO;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPriceLogPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMqSyncCommdPriceBusiServiceImpl
implements UccMqSyncCommdPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMqSyncCommdPriceBusiServiceImpl.class);
    private static final int weekNum = 12;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ECommercePriceChangeMapper eCommercePriceChangeMapper;
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Autowired
    private UccSkuAdjustPriceBusiService uccSkuAdjustPriceBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private UccIntervalPricePercentageMapper uccIntervalPricePercentageMapper;
    @Autowired
    private UccPricePreventMapper uccPricePreventMapper;
    @Autowired
    private BatchUpdateCommoStatusForMarketService statusForMarketService;
    @Autowired
    private UccSkuPriceLogMapper uccSkuPriceLogMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccPercentagePirceMapper uccPercentagePirceMapper;
    private Sequence coefficientSequence = Sequence.getInstance();

    public MqSyncCommdPriceRspBo dealSync(MqSyncCommdPriceReqBo mqSyncCommdPriceReqBo) throws ZTBusinessException {
        log.info("\u4ef7\u683c\u53d8\u52a8\u9884\u8b66\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)mqSyncCommdPriceReqBo));
        MqSyncCommdPriceRspBo rspBo = new MqSyncCommdPriceRspBo();
        ArrayList<ECommercePriceChangePO> eCommercePriceChangePOList = new ArrayList<ECommercePriceChangePO>();
        ArrayList<ECommercePriceChangeLogPO> eCommercePriceChangeLogPOS = new ArrayList<ECommercePriceChangeLogPO>();
        if (CollectionUtils.isEmpty((Collection)mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        for (MqSyncCommdPriceBo each : mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList()) {
            UccSkuAdjustPriceReqBO uccSkuAdjustPriceReqBO = new UccSkuAdjustPriceReqBO();
            uccSkuAdjustPriceReqBO.setSkuId(each.getSkuId());
            uccSkuAdjustPriceReqBO.setSupplierShopId(each.getSupplierShopId());
            SkuPriceBo skuPriceBo = new SkuPriceBo();
            uccSkuAdjustPriceReqBO.setUpdateSkuPriceInfo(skuPriceBo);
            skuPriceBo.setSalePrice(each.getSalePrice());
            skuPriceBo.setAgreementPrice(each.getAgreementPrice());
            skuPriceBo.setMarketPrice(each.getMarketPrice());
            try {
                this.uccSkuAdjustPriceBusiService.dealSkuAdjustPrice(uccSkuAdjustPriceReqBO);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(each.getSkuId());
            List<UccSkuPo> skuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
            UccPercentagePircePo uccPercentagePircePo = this.uccPercentagePirceMapper.qryBysupplierId(skuPoList.get(0).getSupplierShopId());
            if (null == uccPercentagePircePo) {
                this.dealUpFloat(mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList());
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                return rspBo;
            }
            ECommercePriceChangePO eCommercePriceChangePO = new ECommercePriceChangePO();
            eCommercePriceChangePO.setSkuId(each.getSkuId());
            eCommercePriceChangePO.setSupplierShopId(each.getSupplierShopId());
            List<ECommercePriceChangePO> eCommercePriceChangePOS = this.eCommercePriceChangeMapper.qryECommercePriceChange(eCommercePriceChangePO);
            Date nowDate = this.queryDBDateBusiService.getDBDate();
            Calendar time = Calendar.getInstance();
            time.setTime(each.getOnShelveTime());
            time.add(1, 1);
            Date onShelveTime = time.getTime();
            Date updateTime = null;
            if (nowDate.compareTo(onShelveTime) > 0) {
                time.setTime(nowDate);
                time.set(2, 4);
                time.set(5, 31);
                Date compareTime = time.getTime();
                time = Calendar.getInstance();
                time.setTime(nowDate);
                time.add(1, -1);
                if (nowDate.compareTo(compareTime) > 0) {
                    time.set(2, 5);
                    time.set(5, 1);
                } else {
                    time.set(2, 0);
                    time.set(5, 1);
                }
                updateTime = time.getTime();
            }
            ECommercePriceChangeLogPO eCommercePriceChangeLogHistory = new ECommercePriceChangeLogPO();
            eCommercePriceChangeLogHistory.setSkuId(each.getSkuId());
            eCommercePriceChangeLogHistory.setSupplierShopId(each.getSupplierShopId());
            eCommercePriceChangeLogHistory.setUpdateTime(updateTime);
            eCommercePriceChangeLogHistory = this.eCommercePriceChangeLogMapper.queryCount(eCommercePriceChangeLogHistory);
            if (eCommercePriceChangeLogHistory == null) {
                return null;
            }
            eCommercePriceChangePO.setFrequency(eCommercePriceChangeLogHistory.getFrequency());
            eCommercePriceChangePO.setAveragePrice(eCommercePriceChangeLogHistory.getAveragePrice());
            eCommercePriceChangePO.setExtSkuId(each.getExtSkuId());
            eCommercePriceChangePO.setFrequency(eCommercePriceChangeLogHistory.getFrequency());
            eCommercePriceChangePO.setPrice(each.getOrgSalePrice());
            if (eCommercePriceChangePO.getAveragePrice() != null) {
                if (eCommercePriceChangePO.getAveragePrice().compareTo(new BigDecimal(0)) == 0) {
                    if (each.getOrgSalePrice().compareTo(eCommercePriceChangePO.getAveragePrice()) == 0) {
                        eCommercePriceChangePO.setFloatingRate(new BigDecimal(0.01));
                    } else {
                        eCommercePriceChangePO.setFloatingRate(new BigDecimal(0));
                    }
                } else {
                    eCommercePriceChangePO.setFloatingRate(each.getOrgSalePrice().divide(eCommercePriceChangePO.getAveragePrice(), 2, 0));
                }
            }
            try {
                eCommercePriceChangePO.setId(this.coefficientSequence.nextId());
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            if (eCommercePriceChangePOS == null || eCommercePriceChangePOS.size() == 0) {
                eCommercePriceChangePOList.add(eCommercePriceChangePO);
            } else {
                this.eCommercePriceChangeMapper.modifyECommercePriceChange(eCommercePriceChangePO);
            }
            ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
            try {
                eCommercePriceChangeLogPO.setBatchId(this.coefficientSequence.nextId());
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            BeanUtils.copyProperties((Object)eCommercePriceChangePO, (Object)eCommercePriceChangeLogPO);
            eCommercePriceChangeLogPO.setOnShelveTime(each.getOnShelveTime());
            eCommercePriceChangeLogPOS.add(eCommercePriceChangeLogPO);
        }
        if (eCommercePriceChangePOList.size() > 0) {
            this.eCommercePriceChangeMapper.insertPriceChange(eCommercePriceChangePOList);
        }
        if (eCommercePriceChangeLogPOS.size() > 0) {
            this.eCommercePriceChangeLogMapper.insertECommercePriceChangeLogs(eCommercePriceChangeLogPOS);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealUpFloat(List<MqSyncCommdPriceBo> bos) {
        if (!CollectionUtils.isEmpty(bos)) {
            UccIntervalPricePercentagePO uccIntervalPricePercentagePO = new UccIntervalPricePercentagePO();
            Page page = new Page();
            page.setPageSize(999);
            List<UccIntervalPricePercentagePO> uccIntervalPricePercentagePOS = this.uccIntervalPricePercentageMapper.getListPage(uccIntervalPricePercentagePO, (Page<UccIntervalPricePercentagePO>)page);
            if (CollectionUtils.isEmpty(uccIntervalPricePercentagePOS)) {
                return;
            }
            ArrayList<Long> commoditys = new ArrayList<Long>();
            ArrayList<UccPricePreventPO> uccPricePreventPOS = new ArrayList<UccPricePreventPO>();
            Map<Integer, Date> map = this.getWeekInfo(12);
            Date beginWeekDate = map.get(1);
            Date stopWeekDate = map.get(2);
            Map<Long, List<MqSyncCommdPriceBo>> groupSup = bos.stream().collect(Collectors.groupingBy(MqSyncCommdPriceBo::getSupplierShopId));
            Map<Long, Map<Integer, BigDecimal>> resultMap = this.getPirceInfo(groupSup, beginWeekDate, stopWeekDate);
            for (MqSyncCommdPriceBo mqSyncCommdPriceBo : bos) {
                BigDecimal agreementPrice = MoneyUtils.haoToYuan((Long)mqSyncCommdPriceBo.getAgreementPrice());
                BigDecimal oldAgreementPrice = MoneyUtils.haoToYuan((Long)mqSyncCommdPriceBo.getOldAgreementPrice());
                for (UccIntervalPricePercentagePO uccIntervalPricePercentagePO1 : uccIntervalPricePercentagePOS) {
                    BigDecimal downPrencent;
                    BigDecimal upPrencent;
                    if (agreementPrice.compareTo(uccIntervalPricePercentagePO1.getNumStart()) < 0 || agreementPrice.compareTo(uccIntervalPricePercentagePO1.getNumEnd()) > 0) continue;
                    BigDecimal maxPrice = new BigDecimal(-1);
                    BigDecimal minPrice = new BigDecimal(-1);
                    if (resultMap != null && resultMap.size() > 0) {
                        maxPrice = resultMap.get(mqSyncCommdPriceBo.getSkuId()).get(1);
                        minPrice = resultMap.get(mqSyncCommdPriceBo.getSkuId()).get(2);
                    }
                    UccPricePreventPO uccPricePreventPO = new UccPricePreventPO();
                    uccPricePreventPO.setBeforePrice(new BigDecimal(mqSyncCommdPriceBo.getOldAgreementPrice().toString()));
                    uccPricePreventPO.setPrice(new BigDecimal(mqSyncCommdPriceBo.getAgreementPrice().toString()));
                    uccPricePreventPO.setSupplierShopId(mqSyncCommdPriceBo.getSupplierShopId());
                    uccPricePreventPO.setUpdateTime(new Date());
                    uccPricePreventPO.setMaxPrice(MoneyUtils.yuanToHao((BigDecimal)maxPrice));
                    uccPricePreventPO.setMinPrice(MoneyUtils.yuanToHao((BigDecimal)minPrice));
                    uccPricePreventPO.setSkuId(mqSyncCommdPriceBo.getSkuId());
                    boolean judge = false;
                    boolean judge1 = false;
                    boolean judge2 = false;
                    if (maxPrice.compareTo(new BigDecimal(-1)) != 0) {
                        BigDecimal sownShefPrencent;
                        if (agreementPrice.compareTo(maxPrice) > 0) {
                            if (!judge2) {
                                upPrencent = agreementPrice.subtract(minPrice).divide(minPrice, 4);
                                if (upPrencent.compareTo(uccIntervalPricePercentagePO1.getUpperPercentage().divide(new BigDecimal("100"))) > 0) {
                                    uccPricePreventPO.setPercentage(upPrencent);
                                    uccPricePreventPOS.add(uccPricePreventPO);
                                    judge = true;
                                    judge2 = true;
                                }
                                if ((sownShefPrencent = agreementPrice.subtract(minPrice).divide(minPrice, 4)).compareTo(uccIntervalPricePercentagePO1.getOffShelfPercentage().divide(new BigDecimal("100"))) > 0) {
                                    commoditys.add(mqSyncCommdPriceBo.getCommodityId());
                                    judge1 = true;
                                }
                            }
                        } else if (agreementPrice.compareTo(minPrice) < 0) {
                            if (!judge2 && (downPrencent = maxPrice.subtract(agreementPrice).divide(maxPrice, 4)).compareTo(uccIntervalPricePercentagePO1.getDownPercentage().divide(new BigDecimal("100"))) > 0) {
                                uccPricePreventPO.setPercentage(downPrencent);
                                uccPricePreventPOS.add(uccPricePreventPO);
                                judge = true;
                                judge2 = true;
                            }
                        } else {
                            if (!judge2) {
                                upPrencent = agreementPrice.subtract(minPrice).divide(minPrice, 4);
                                if (upPrencent.compareTo(uccIntervalPricePercentagePO1.getUpperPercentage().divide(new BigDecimal("100"))) > 0) {
                                    uccPricePreventPO.setPercentage(upPrencent);
                                    uccPricePreventPOS.add(uccPricePreventPO);
                                    judge = true;
                                    judge2 = true;
                                }
                                if ((sownShefPrencent = agreementPrice.subtract(minPrice).divide(minPrice, 4)).compareTo(uccIntervalPricePercentagePO1.getOffShelfPercentage().divide(new BigDecimal("100"))) > 0) {
                                    commoditys.add(mqSyncCommdPriceBo.getCommodityId());
                                    judge1 = true;
                                }
                            }
                            if (!judge2 && (downPrencent = maxPrice.subtract(agreementPrice).divide(maxPrice, 4)).compareTo(uccIntervalPricePercentagePO1.getDownPercentage().divide(new BigDecimal("100"))) > 0) {
                                uccPricePreventPO.setPercentage(downPrencent);
                                uccPricePreventPOS.add(uccPricePreventPO);
                                judge = true;
                                judge2 = true;
                            }
                        }
                    }
                    if (agreementPrice.compareTo(oldAgreementPrice) > 0) {
                        log.info("\u539f\u6765\u4ef7\u683c\u4e3a\uff1a------------------------------" + oldAgreementPrice);
                        if (oldAgreementPrice.compareTo(new BigDecimal("0.00")) == 0) {
                            oldAgreementPrice = new BigDecimal("0.0000001");
                        }
                        if ((upPrencent = agreementPrice.subtract(oldAgreementPrice).divide(oldAgreementPrice, 4)).compareTo(uccIntervalPricePercentagePO1.getUpperPercentage().divide(new BigDecimal("100"))) > 0) {
                            uccPricePreventPO.setPercentage(upPrencent);
                            if (!judge) {
                                uccPricePreventPOS.add(uccPricePreventPO);
                            }
                        }
                        if (upPrencent.compareTo(uccIntervalPricePercentagePO1.getOffShelfPercentage().divide(new BigDecimal("100"))) <= 0 || judge1) continue;
                        commoditys.add(mqSyncCommdPriceBo.getCommodityId());
                        continue;
                    }
                    if (agreementPrice.compareTo(oldAgreementPrice) >= 0 || (downPrencent = oldAgreementPrice.subtract(agreementPrice).divide(oldAgreementPrice, 4)).compareTo(uccIntervalPricePercentagePO1.getDownPercentage().divide(new BigDecimal("100"))) <= 0) continue;
                    uccPricePreventPO.setPercentage(downPrencent);
                    if (judge) continue;
                    uccPricePreventPOS.add(uccPricePreventPO);
                }
            }
            if (!CollectionUtils.isEmpty(commoditys)) {
                BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
                Long[] longs = new Long[commoditys.size()];
                for (int i = 0; i < commoditys.size(); ++i) {
                    longs[i] = (Long)commoditys.get(i);
                }
                batchUpdateCommoStatusForMarketBO.setBusinessId(longs);
                batchUpdateCommoStatusForMarketBO.setReason("\u4ef7\u683c\u9884\u8b66\u8d85\u8fc7\u9608\u503c\uff0c\u5546\u54c1\u81ea\u52a8\u4e0b\u67b6");
                this.statusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.EFFECTIVE_STATUS, SkuStatusEnum.DOWN_FRAME_STATUS);
            }
            try {
                if (!CollectionUtils.isEmpty(uccPricePreventPOS)) {
                    for (UccPricePreventPO po : uccPricePreventPOS) {
                        UccPricePreventPO preventPO = new UccPricePreventPO();
                        preventPO.setSkuId(po.getSkuId());
                        List<UccPricePreventPO> list = this.uccPricePreventMapper.getList(preventPO);
                        if (list.size() == 0) continue;
                        this.uccPricePreventMapper.updateBy(po, list.get(0));
                    }
                    this.uccPricePreventMapper.insertBatch(uccPricePreventPOS);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u67b6\u4e0a\u6d6e\u8d85\u8fc7\u9884\u8b66\uff0c\u6dfb\u52a0\u4e0a\u6d6e\u9884\u8b66\u8bb0\u5f55\u5931\u8d25");
            }
        }
    }

    private Map<Integer, Date> getWeekInfo(int n) {
        HashMap<Integer, Date> timeMap = new HashMap<Integer, Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        int dayOfWeek = calendar1.get(7) - 1;
        int offset1 = 1 - dayOfWeek;
        calendar1.add(5, offset1 - 7 * n);
        calendar2.add(5, offset1);
        String lastBeginDate = sdf.format(calendar1.getTime());
        String nowDate = sdf.format(calendar2.getTime());
        timeMap.put(1, DateUtils.strToDate((String)lastBeginDate));
        timeMap.put(2, new Date());
        return timeMap;
    }

    private Map<Long, Map<Integer, BigDecimal>> getPirceInfo(Map<Long, List<MqSyncCommdPriceBo>> map, Date beginTime, Date endTime) {
        HashMap<Long, Map<Integer, BigDecimal>> resultMap = new HashMap<Long, Map<Integer, BigDecimal>>();
        if (null != map) {
            for (Map.Entry<Long, List<MqSyncCommdPriceBo>> each : map.entrySet()) {
                HashMap<Integer, BigDecimal> priceMap;
                List<Long> skuIds = each.getValue().stream().map(MqSyncCommdPriceBo::getSkuId).collect(Collectors.toList());
                List<UccSkuPricePo> uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(skuIds, each.getKey());
                if (CollectionUtils.isEmpty(uccSkuPricePos)) {
                    return null;
                }
                ArrayList<Long> skuIdList = new ArrayList<Long>();
                for (UccSkuPricePo uccSkuPricePo : uccSkuPricePos) {
                    List<UccSkuPriceLogPo> logPrice = this.uccSkuPriceLogMapper.qrySkuLog(uccSkuPricePo.getSkuId());
                    if (uccSkuPricePo.getUpdateTime() == null) {
                        priceMap = new HashMap<Integer, BigDecimal>();
                        priceMap.put(1, MoneyUtils.haoToYuan((Long)uccSkuPricePo.getAgreementPrice()));
                        priceMap.put(2, MoneyUtils.haoToYuan((Long)uccSkuPricePo.getAgreementPrice()));
                        resultMap.put(uccSkuPricePo.getSkuId(), priceMap);
                        continue;
                    }
                    if (uccSkuPricePo.getUpdateTime().before(beginTime)) {
                        priceMap = new HashMap();
                        priceMap.put(1, MoneyUtils.haoToYuan((Long)uccSkuPricePo.getAgreementPrice()));
                        priceMap.put(2, MoneyUtils.haoToYuan((Long)uccSkuPricePo.getAgreementPrice()));
                        resultMap.put(uccSkuPricePo.getSkuId(), priceMap);
                        continue;
                    }
                    if (!uccSkuPricePo.getUpdateTime().after(beginTime) || !logPrice.get(logPrice.size() - 1).getCreateTime().before(endTime)) continue;
                    skuIdList.add(uccSkuPricePo.getSkuId());
                }
                if (CollectionUtils.isEmpty(skuIdList)) continue;
                List<UccPriceBetweenPo> uccPriceBetweenPos = this.uccSkuPriceLogMapper.getNeedList(skuIdList, each.getKey(), beginTime, endTime);
                if (CollectionUtils.isEmpty(uccPriceBetweenPos)) {
                    log.error("\u5728\u65f6\u95f4\u533a\u95f4\u5185\u4fee\u6539\u8fc7\u4ef7\u683c\uff0c\u65e5\u5fd7\u8868\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u8868\u662f\u5426\u6b63\u5e38\u5199\u5165");
                    log.error("\u672a\u6b63\u5e38\u5199\u5165\u4ef7\u683c\u4e0a\u6d6e\u9884\u8b66\u5546\u54c1\uff1a" + JSONObject.toJSONString(skuIdList));
                    continue;
                }
                for (UccPriceBetweenPo uccPriceBetweenPo : uccPriceBetweenPos) {
                    priceMap = new HashMap();
                    priceMap.put(1, uccPriceBetweenPo.getMaxAgreementPrice());
                    priceMap.put(2, uccPriceBetweenPo.getMinAgreementPrice());
                    resultMap.put(uccPriceBetweenPo.getSkuId(), priceMap);
                }
            }
        }
        return resultMap;
    }
}

