/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.bo.busi.ECommercePriceChangeVO;
import com.tydic.commodity.bo.busi.SkuPriUpInfoBo;
import com.tydic.commodity.bo.busi.UccPriUpQryReqBO;
import com.tydic.commodity.bo.busi.UccPriUpQryRspBO;
import com.tydic.commodity.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.busi.api.UccPriUpListQryBusiService;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.ECommercePriceChangeMapper;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccPercentagePirceMapper;
import com.tydic.commodity.dao.UccSkuPriceLogMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccPercentagePircePo;
import com.tydic.commodity.dao.po.UccPriUpQryRspVO;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccPriUpListQryBusiService"})
public class UccPriUpListQryBusiServiceImpl
implements UccPriUpListQryBusiService {
    @Autowired
    private ECommercePriceChangeMapper eCommercePriceChangeMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccPriUpListQryBusiServiceImpl.class);
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private UccSkuPriceLogMapper uccSkuPriceLogMapper;
    @Autowired
    private UccPercentagePirceMapper uccPercentagePirceMapper;
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;

    @PostMapping(value={"qryPriUp"})
    public UccPriUpQryRspBO qryPriUp(@RequestBody UccPriUpQryReqBO reqBO) {
        ECommercePriceChangeVO eCommercePriceChangeVO = new ECommercePriceChangeVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)eCommercePriceChangeVO);
        ArrayList<Long> supplierShopIds = new ArrayList<Long>();
        List<Object> supplierShopPos = new ArrayList();
        if (reqBO.getSupplierId() != null) {
            supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        }
        for (SupplierShopPo supplierShopPo : supplierShopPos) {
            if (supplierShopPo.getSupplierShopId() == null) continue;
            supplierShopIds.add(supplierShopPo.getSupplierShopId());
        }
        eCommercePriceChangeVO.setSupplierShopIds(supplierShopIds);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccPercentagePircePo uccPercentagePircePo = this.uccPercentagePirceMapper.qryBysupplierId(reqBO.getSupplierId());
        try {
            if (uccPercentagePircePo != null && uccPercentagePircePo.getPercentage() != null) {
                eCommercePriceChangeVO.setPercentage(uccPercentagePircePo.getPercentage().divide(new BigDecimal("100"), 2, 7));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u8ba1\u7b97\u9884\u8b66\u7cfb\u6570\u5f02\u5e38");
        }
        try {
            List<UccPriUpQryRspVO> uccPriUpQryRspVOS = this.eCommercePriceChangeMapper.selectECommercePriceChange(eCommercePriceChangeVO, page);
            ArrayList<SkuPriUpInfoBo> skuPriUpInfoBos = new ArrayList<SkuPriUpInfoBo>();
            if (uccPriUpQryRspVOS != null && !uccPriUpQryRspVOS.isEmpty()) {
                for (UccPriUpQryRspVO uccPriUpQryRspVO : uccPriUpQryRspVOS) {
                    UccCommodityTypePo uccCommodityTypePo;
                    SkuPriUpInfoBo skuPriUpInfoBo = new SkuPriUpInfoBo();
                    BeanUtils.copyProperties((Object)uccPriUpQryRspVO, (Object)skuPriUpInfoBo);
                    skuPriUpInfoBo.setSupplierId(reqBO.getSupplierId());
                    SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(reqBO.getSupplierId());
                    if (supplierBusiPo != null) {
                        skuPriUpInfoBo.setSupplierName(supplierBusiPo.getSupplierName());
                    }
                    if (uccPriUpQryRspVO.getUpdateTime() != null) {
                        skuPriUpInfoBo.setUpdateTime(DateUtils.dateToStr((Date)uccPriUpQryRspVO.getUpdateTime()));
                    }
                    if (uccPriUpQryRspVO.getOnShelveTime() != null) {
                        skuPriUpInfoBo.setOnShelveTime(DateUtils.dateToStr((Date)uccPriUpQryRspVO.getOnShelveTime()));
                    }
                    if (uccPriUpQryRspVO.getCommodityTypeId() != null && (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(uccPriUpQryRspVO.getCommodityTypeId())) != null) {
                        skuPriUpInfoBo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
                    }
                    skuPriUpInfoBos.add(skuPriUpInfoBo);
                }
            }
            UccPriUpQryRspBO rspBO = new UccPriUpQryRspBO();
            rspBO.setRows(skuPriUpInfoBos);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            return rspBO;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }
}

