/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.UccCommdInfoRspBO;
import com.tydic.commodity.bo.busi.UccCommdnfoReqBO;
import com.tydic.commodity.busi.api.UccQryCommdInfoBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccChannelPutMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.dao.po.UccChannelPutPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.CommodityEnum;
import com.tydic.commodity.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccQryCommdInfoBusiService"})
public class UccQryCommdInfoBusiServiceImpl
implements UccQryCommdInfoBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryCommdInfoBusiServiceImpl.class);
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccChannelPutMapper uccChannelPutMapper;

    @PostMapping(value={"queryInfomation"})
    public UccCommdInfoRspBO queryInfomation(@RequestBody UccCommdnfoReqBO reqBO) {
        UccCommdInfoRspBO rspBO = new UccCommdInfoRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccCommodityPo commdPo = new UccCommodityPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)commdPo);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<Long> commodityIds = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((String)commdPo.getCommodityName()) && CollectionUtils.isEmpty(commodityIds = this.uccCommodityMapper.queryIdByName(commdPo))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        List<UccCommodityPo> listCommds = this.uccCommodityMapper.queryPosByCommodityIds(commodityIds, commdPo, page);
        if (listCommds == null || listCommds.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccCommodityTypePo uccCommodityTypePo = null;
        UccBrandDealPO uccBrandDealPO = null;
        ArrayList<CommodityBo> listCommdBo = new ArrayList<CommodityBo>();
        CommodityBo commodityBo = null;
        ArrayList<Long> channels = null;
        for (UccCommodityPo each : listCommds) {
            SupplierShopPo supplierShopPo;
            commodityBo = new CommodityBo();
            BeanUtils.copyProperties((Object)each, (Object)commodityBo);
            uccBrandDealPO = new UccBrandDealPO();
            uccBrandDealPO.setBrandId(each.getBrandId());
            uccBrandDealPO = this.uccBrandDealMapper.selectById(uccBrandDealPO);
            if (uccBrandDealPO != null) {
                commodityBo.setBrandName(uccBrandDealPO.getBrandName());
            }
            if ((supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(each.getSupplierShopId())) != null) {
                commodityBo.setShopName(supplierShopPo.getShopName());
            }
            if ((uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(each.getCommodityTypeId())) != null) {
                commodityBo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
            }
            if (commdPo.getCreateTime() != null) {
                commodityBo.setCreateTime(DateUtils.dateToStr((Date)commdPo.getCreateTime()));
            }
            if (commdPo.getUpdateTime() != null) {
                commodityBo.setUpdateTime(DateUtils.dateToStr((Date)commdPo.getUpdateTime()));
            }
            DicDictionaryPo po = null;
            if (each.getCommodityStatus() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getCommodityStatus().toString(), CommodityEnum.COMMODITY_STATUS.toString())) != null) {
                commodityBo.setCommodityStatusDesc(po.getTitle());
                po = null;
            }
            if (each.getCommoditySource() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getCommoditySource().toString(), CommodityEnum.COMMODITY_SOURCE.toString())) != null) {
                commodityBo.setCommoditySourceDesc(po.getTitle());
                po = null;
            }
            if (each.getStoreGetType() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getStoreGetType().toString(), CommodityEnum.COMMODITY_STORE_GET_TYPE.toString())) != null) {
                commodityBo.setStoreGetTypeDesc(po.getTitle());
                po = null;
            }
            if (each.getServenRejectAllow() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getServenRejectAllow().toString(), CommodityEnum.COMMODITY_SERVEN_REJECT_ALLOW.toString())) != null) {
                commodityBo.setServenRejectAllowDesc(po.getTitle());
                po = null;
            }
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setCommodityId(commodityBo.getCommodityId());
            List<UccSkuPo> skuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
            if (skuPoList != null) {
                UccChannelPutPo uccChannelPutPo = new UccChannelPutPo();
                uccChannelPutPo.setSupplierShopId(skuPoList.get(0).getSupplierShopId());
                uccChannelPutPo.setPutObjId(skuPoList.get(0).getSkuId());
                List<UccChannelPutPo> listChannel = this.uccChannelPutMapper.qryChannels(uccChannelPutPo);
                channels = new ArrayList<Long>();
                for (UccChannelPutPo channelPutPo : listChannel) {
                    channels.add(channelPutPo.getChannelId());
                }
                commodityBo.setChannels(channels);
            }
            listCommdBo.add(commodityBo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRows(listCommdBo);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    private String verify(UccCommdnfoReqBO reqBO) {
        if (reqBO.getSupplierShopId() == null || reqBO.getSupplierShopId() == 0L) {
            return "\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u8be2\u7684\u5e97\u94fa";
        }
        return this.dataBaseVerify(reqBO);
    }

    private String dataBaseVerify(UccCommdnfoReqBO reqBO) {
        UccCommodityTypePo uccCommodityTypePo;
        if (reqBO.getSupplierShopId() != null && reqBO.getSupplierShopId() != 0L) {
            int count = 0;
            count = this.supplierShopMapper.selectSupplierShopById(reqBO.getSupplierShopId());
            if (count == 0) {
                return "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5e97\u94fa\u4fe1\u606f";
            }
        }
        if (reqBO.getCommodityTypeId() != null && reqBO.getCommodityTypeId() != 0L && (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId())) == null) {
            return "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u5546\u54c1\u7c7b\u578b\u4fe1\u606f";
        }
        if (reqBO.getBrandId() != null && reqBO.getBrandId() != 0L) {
            UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
            uccBrandDealPO.setBrandId(reqBO.getBrandId());
            uccBrandDealPO = this.uccBrandDealMapper.selectById(uccBrandDealPO);
            if (uccBrandDealPO == null) {
                return "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u54c1\u724c\u4fe1\u606f";
            }
        }
        return this.enumVerify(reqBO);
    }

    private String enumVerify(UccCommdnfoReqBO reqBO) {
        Map<String, String> enumMap;
        if (!(reqBO.getCommodityStatus() == null || (enumMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS.toString())) != null && enumMap.containsKey(reqBO.getCommodityStatus().toString()))) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5546\u54c1\u72b6\u6001";
        }
        if (!(reqBO.getCommoditySource() == null || (enumMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_SOURCE.toString())) != null && enumMap.containsKey(reqBO.getCommoditySource().toString()))) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5546\u54c1\u6765\u6e90";
        }
        return "";
    }
}

