/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.ability.UccCommodityInDetailBO;
import com.tydic.commodity.bo.busi.QryCommodityDetailListReqBO;
import com.tydic.commodity.busi.api.UccQryCommodityDetailListBusiService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccQryCommodityListsInfoMapper;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.dao.po.UccCommodityInDetailPO;
import com.tydic.commodity.dao.po.UccMallBrandRelPO;
import com.tydic.commodity.dao.po.UccQryCommoDetailPO;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListCloneUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccQryCommodityDetailListBusiService"})
public class UccQryCommodityDetailListBusiServiceImpl
implements UccQryCommodityDetailListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryCommodityDetailListBusiServiceImpl.class);
    @Autowired
    private UccQryCommodityListsInfoMapper qryCommodityListsInfoMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;

    @PostMapping(value={"qryCommodityDetailList"})
    public List<UccCommodityInDetailBO> qryCommodityDetailList(@RequestBody QryCommodityDetailListReqBO reqBO) {
        UccQryCommoDetailPO uccQryCommoDetailPO = new UccQryCommoDetailPO();
        uccQryCommoDetailPO.setSupplierShopId(reqBO.getSupplierShopId());
        uccQryCommoDetailPO.setCommodityId(reqBO.getCommodityId());
        List<UccCommodityInDetailPO> uccCommodityInDetailBO = null;
        try {
            uccCommodityInDetailBO = this.qryCommodityListsInfoMapper.queryCommodityInfoList(uccQryCommoDetailPO);
            List<Long> brandIdList = uccCommodityInDetailBO.stream().map(UccCommodityInDetailPO::getBrandId).distinct().collect(Collectors.toList());
            List<UccBrandDealPO> uccBrandDealPos = this.uccBrandDealMapper.getByIds(brandIdList);
            Map<Long, List<UccBrandDealPO>> collectByBrandId = null;
            if (!CollectionUtils.isEmpty(uccBrandDealPos)) {
                collectByBrandId = uccBrandDealPos.stream().collect(Collectors.groupingBy(UccBrandDealPO::getBrandId));
            }
            for (UccCommodityInDetailPO bo : uccCommodityInDetailBO) {
                List<UccBrandDealPO> brandDealPoList;
                if (!CollectionUtils.isEmpty(collectByBrandId) && !CollectionUtils.isEmpty(brandDealPoList = collectByBrandId.get(bo.getBrandId()))) {
                    bo.setBrandName(brandDealPoList.get(0).getBrandName());
                }
                UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
                uccMallBrandRelPo.setBrandId(bo.getBrandId());
                List<UccMallBrandRelPO> mallBrandRelPOList = this.uccMallBrandRelMapper.getList(uccMallBrandRelPo);
                if (CollectionUtils.isEmpty(mallBrandRelPOList)) continue;
                bo.setBrandId(mallBrandRelPOList.get(0).getMallBrandId());
                bo.setBrandName(mallBrandRelPOList.get(0).getMallBrandName());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a", (Throwable)e);
        }
        try {
            List commodityInDetailBOS = ListCloneUtils.clonePOListToBOListNotDate(uccCommodityInDetailBO, UccCommodityInDetailBO.class);
            return commodityInDetailBOS;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a", (Throwable)e);
            throw new BusinessException("8888", "\u67e5\u8be2\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u5931\u8d25");
        }
    }
}

