/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.ability.PropEntityBo;
import com.tydic.commodity.bo.ability.PropEntityValue;
import com.tydic.commodity.bo.ability.SpecBo;
import com.tydic.commodity.bo.busi.CommodityImageBo;
import com.tydic.commodity.bo.busi.CommodityItemBo;
import com.tydic.commodity.bo.busi.SpuSpecBo;
import com.tydic.commodity.bo.busi.UccQryCommdItemReqBO;
import com.tydic.commodity.bo.busi.UccQryCommdItemRspBO;
import com.tydic.commodity.busi.api.UccQryCommodityItemBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityDetailMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSpuSpecMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.dao.po.UccCommodityDetailPo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccCommodityPropGrpPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.dao.po.UccSpuSpecPo;
import com.tydic.commodity.enumType.CommodityEnum;
import com.tydic.commodity.enumType.SkuEnum;
import com.tydic.commodity.util.DateUtils;
import com.tydic.commodity.util.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccQryCommodityItemBusiService"})
public class UccQryCommodityItemBusiServiceImpl
implements UccQryCommodityItemBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryCommodityItemBusiServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityDetailMapper uccCommodityDetailMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSpuSpecMapper uccSpuSpecMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;

    @PostMapping(value={"qryItem"})
    public UccQryCommdItemRspBO qryItem(@RequestBody UccQryCommdItemReqBO reqBO) {
        List<UccSkuPricePo> uccSkuPricePoList;
        UccCommodityTypePo uccCommodityTypePo;
        UccQryCommdItemRspBO rspBO = new UccQryCommdItemRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        SupplierShopPo supplierShopPo = null;
        if (reqBO.getSupplierId() != null && reqBO.getSupplierId() != 0L && ((supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBO.getSupplierShopId())) == null || reqBO.getSupplierId().compareTo(supplierShopPo.getSupplierId()) != 0)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u5e97\u94fa\u4e0d\u5728\u5546\u6237\u7ba1\u7406\u4e2d");
            return rspBO;
        }
        UccSkuPo qryCommd = new UccSkuPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryCommd);
        List<UccSkuPo> listSku = this.uccSkuMapper.qerySku(qryCommd);
        if (listSku == null || listSku.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccCommodityPo commdPo = this.uccCommodityMapper.qryCommdByCommdId(reqBO.getCommodityId(), reqBO.getSupplierShopId());
        UccCommodityDetailPo uccCommodityDetailPo = this.uccCommodityDetailMapper.qryCommdByCommdId(reqBO.getCommodityId(), reqBO.getSupplierShopId());
        if (commdPo == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        CommodityItemBo commodityBo = new CommodityItemBo();
        BeanUtils.copyProperties((Object)commdPo, (Object)commodityBo);
        if (null != uccCommodityDetailPo) {
            BeanUtils.copyProperties((Object)uccCommodityDetailPo, (Object)commodityBo);
        }
        if ((uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(commdPo.getCommodityTypeId())) != null) {
            commodityBo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
        }
        if (supplierShopPo != null) {
            commodityBo.setShopName(supplierShopPo.getShopName());
        }
        UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
        uccBrandDealPO.setBrandId(commodityBo.getBrandId());
        uccBrandDealPO = this.uccBrandDealMapper.selectById(uccBrandDealPO);
        if (uccBrandDealPO != null) {
            commodityBo.setBrandName(uccBrandDealPO.getBrandName());
        }
        if (commdPo.getCreateTime() != null) {
            commodityBo.setCreateTime(DateUtils.dateToStr((Date)commdPo.getCreateTime()));
        }
        if (commdPo.getUpdateTime() != null) {
            commodityBo.setUpdateTime(DateUtils.dateToStr((Date)commdPo.getUpdateTime()));
        }
        DicDictionaryPo po = null;
        if (commdPo.getCommodityStatus() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getCommodityStatus().toString(), CommodityEnum.COMMODITY_STATUS.toString())) != null) {
            commodityBo.setCommodityStatusDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getCommoditySource() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getCommoditySource().toString(), CommodityEnum.COMMODITY_SOURCE.toString())) != null) {
            commodityBo.setCommoditySourceDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getStoreGetType() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getStoreGetType().toString(), CommodityEnum.COMMODITY_STORE_GET_TYPE.toString())) != null) {
            commodityBo.setStoreGetTypeDesc(po.getTitle());
            po = null;
        }
        if (commdPo.getServenRejectAllow() != null && (po = this.uccDictionaryAtomService.queryByCodeAndPcode(commdPo.getServenRejectAllow().toString(), CommodityEnum.COMMODITY_SERVEN_REJECT_ALLOW.toString())) != null) {
            commodityBo.setServenRejectAllowDesc(po.getTitle());
            po = null;
        }
        UccSpuSpecPo uccSpuSpecPo = new UccSpuSpecPo();
        uccSpuSpecPo.setCommodityId(commdPo.getCommodityId());
        uccSpuSpecPo.setSupplierShopId(commdPo.getSupplierShopId());
        List<UccSpuSpecPo> listSpuSpec = this.uccSpuSpecMapper.querySpec(uccSpuSpecPo);
        if (listSpuSpec != null && listSpuSpec.size() > 0) {
            ArrayList<SpuSpecBo> spuSpecBos = new ArrayList<SpuSpecBo>();
            SpuSpecBo bo = null;
            for (UccSpuSpecPo each : listSpuSpec) {
                bo = new SpuSpecBo();
                BeanUtils.copyProperties((Object)each, (Object)bo);
                spuSpecBos.add(bo);
            }
            this.formatSpec(spuSpecBos, commodityBo);
        }
        UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
        uccCommodityPicPo.setCommodityId(commdPo.getCommodityId());
        uccCommodityPicPo.setSupplierShopId(commdPo.getSupplierShopId());
        List<UccCommodityPicPo> listPic = this.uccCommodityPicMapper.queryCommdPic(uccCommodityPicPo);
        if (listPic != null && listPic.size() > 0) {
            CommodityImageBo bo = null;
            ArrayList<CommodityImageBo> listBo = new ArrayList<CommodityImageBo>();
            for (UccCommodityPicPo each : listPic) {
                bo = new CommodityImageBo();
                BeanUtils.copyProperties((Object)each, (Object)bo);
                if (each.getCreateTime() != null) {
                    bo.setCreateTime(DateUtils.dateToStr((Date)each.getCreateTime()));
                }
                if (each.getUpdateTime() != null) {
                    bo.setUpdateTime(DateUtils.dateToStr((Date)each.getUpdateTime()));
                }
                listBo.add(bo);
            }
            commodityBo.setCommdImages(listBo);
        }
        if ((uccSkuPricePoList = this.uccSkuPriceMapper.queryPriceOrderBySaleAsc(commodityBo.getCommodityId(), commodityBo.getSupplierShopId())) != null && uccSkuPricePoList.size() > 0) {
            commodityBo.setPrice(MoneyUtils.haoToYuan((Long)uccSkuPricePoList.get(0).getSalePrice()));
            commodityBo.setMarketPrice(MoneyUtils.haoToYuan((Long)uccSkuPricePoList.get(0).getMarketPrice()));
        } else {
            commodityBo.setPrice(new BigDecimal(0));
            commodityBo.setMarketPrice(new BigDecimal(0));
        }
        List<UccSaleNumPo> uccSaleNumPoList = this.uccSaleNumMapper.qryEcommerceSaleOrderByDesc(commodityBo.getCommodityId(), commodityBo.getSupplierShopId());
        if (uccSaleNumPoList != null && uccSaleNumPoList.size() > 0) {
            commodityBo.setEccommerSale(uccSaleNumPoList.get(0).getEcommerceSale());
        } else {
            commodityBo.setEccommerSale(new BigDecimal(0));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        rspBO.setCommodity(commodityBo);
        return rspBO;
    }

    private String verify(UccQryCommdItemReqBO reqBO) {
        if (reqBO.getSupplierShopId() == null || reqBO.getSupplierShopId() == 0L) {
            return "\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u8be2\u7684\u5e97\u94fa";
        }
        if (reqBO.getCommodityId() == null) {
            return "\u8bf7\u9009\u62e9\u67e5\u8be2\u7684\u5546\u54c1\u4fe1\u606f";
        }
        return this.enumVerify(reqBO);
    }

    private String enumVerify(UccQryCommdItemReqBO reqBO) {
        Map<String, String> enumMap;
        if (!(reqBO.getSkuStatus() == null || (enumMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString())) != null && enumMap.containsKey(reqBO.getSkuStatus().toString()))) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u54c1\u72b6\u6001";
        }
        return "";
    }

    public void formatSpec(List<SpuSpecBo> specBos, CommodityItemBo commodityBo) {
        if (specBos.isEmpty()) {
            return;
        }
        HashMap group = new HashMap();
        for (SpuSpecBo each : specBos) {
            if (group.containsKey(each.getCommodityPropGrpId())) {
                ((List)group.get(each.getCommodityPropGrpId())).add(each);
                continue;
            }
            ArrayList<SpuSpecBo> spuSpecBos = new ArrayList<SpuSpecBo>();
            spuSpecBos.add(each);
            group.put(each.getCommodityPropGrpId(), spuSpecBos);
        }
        ArrayList<SpecBo> specBoList = new ArrayList<SpecBo>();
        SpecBo bo = new SpecBo();
        Iterator iterator = group.entrySet().iterator();
        while (iterator.hasNext()) {
            bo = new SpecBo();
            Map.Entry map = iterator.next();
            UccCommodityPropGrpPo grpPo = this.uccCommodityPropGrpMapper.queryGroupByGrpId((Long)map.getKey());
            bo.setCommodityPropGrpId(grpPo.getCommodityPropGrpId());
            bo.setCommodityPropGrpCode(grpPo.getCommodityPropGrpCode());
            bo.setCommodityPropGrpName(grpPo.getCommodityPropGrpName());
            bo.setCommodityPropGrpType(grpPo.getCommodityPropGrpType());
            ArrayList commodityProps = new ArrayList();
            PropEntityBo propEntityBo = null;
            HashedMap defMap = new HashedMap();
            for (SpuSpecBo spec : (List)map.getValue()) {
                PropEntityValue value = new PropEntityValue();
                if (defMap.containsKey(spec.getCommodityPropDefId())) {
                    value.setPropValue(spec.getPropValue());
                    value.setPropValueListId(spec.getPropValueListId());
                    ((PropEntityBo)defMap.get(spec.getCommodityPropDefId())).getSalePropEntityValue().add(value);
                    continue;
                }
                ArrayList<PropEntityValue> salePropEntityValue = new ArrayList<PropEntityValue>();
                PropEntityValue propEntityValue = new PropEntityValue();
                propEntityValue.setPropValueListId(spec.getPropValueListId());
                propEntityValue.setPropValue(spec.getPropValue());
                salePropEntityValue.add(propEntityValue);
                propEntityBo = new PropEntityBo();
                propEntityBo.setCommodityPropDefId(spec.getCommodityPropDefId());
                propEntityBo.setPropName(spec.getPropName());
                propEntityBo.setShowName(spec.getPropShowName());
                propEntityBo.setSalePropEntityValue(salePropEntityValue);
                defMap.put(spec.getCommodityPropDefId(), propEntityBo);
            }
            commodityProps.addAll(defMap.values());
            bo.setCommodityDefs(commodityProps);
            specBoList.add(bo);
        }
        commodityBo.setCommodityProps(specBoList);
    }
}

