/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.QuerySkuStateBO;
import com.tydic.commodity.bo.busi.UccQuerySkuStateReqBO;
import com.tydic.commodity.bo.busi.UccQuerySkuStateRspBO;
import com.tydic.commodity.busi.api.UccQrySkuStateMockService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccQrySkuStateMockService"})
public class UccQrySkuStateMockServiceImpl
implements UccQrySkuStateMockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQrySkuStateMockServiceImpl.class);
    @Autowired
    private UccSkuMapper skuMapper;

    @PostMapping(value={"skuState"})
    public UccQuerySkuStateRspBO skuState(@RequestBody UccQuerySkuStateReqBO reqBO) {
        List<String> skuId;
        UccQuerySkuStateRspBO rspBO = new UccQuerySkuStateRspBO();
        String[] sku = reqBO.getSku();
        try {
            skuId = Arrays.asList(sku);
        }
        catch (BusinessException e) {
            LOGGER.error(e.getMsgInfo() + ":" + (Object)((Object)e));
            rspBO.setRespCode(e.getMsgCode());
            rspBO.setRespDesc(e.getMsgInfo());
            return rspBO;
        }
        ArrayList<QuerySkuStateBO> skuStateBOS = new ArrayList<QuerySkuStateBO>();
        List<UccSkuPo> uccSkuPos = this.skuMapper.qerySkusByExtSkuIds(skuId);
        for (UccSkuPo uccSkuPo : uccSkuPos) {
            QuerySkuStateBO querySkuStateBO = new QuerySkuStateBO();
            querySkuStateBO.setSku(uccSkuPo.getExtSkuId());
            querySkuStateBO.setState(Integer.valueOf(uccSkuPo.getSkuStatus() == 3 ? 1 : 0));
            skuStateBOS.add(querySkuStateBO);
        }
        rspBO.setResult(skuStateBOS);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("8888");
        return rspBO;
    }
}

