/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.UccSearchHotWordAnalyseBO;
import com.tydic.commodity.bo.busi.UccSearchHotWordAnalyseTaskReqBO;
import com.tydic.commodity.bo.busi.UccSearchHotWordAnalyseTaskRspBO;
import com.tydic.commodity.busi.api.UccSearchHotWordAnalyseTaskBusiService;
import com.tydic.commodity.dao.UccGoodsSearchRecordMapper;
import com.tydic.commodity.dao.UccSearchHotWordMapper;
import com.tydic.commodity.dao.po.UccSearchHotWordPO;
import com.tydic.commodity.enumType.CommonStatusEnum;
import com.tydic.commodity.util.ListUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.commodity.busi.api.UccSearchHotWordAnalyseTaskBusiService"})
public class UccSearchHotWordAnalyseTaskBusiServiceImpl
implements UccSearchHotWordAnalyseTaskBusiService {
    @Autowired
    private UccGoodsSearchRecordMapper uccGoodsSearchRecordMapper;
    @Autowired
    private UccSearchHotWordMapper uccSearchHotWordMapper;
    private Sequence sequence = Sequence.getInstance();
    private static final BigDecimal COEFFICIENT = new BigDecimal("0.1");
    private static final Integer BATCH_SIZE = 200;

    @PostMapping(value={"dealSearchHotWordAnalyse"})
    public UccSearchHotWordAnalyseTaskRspBO dealSearchHotWordAnalyse(@RequestBody UccSearchHotWordAnalyseTaskReqBO reqBo) {
        UccSearchHotWordAnalyseTaskRspBO rspBo = new UccSearchHotWordAnalyseTaskRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        List<UccSearchHotWordAnalyseBO> searchHotWordAnalyseResult = this.uccGoodsSearchRecordMapper.getSearchHotWordAnalyseResult();
        if (CollectionUtils.isEmpty(searchHotWordAnalyseResult)) {
            return rspBo;
        }
        List<UccSearchHotWordAnalyseBO> needInsertList = this.uccSearchHotWordMapper.checkInsert();
        if (!CollectionUtils.isEmpty(needInsertList)) {
            ArrayList<UccSearchHotWordPO> insertList = new ArrayList<UccSearchHotWordPO>();
            needInsertList.forEach(bo -> {
                UccSearchHotWordPO uccSearchHotWordPo = new UccSearchHotWordPO();
                uccSearchHotWordPo.setSearchHotWordId(this.sequence.nextId());
                uccSearchHotWordPo.setSearchHotWord(bo.getThirdCategoryName());
                uccSearchHotWordPo.setStates((long)CommonStatusEnum.effective.getStatus());
                uccSearchHotWordPo.setThirdCategoryId(bo.getThirdCategoryId());
                uccSearchHotWordPo.setThirdCategoryName(bo.getThirdCategoryName());
                uccSearchHotWordPo.setChannelId(bo.getChannelId());
                uccSearchHotWordPo.setCreateTime(new Date());
                uccSearchHotWordPo.setHotValue(BigDecimal.ZERO);
                uccSearchHotWordPo.setCreateOper("SYS_TIME_TASK");
                insertList.add(uccSearchHotWordPo);
            });
            this.uccSearchHotWordMapper.insertBatch(insertList);
        }
        this.uccGoodsSearchRecordMapper.truncateRecord();
        searchHotWordAnalyseResult.forEach(result -> result.setHot(result.getTotalCount().multiply(COEFFICIENT)));
        Map batchList = ListUtils.batchList(searchHotWordAnalyseResult, (int)BATCH_SIZE);
        batchList.forEach((key, valueList) -> this.uccSearchHotWordMapper.updateHotValueBatch((List<UccSearchHotWordAnalyseBO>)valueList));
        return rspBo;
    }
}

